/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag.util;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.util.WmiDagVisitOperation;
import com.maplesoft.client.dag.util.WmiDagVisitor;
import com.maplesoft.client.dag.util.WmiDagWalkNode;
import com.maplesoft.client.dag.util.WmiDagWalkerContext;

public abstract class WmiAbstractDagVisitor
implements WmiDagVisitor {
    protected static final int DAG_CASE_COUNT = 61;
    private static final String[] DEFAULT_ELEMENT_NAMES = new String[]{"", "intneg", "intpos", "rational", "float", "hfloat", "complex", "string", "name", "member", "tableref", "dcolon", "catenate", "power", "prod", "series", "sum", "zppoly", "function", "uneval", "equation", "inequat", "lesseq", "lessthan", "and", "not", "or", "xor", "implies", "expseq", "list", "local", "param", "lexical", "proc", "range", "set", "table", "rtable", "moddef", "module", "assign", "for", "if", "read", "save", "statseq", "stop", "error", "try", "return", "break", "next", "use", "binary", "hash", "backref", "garbage", "foreign", "control", "debug"};
    protected static final int DEFAULT_TYPE_INDEX = 0;
    protected static final WmiDagVisitOperation DEFAULT_VISIT_OP = new WmiDefaultDagVisitOperation();
    private WmiDagVisitOperation[] dagVisitOps = new WmiDagVisitOperation[61];
    private String[] elementNames = new String[61];

    public WmiAbstractDagVisitor() {
        this.dagVisitOps[0] = DEFAULT_VISIT_OP;
        this.initializeDagVisitOps();
    }

    @Override
    public void enqueue(WmiDagWalkNode parentNode, WmiDagWalkerContext context) {
        Dag dag = parentNode.getDag();
        if (dag instanceof BranchDag) {
            BranchDag branch = (BranchDag)dag;
            int i = branch.getLength() - 1;
            while (i > -1) {
                Dag child = branch.getChild(i);
                context.pushForVisit(child, parentNode);
                --i;
            }
        }
    }

    protected String getDagTypeName(Dag dag) {
        int type = dag.getType();
        if (type >= 0 || type < 61) {
            return this.getDagTypeName(type);
        }
        return this.getDagTypeName(0);
    }

    protected String getDagTypeName(int type) {
        String name = this.elementNames[type];
        if (name == null) {
            name = DEFAULT_ELEMENT_NAMES[type];
        }
        return name;
    }

    protected String getDagTypeName(WmiDagWalkNode walkNode) {
        return this.getDagTypeName(walkNode.getDag());
    }

    public WmiDagVisitOperation getDagVisitOp(int type) {
        return this.dagVisitOps[type];
    }

    protected WmiDagVisitOperation getVisitOperation(WmiDagWalkNode walkNode) {
        WmiDagVisitOperation visitOperation = null;
        Dag dag = walkNode.getDag();
        int type = dag.getType();
        if (type > 0 || type < 61) {
            visitOperation = this.getDagVisitOp(type);
        }
        if (visitOperation == null) {
            visitOperation = this.getDagVisitOp(0);
        }
        return visitOperation;
    }

    protected abstract void initializeDagVisitOps();

    protected void setDagTypeName(int type, String name) {
        this.elementNames[type] = name;
    }

    protected void setDagVisitOp(int type, WmiDagVisitOperation operation) {
        this.dagVisitOps[type] = operation;
    }

    @Override
    public void visit(WmiDagWalkNode walkNode, WmiDagWalkerContext context) {
        WmiDagVisitOperation op = this.getVisitOperation(walkNode);
        op.performOperation(walkNode, context);
    }

    private static class WmiDefaultDagVisitOperation
    implements WmiDagVisitOperation {
        private WmiDefaultDagVisitOperation() {
        }

        @Override
        public void performOperation(WmiDagWalkNode walkNode, WmiDagWalkerContext context) {
        }
    }
}

