/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag.util;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.util.WmiDagVisitor;
import com.maplesoft.client.dag.util.WmiDagWalkNode;
import com.maplesoft.client.dag.util.WmiDagWalkerContext;

public class WmiDagWalker {
    private WmiDagWalkerContext context;
    private WmiDagWalkNode currentNode = null;

    public WmiDagWalker(Dag startDag, WmiDagVisitor startVisitor) {
        this(startDag, startVisitor, null);
    }

    public WmiDagWalker(Dag startDag, WmiDagVisitor startVisitor, WmiDagWalkerContext theContext) {
        this.context = theContext != null ? theContext : new WmiDagWalkerContext();
        if (this.context.getResult() == null) {
            this.context.createStartingResult(startVisitor);
        }
        this.context.pushForVisit(new WmiDagWalkNode(startDag, startVisitor));
    }

    public WmiDagWalkerContext getContext() {
        return this.context;
    }

    private WmiDagWalkNode getCurrentNode() {
        return this.currentNode;
    }

    private boolean getNextStep() {
        this.currentNode = this.context.popForVisit();
        return this.currentNode != null;
    }

    public Object getResult() {
        Object result = null;
        if (this.getContext() != null) {
            result = this.getContext().getResult();
        }
        return result;
    }

    private void performStep() {
        if (this.currentNode != null) {
            WmiDagVisitor visitor = this.currentNode.getVisitor();
            visitor.enqueue(this.currentNode, this.context);
            visitor.visit(this.currentNode, this.context);
        }
    }

    private void setCurrentNode(WmiDagWalkNode currentNode) {
        this.currentNode = currentNode;
    }

    public void walk() {
        while (this.getNextStep()) {
            this.performStep();
        }
    }
}

