/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.kernelresult;

import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.dag.AttributedLeafDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.ExpseqDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.kernelresult.AbstractKernelResult;
import com.maplesoft.util.FormatConverter;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.TransformerException;

public class KernelErrorResult
extends AbstractKernelResult {
    public static final int ERROR_TEXT_MESSAGE = 1;
    public static final int ERROR_TEXT_ARGUMENT = 2;
    public static final int ERROR_TEXT_ORDINAL_ARGUMENT = 3;

    public KernelErrorResult() {
        super(1);
    }

    @Override
    public KernelEvent readResults(InputStream is, KernelListener listener) {
        KernelEvent event = this.readTextResults(is, listener, true);
        return event;
    }

    @Override
    protected boolean fireEvent(KernelListener listener, KernelEvent event) {
        return listener.processError(event);
    }

    public static FormattedErrorMessage parseErrorMessage(KernelEvent event) {
        FormattedErrorMessage error = null;
        error = event.getDag() == null ? new FormattedErrorMessage(event.getText()) : new FormattedErrorMessage(event);
        return error;
    }

    public static KernelEvent create(String errorMessage, KernelListener listener) {
        Dag[] args = new Dag[]{Dag.createDag(2, null, "4", false), Dag.createDag(7, null, errorMessage, true)};
        Dag errorDag = ExpseqDagFactory.createExpseqDag(args);
        StringBuffer dotmBuf = new StringBuffer();
        DagBuilder.writeDotm(dotmBuf, errorDag);
        KernelEvent event = new KernelEvent(1, dotmBuf.toString(), true, listener);
        event.setStreamName("EXCEPT");
        return event;
    }

    public static class ArgumentText
    extends ErrorText {
        public ArgumentText(String argText) {
            super(argText);
            this.type = 2;
        }
    }

    public static class ErrorFormatException
    extends TransformerException {
        public ErrorFormatException(TransformerException transE) {
            super(transE);
        }
    }

    static abstract class ErrorText {
        protected String text;
        protected int type = 0;

        protected ErrorText(String errorText) {
            this.text = errorText;
        }

        public int getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class FormattedErrorMessage {
        private static final int ERROR_DAG_INIT_ARG_POSITION = 0;
        private static final int ERROR_DAG_MESSAGE_POSITION = 1;
        private static final String UNSPECIFIED_ERROR_INIT_ARG = "unspecified";
        protected String initialArgument;
        protected String message;
        protected List stringElements = new LinkedList();
        protected List arguments = new LinkedList();
        protected ArgumentText initialText;
        protected int initialArgumentNumeric = 0;
        protected int warningLevel = 0;
        private static final String MODULE_APPLY_NAME = ":-ModuleApply";

        FormattedErrorMessage(String errorMessage) {
            this.initialArgument = errorMessage;
            this.stringElements.add(new MessageText(this.initialArgument));
            this.message = this.initialArgument;
        }

        FormattedErrorMessage(KernelEvent error) {
            Dag initialArgDag;
            Dag errorDag = error.getDag();
            Dag dag = initialArgDag = errorDag.getLength() > 0 ? errorDag.getChild(0) : null;
            this.initialArgument = initialArgDag instanceof AttributedLeafDag ? initialArgDag.getData() : (initialArgDag == null ? UNSPECIFIED_ERROR_INIT_ARG : DagBuilder.lPrint(initialArgDag));
            String initialData = this.initialArgument;
            initialData = this.removeModuleApply(initialData);
            try {
                this.warningLevel = Integer.parseInt(initialData);
            }
            catch (Exception e1) {
                this.initialText = new ArgumentText("(in " + initialData + ") ");
            }
            Dag messageDag = errorDag.getLength() > 0 ? errorDag.getChild(1) : errorDag;
            this.message = messageDag.getData();
            try {
                this.message = (String)FormatConverter.convert("expentity:", this.message, "String");
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuffer argument = new StringBuffer();
            int i = 2;
            while (i < errorDag.getLength()) {
                WmiLPrintOptions options = new WmiLPrintOptions();
                options.setInLineIfPossible(true);
                String lprint = DagBuilder.lPrint(errorDag.getChild(i), options);
                argument.append(lprint);
                if (argument.length() > 0) {
                    if (argument.charAt(0) == '\"' && argument.charAt(argument.length() - 1) == '\"') {
                        argument.deleteCharAt(0);
                        argument.deleteCharAt(argument.length() - 1);
                    } else if (argument.charAt(0) == '`' && argument.charAt(1) == '`') {
                        argument.delete(0, 2);
                    }
                }
                String finalArgument = this.removeModuleApply(argument.toString());
                this.arguments.add(finalArgument);
                argument.setLength(0);
                ++i;
            }
            this.stringElements = this.buildFinalString(this.message, this.arguments);
        }

        private String removeModuleApply(String text) {
            if (text != null) {
                if (text.endsWith(MODULE_APPLY_NAME)) {
                    text = text.substring(0, text.indexOf(MODULE_APPLY_NAME));
                } else if (text.endsWith(":-ModuleApply'") || text.endsWith(":-ModuleApply`") || text.endsWith(":-ModuleApply\"")) {
                    String quote = text.substring(text.length() - 1);
                    text = text.substring(0, text.indexOf(MODULE_APPLY_NAME));
                    text = String.valueOf(text) + quote;
                }
            }
            return text;
        }

        private List buildFinalString(String pattern, List args) {
            LinkedList<ErrorText> errorSequence = new LinkedList<ErrorText>();
            StringBuffer buf = new StringBuffer();
            char[] patchars = pattern.toCharArray();
            char lahd = '\u0000';
            if (this.initialText != null) {
                errorSequence.add(this.initialText);
            }
            int i = 0;
            while (i < patchars.length) {
                if (patchars[i] == '%') {
                    String text;
                    int number;
                    lahd = patchars[i + 1];
                    if (lahd == '-') {
                        number = this.readNumbers(patchars, i + 2);
                        if (number > 0) {
                            i += Integer.toString(number).length() + 1;
                            text = "";
                            text = this.getArgument(args, number, "%-");
                            this.addMessage(errorSequence, buf);
                            try {
                                Integer.parseInt(text);
                            }
                            catch (Exception e3) {
                                text = "%-" + number;
                            }
                            errorSequence.add(new OrdinalArgumentText(text));
                        } else {
                            buf.insert(i, "%");
                        }
                    } else if (Character.isDigit(lahd)) {
                        number = this.readNumbers(patchars, i + 1);
                        i += Integer.toString(number).length();
                        this.addMessage(errorSequence, buf);
                        if (number != 0) {
                            text = this.getArgument(args, number, "%");
                            errorSequence.add(new ArgumentText(text));
                        } else {
                            Iterator argIt = args.iterator();
                            while (argIt.hasNext()) {
                                String arg = (String)argIt.next();
                                errorSequence.add(new ArgumentText(arg));
                                if (!argIt.hasNext()) continue;
                                errorSequence.add(new MessageText(", "));
                            }
                        }
                    } else {
                        buf.append(patchars[i]);
                    }
                } else {
                    buf.append(patchars[i]);
                }
                ++i;
            }
            this.addMessage(errorSequence, buf);
            return errorSequence;
        }

        private String getArgument(List args, int number, String prepend) {
            String toreturn = "";
            toreturn = number - 1 >= args.size() || number - 1 < 0 ? String.valueOf(prepend) + number : (String)args.get(number - 1);
            return toreturn;
        }

        private void addMessage(List errorSequence, StringBuffer buf) {
            if (buf.length() > 0) {
                errorSequence.add(new MessageText(buf.toString()));
                buf.setLength(0);
            }
        }

        private int readNumbers(char[] source, int position) {
            StringBuffer sb = new StringBuffer();
            int returnint = -1;
            char lahd = '\u0000';
            int i = position;
            while (i < source.length) {
                lahd = source[i];
                if (!Character.isDigit(lahd)) break;
                sb.append(lahd);
                ++i;
            }
            try {
                returnint = Integer.parseInt(sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return returnint;
        }

        public String getText() {
            StringBuffer sb = new StringBuffer();
            Iterator elIt = this.stringElements.iterator();
            while (elIt.hasNext()) {
                sb.append(((ErrorText)elIt.next()).getText());
            }
            return sb.toString();
        }

        public String getSourceText() {
            return this.message;
        }

        public List getArguments() {
            return this.arguments;
        }

        public Iterator messageIterator() {
            return this.stringElements.iterator();
        }

        public String getInitialArgument() {
            return this.initialArgument;
        }

        public int getWarningLevel() {
            return this.warningLevel;
        }
    }

    public static class MessageText
    extends ErrorText {
        public MessageText(String messageText) {
            super(messageText);
            this.type = 1;
        }
    }

    public static class OrdinalArgumentText
    extends ArgumentText {
        public OrdinalArgumentText(String argText) {
            super(argText);
            this.type = 3;
            this.text = !argText.startsWith("%-") ? this.createOrdinalForm(argText) : argText;
        }

        private String createOrdinalForm(String integerText) {
            String modifiedString = null;
            try {
                Integer.parseInt(integerText);
                modifiedString = integerText.endsWith("11") || integerText.endsWith("12") || integerText.endsWith("13") ? String.valueOf(integerText) + "th" : (integerText.endsWith("3") ? String.valueOf(integerText) + "rd" : (integerText.endsWith("2") ? String.valueOf(integerText) + "nd" : (integerText.endsWith("1") ? String.valueOf(integerText) + "st" : String.valueOf(integerText) + "th")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return modifiedString;
        }
    }
}

