/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.kernelresult;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.RedirectedKernelListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.kernelresult.AbstractKernelResult;
import com.maplesoft.util.Slashifier;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class KernelRedirectResult
extends AbstractKernelResult {
    public KernelRedirectResult() {
        super(6);
    }

    @Override
    public KernelEvent readResults(InputStream is, KernelListener listener) {
        KernelEvent event = this.readDotm(is, listener);
        event.setStreamName("REDIRECT");
        return event;
    }

    @Override
    public boolean fireEvent(KernelListener listener, KernelEvent event) {
        return listener.processRedirect(event);
    }

    public static RedirectedKernelListener createDefaultRedirectedKernelListener(KernelConnection connection, Redirector redirector) {
        return new RedirectedKernelListener(connection, redirector);
    }

    public static Redirector parseKernelRedirectResult(int kernelID, KernelEvent e) {
        return new Redirector(kernelID, e);
    }

    public static class Redirector {
        public static final int REDIRECT_MODE_CANCELLED = 0;
        public static final int REDIRECT_MODE_INACTIVE = 0;
        public static final int REDIRECT_MODE_OVERWRITE = 1;
        public static final int REDIRECT_MODE_APPEND = 2;
        public static final int REDIRECT_ARGUMENT_OVERWRITE = 0;
        public static final int REDIRECT_ARGUMENT_APPEND = 1;
        protected String filename;
        protected int redirectMode;
        private FileWriter file;
        private int kernelID;

        private Redirector() {
            this.redirectMode = 0;
            this.filename = null;
            this.file = null;
        }

        protected Redirector(int kernelId, KernelEvent event) {
            try {
                this.kernelID = kernelId;
                Dag dag = event.getDag();
                this.filename = null;
                if (dag.getType() == 29 && dag.getLength() >= 2) {
                    Dag filenameDag = dag.getChild(0);
                    Dag modeDag = dag.getChild(1);
                    String string = this.filename = filenameDag != null ? filenameDag.getData() : null;
                    if (this.filename != null && this.filename.length() == 0) {
                        this.filename = null;
                    }
                    int n = this.redirectMode = modeDag != null ? Integer.parseInt(modeDag.getData()) : 0;
                    this.redirectMode = this.redirectMode == 0 ? 1 : (this.redirectMode == 1 ? 2 : 0);
                }
                if (this.filename != null) {
                    this.openFile(this.filename);
                } else {
                    this.finishRedirector();
                }
            }
            catch (Exception e1) {
                String err = this.filename;
                this.finishRedirector();
                KernelProxy.getInstance().urgentInternalEvaluate(kernelId, event.getSource(), this.createErrorMessage(err), 41);
            }
        }

        private String createErrorMessage(String errfilename) {
            StringBuffer err = new StringBuffer("ERROR(\"");
            err.append("cannot open file \\\"");
            errfilename = Slashifier.slashify(errfilename);
            err.append(errfilename);
            err.append("\\\" to write to");
            err.append("\"):");
            return err.toString();
        }

        private void finishRedirector() {
            try {
                this.closeFile();
                this.filename = null;
                this.file = null;
                this.redirectMode = 0;
                KernelProxy.getInstance().setRedirectedListener(this.kernelID, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isCancelled() {
            return this.redirectMode == 0;
        }

        public boolean isActive() {
            return this.redirectMode != 0;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getRedirectMode() {
            return this.redirectMode;
        }

        public FileWriter getWriter() {
            return this.file;
        }

        public void openFile(String fileName) throws IOException {
            if (this.filename != null && !this.filename.equals(fileName)) {
                this.file.close();
            }
            this.file = new FileWriter(fileName, this.redirectMode == 2);
        }

        public void writeString(String toWrite) throws IOException {
            if (this.file != null) {
                this.file.write(toWrite);
                this.file.flush();
            }
        }

        public void closeFile() throws IOException {
            if (this.file != null) {
                this.file.close();
            }
        }
    }
}

