/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.preprocessor;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.preprocessor.PreprocessorRuleInterface;
import java.util.HashMap;

public class HelpTransformationRule
implements PreprocessorRuleInterface {
    private String MODE_HELP = "help";
    private String MODE_USAGE = "usage";
    private String MODE_EXAMPLE = "example";
    public static final HashMap specialHelp = new HashMap();

    static {
        HelpTransformationRule.populateCharacterHelpTable();
    }

    @Override
    public String[] preprocess(String[] commands, KernelConnection connection) {
        int i = 0;
        while (i < commands.length) {
            commands[i] = this.transformString(commands[i]);
            if (commands[i].startsWith("help") && (commands.length <= i + 1 || commands.length > i + 1 && !commands[i + 1].equals(";") && !commands[i + 1].equals(":"))) {
                commands[i] = String.valueOf(commands[i]) + ";";
            }
            ++i;
        }
        return commands;
    }

    @Override
    public String[] preprocess(String commands, KernelConnection connection) {
        String[] commandsa = new String[]{this.transformString(commands)};
        return commandsa;
    }

    private int getQuoteDepth(String s, int index) {
        if (s.charAt(index) != '\"') {
            return -1;
        }
        int i = index;
        while (i - 1 >= 0 && s.charAt(i - 1) == '\\') {
            --i;
        }
        return index - i;
    }

    private boolean isQuoted(String s, int index) {
        boolean opened = false;
        int i = 0;
        while (i < index) {
            if (s.charAt(i) == '\"' && this.getQuoteDepth(s, i) == 0) {
                opened = !opened;
            }
            ++i;
        }
        return opened;
    }

    protected String transformString(String command) {
        String returnstr = command;
        if (specialHelp.containsKey(command)) {
            returnstr = (String)specialHelp.get(command);
        } else {
            StringBuffer commandBuilder = new StringBuffer(command);
            int index = command.indexOf(63);
            if (!(index != 0 && (index <= 0 || command.charAt(index - 1) != '\n' && command.charAt(index - 1) != ';') || this.isQuoted(command, index))) {
                int start = -1;
                int end = -1;
                int i = 0;
                while (i < commandBuilder.length()) {
                    char nextChar;
                    char c = commandBuilder.charAt(i);
                    boolean startLock = false;
                    if (i - 1 >= 0) {
                        int k = i - 1;
                        while (k > 0) {
                            char pc = commandBuilder.charAt(k);
                            if (pc != ' ') {
                                if (pc == ':') {
                                    if (k < commandBuilder.length() - 1) {
                                        nextChar = commandBuilder.charAt(k + 1);
                                        startLock = nextChar != '-';
                                        break;
                                    }
                                } else {
                                    startLock = pc == '\n' || pc == ';';
                                    break;
                                }
                            }
                            --k;
                        }
                    } else {
                        startLock = true;
                    }
                    if (c == '?' && startLock) {
                        start = i;
                        int j = i;
                        while (j < commandBuilder.length()) {
                            char ec = commandBuilder.charAt(j);
                            if (ec == ':' && j < commandBuilder.length() - 1 && (nextChar = commandBuilder.charAt(j + 1)) != '-') {
                                end = j;
                                i = 0;
                                break;
                            }
                            if (ec == ';' || ec == '\n' || j == commandBuilder.length() - 1) {
                                end = j;
                                i = 0;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (start > -1 && end > -1) {
                        char endQuote;
                        String helpSub = this.MODE_HELP;
                        int repEnd = start + 1;
                        if (start + 1 < commandBuilder.length() && commandBuilder.charAt(start + 1) == '?') {
                            helpSub = this.MODE_USAGE;
                            ++repEnd;
                            --end;
                        }
                        if (start + 1 < commandBuilder.length() && commandBuilder.charAt(start + 1) == '?' && start + 2 < commandBuilder.length() && commandBuilder.charAt(start + 2) == '?') {
                            helpSub = this.MODE_EXAMPLE;
                            ++repEnd;
                            --end;
                        }
                        commandBuilder.replace(start, repEnd, helpSub);
                        commandBuilder.insert(start += helpSub.length(), "(");
                        char startQuote = commandBuilder.charAt(++start);
                        if (startQuote == '\"' || startQuote == '`' || startQuote == '\'') {
                            commandBuilder.deleteCharAt(start);
                            --end;
                        }
                        commandBuilder.insert(start, "\"");
                        char terminationChar = ';';
                        char endChar = commandBuilder.charAt((end += helpSub.length() + 2) - 1);
                        if (endChar == ';' || endChar == ':' || endChar == '\n') {
                            if (endChar == ':') {
                                terminationChar = ':';
                            }
                            commandBuilder.deleteCharAt(end - 1);
                            --end;
                        }
                        if ((endQuote = commandBuilder.charAt(end - 1)) == '\"' || endQuote == '`' || endQuote == '\'') {
                            commandBuilder.deleteCharAt(end - 1);
                            --end;
                        }
                        commandBuilder.insert(end, "\"");
                        commandBuilder.insert(++end, ")");
                        commandBuilder.insert(end + 1, terminationChar);
                        start = -1;
                        end = -1;
                        break;
                    }
                    ++i;
                }
                returnstr = commandBuilder.toString();
            }
        }
        return returnstr;
    }

    protected static final void populateCharacterHelpTable() {
        String HELP_COLON = "help(\";\");";
        String USAGE_COLON = "usage(\";\");";
        String EG_COLON = "example(\";\");";
        specialHelp.put("?;", HELP_COLON);
        specialHelp.put("?;;", HELP_COLON);
        specialHelp.put("?;:", HELP_COLON);
        specialHelp.put("?\";\"", HELP_COLON);
        specialHelp.put("?\";\";", HELP_COLON);
        specialHelp.put("?\";\":", HELP_COLON);
        specialHelp.put("??;", USAGE_COLON);
        specialHelp.put("??;;", USAGE_COLON);
        specialHelp.put("??;:", USAGE_COLON);
        specialHelp.put("??\";\"", USAGE_COLON);
        specialHelp.put("??\";\";", USAGE_COLON);
        specialHelp.put("??\";\":", USAGE_COLON);
        specialHelp.put("???;", EG_COLON);
        specialHelp.put("???;;", EG_COLON);
        specialHelp.put("???;:", EG_COLON);
        specialHelp.put("???\";\"", EG_COLON);
        specialHelp.put("???\";\";", EG_COLON);
        specialHelp.put("???\";\":", EG_COLON);
        String HELP_SEMICOLON = "help(\":\");";
        String USAGE_SEMICOLON = "usage(\":\");";
        String EG_SEMICOLON = "example(\":\");";
        specialHelp.put("?:", HELP_SEMICOLON);
        specialHelp.put("?:;", HELP_SEMICOLON);
        specialHelp.put("?::", HELP_SEMICOLON);
        specialHelp.put("?\":\"", HELP_SEMICOLON);
        specialHelp.put("?\":\";", HELP_SEMICOLON);
        specialHelp.put("?\":\":", HELP_SEMICOLON);
        specialHelp.put("??:", USAGE_SEMICOLON);
        specialHelp.put("??:;", USAGE_SEMICOLON);
        specialHelp.put("??::", USAGE_SEMICOLON);
        specialHelp.put("??\":\"", USAGE_SEMICOLON);
        specialHelp.put("??\":\";", USAGE_SEMICOLON);
        specialHelp.put("??\":\":", USAGE_SEMICOLON);
        specialHelp.put("???:", EG_SEMICOLON);
        specialHelp.put("???:;", EG_SEMICOLON);
        specialHelp.put("???::", EG_SEMICOLON);
        specialHelp.put("???\":\"", EG_SEMICOLON);
        specialHelp.put("???\":\";", EG_SEMICOLON);
        specialHelp.put("???\":\":", EG_SEMICOLON);
        String HELP_NAME = "help(\"`\");";
        String USAGE_NAME = "usage(\"`\");";
        String EG_NAME = "example(\"`\");";
        specialHelp.put("?`", HELP_NAME);
        specialHelp.put("?``", HELP_NAME);
        specialHelp.put("?`;", HELP_NAME);
        specialHelp.put("?`:", HELP_NAME);
        specialHelp.put("?\"`\"", HELP_NAME);
        specialHelp.put("?\"`\";", HELP_NAME);
        specialHelp.put("?\"`\":", HELP_NAME);
        specialHelp.put("??`", USAGE_NAME);
        specialHelp.put("??``", USAGE_NAME);
        specialHelp.put("??`;", USAGE_NAME);
        specialHelp.put("??`:", USAGE_NAME);
        specialHelp.put("??\"`\"", USAGE_NAME);
        specialHelp.put("??\"`\";", USAGE_NAME);
        specialHelp.put("??\"`\":", USAGE_NAME);
        specialHelp.put("???`", EG_NAME);
        specialHelp.put("???``", EG_NAME);
        specialHelp.put("???`;", EG_NAME);
        specialHelp.put("???`:", EG_NAME);
        specialHelp.put("???\"`\"", EG_NAME);
        specialHelp.put("???\"`\";", EG_NAME);
        specialHelp.put("???\"`\":", EG_NAME);
        String HELP_UNEVAL = "help(\"'\");";
        String USAGE_UNEVAL = "usage(\"'\");";
        String EG_UNEVAL = "example(\"'\");";
        specialHelp.put("?'", HELP_UNEVAL);
        specialHelp.put("?''", HELP_UNEVAL);
        specialHelp.put("?';", HELP_UNEVAL);
        specialHelp.put("?':", HELP_UNEVAL);
        specialHelp.put("?\"'\"", HELP_UNEVAL);
        specialHelp.put("?\"'\";", HELP_UNEVAL);
        specialHelp.put("?\"'\":", HELP_UNEVAL);
        specialHelp.put("??'", USAGE_UNEVAL);
        specialHelp.put("??''", USAGE_UNEVAL);
        specialHelp.put("??';", USAGE_UNEVAL);
        specialHelp.put("??':", USAGE_UNEVAL);
        specialHelp.put("??\"'\"", USAGE_UNEVAL);
        specialHelp.put("??\"'\";", USAGE_UNEVAL);
        specialHelp.put("??\"'\":", USAGE_UNEVAL);
        specialHelp.put("???'", EG_UNEVAL);
        specialHelp.put("???''", EG_UNEVAL);
        specialHelp.put("???';", EG_UNEVAL);
        specialHelp.put("???':", EG_UNEVAL);
        specialHelp.put("???\"'\"", EG_UNEVAL);
        specialHelp.put("???\"'\";", EG_UNEVAL);
        specialHelp.put("???\"'\":", EG_UNEVAL);
        String HELP_QUOTE = "help(\"strings\");";
        String USAGE_QUOTE = "usage(\"strings\");";
        String EG_QUOTE = "example(\"strings\");";
        specialHelp.put("?\"", HELP_QUOTE);
        specialHelp.put("?\"\"", HELP_QUOTE);
        specialHelp.put("?\";", HELP_QUOTE);
        specialHelp.put("?\":", HELP_QUOTE);
        specialHelp.put("?\"\"\"", HELP_QUOTE);
        specialHelp.put("?\"\"\";", HELP_QUOTE);
        specialHelp.put("?\"\"\":", HELP_QUOTE);
        specialHelp.put("??\"", USAGE_QUOTE);
        specialHelp.put("??\"\"", USAGE_QUOTE);
        specialHelp.put("??\";", USAGE_QUOTE);
        specialHelp.put("??\":", USAGE_QUOTE);
        specialHelp.put("??\"\"\"", USAGE_QUOTE);
        specialHelp.put("??\"\"\";", USAGE_QUOTE);
        specialHelp.put("??\"\"\":", USAGE_QUOTE);
        specialHelp.put("???\"", EG_QUOTE);
        specialHelp.put("???\"\"", EG_QUOTE);
        specialHelp.put("???\";", EG_QUOTE);
        specialHelp.put("???\":", EG_QUOTE);
        specialHelp.put("???\"\"\"", EG_QUOTE);
        specialHelp.put("???\"\"\";", EG_QUOTE);
        specialHelp.put("???\"\"\":", EG_QUOTE);
        String HELP_COLONDASH = "help(\":-\");";
        String USAGE_COLONDASH = "usage(\":-\");";
        String EG_COLONDASH = "example(\":-\");";
        specialHelp.put("?:-", HELP_COLONDASH);
        specialHelp.put("?:-;", HELP_COLONDASH);
        specialHelp.put("?:-:", HELP_COLONDASH);
        specialHelp.put("?\":-\"", HELP_COLONDASH);
        specialHelp.put("?\":-\";", HELP_COLONDASH);
        specialHelp.put("?\":-\":", HELP_COLONDASH);
        specialHelp.put("??:-", USAGE_COLONDASH);
        specialHelp.put("??:-;", USAGE_COLONDASH);
        specialHelp.put("??:-:", USAGE_COLONDASH);
        specialHelp.put("??\":-\"", USAGE_COLONDASH);
        specialHelp.put("??\":-\";", USAGE_COLONDASH);
        specialHelp.put("??\":-\":", USAGE_COLONDASH);
        specialHelp.put("???:-", EG_COLONDASH);
        specialHelp.put("???:-;", EG_COLONDASH);
        specialHelp.put("???:-:", EG_COLONDASH);
        specialHelp.put("???\":-\"", EG_COLONDASH);
        specialHelp.put("???\":-\";", EG_COLONDASH);
        specialHelp.put("???\":-\":", EG_COLONDASH);
        String HELP_COLONEQUAL = "help(\":=\");";
        String USAGE_COLONEQUAL = "usage(\":=\");";
        String EG_COLONEQUAL = "example(\":=\");";
        specialHelp.put("?:=", HELP_COLONEQUAL);
        specialHelp.put("?:=;", HELP_COLONEQUAL);
        specialHelp.put("?:=:", HELP_COLONEQUAL);
        specialHelp.put("?\":=\"", HELP_COLONEQUAL);
        specialHelp.put("?\":=\";", HELP_COLONEQUAL);
        specialHelp.put("?\":=\":", HELP_COLONEQUAL);
        specialHelp.put("??:=", USAGE_COLONEQUAL);
        specialHelp.put("??:=;", USAGE_COLONEQUAL);
        specialHelp.put("??:=:", USAGE_COLONEQUAL);
        specialHelp.put("??\":=\"", USAGE_COLONEQUAL);
        specialHelp.put("??\":=\";", USAGE_COLONEQUAL);
        specialHelp.put("??\":=\":", USAGE_COLONEQUAL);
        specialHelp.put("???:=", EG_COLONEQUAL);
        specialHelp.put("???:=;", EG_COLONEQUAL);
        specialHelp.put("???:=:", EG_COLONEQUAL);
        specialHelp.put("???\":=\"", EG_COLONEQUAL);
        specialHelp.put("???\":=\";", EG_COLONEQUAL);
        specialHelp.put("???\":=\":", EG_COLONEQUAL);
        String HELP_BKSLASH = "help(\"\\\\\");";
        String USAGE_BKSLASH = "usage(\"\\\\\");";
        String EG_BKSLASH = "example(\"\\\\\");";
        specialHelp.put("?\\", HELP_BKSLASH);
        specialHelp.put("?\\;", HELP_BKSLASH);
        specialHelp.put("?\\:", HELP_BKSLASH);
        specialHelp.put("?\"\\\"", HELP_BKSLASH);
        specialHelp.put("?\"\\\";", HELP_BKSLASH);
        specialHelp.put("?\"\\\":", HELP_BKSLASH);
        specialHelp.put("??\\", USAGE_BKSLASH);
        specialHelp.put("??\\;", USAGE_BKSLASH);
        specialHelp.put("??\\:", USAGE_BKSLASH);
        specialHelp.put("??\"\\\"", USAGE_BKSLASH);
        specialHelp.put("??\"\\\";", USAGE_BKSLASH);
        specialHelp.put("??\"\\\":", USAGE_BKSLASH);
        specialHelp.put("???\\", EG_BKSLASH);
        specialHelp.put("???\\;", EG_BKSLASH);
        specialHelp.put("???\\:", EG_BKSLASH);
        specialHelp.put("???\"\\\"", EG_BKSLASH);
        specialHelp.put("???\"\\\";", EG_BKSLASH);
        specialHelp.put("???\"\\\":", EG_BKSLASH);
        String HELP_HELP = "help(\"?\");";
        String USAGE_HELP = "usage(\"?\");";
        String EG_HELP = "example(\"?\");";
        specialHelp.put("?", HELP_HELP);
        specialHelp.put("??", USAGE_HELP);
        specialHelp.put("???", EG_HELP);
    }
}

