/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import java.util.Iterator;

public abstract class AbstractBranchLayoutBox
extends AbstractLayoutBox {
    protected LayoutBox[] children = null;
    public String name = "";
    protected String data = "";
    int numChildren = 0;
    protected SelectionData selectionData;

    protected AbstractBranchLayoutBox() {
    }

    @Override
    public void setData(String d) {
        this.data = d;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    @Override
    public int numChildren() {
        return this.numChildren;
    }

    @Override
    public int indexOf(LayoutBox child) {
        int position = -1;
        int i = 0;
        while (i < this.numChildren()) {
            if (this.getChild(i) != null && this.getChild(i).equals(child)) {
                position = i;
                break;
            }
            ++i;
        }
        return position;
    }

    @Override
    public LayoutBox getChild(int index) {
        LayoutBox child = null;
        if (index >= 0 && index < this.numChildren()) {
            child = this.children[index];
        }
        if (index >= 0 && index == this.numChildren - 1) {
            int lastNullChild = -1;
            int firstNullChild = -1;
            int i = index;
            while (i < this.children.length - 1) {
                if (this.children[i] == null) {
                    firstNullChild = firstNullChild == -1 ? i : firstNullChild;
                    lastNullChild = i;
                }
                ++i;
            }
            if (lastNullChild > -1 && firstNullChild > -1) {
                LayoutBox[] newKids = new LayoutBox[firstNullChild];
                System.arraycopy(this.children, 0, newKids, 0, firstNullChild);
                this.children = newKids;
            }
        }
        return child;
    }

    @Override
    public void addChild(LayoutBox child) {
        boolean set = false;
        if (this.children != null && this.children.length > 0) {
            if (this.numChildren < this.children.length) {
                this.children[this.numChildren] = child;
                set = true;
            } else {
                int i = 0;
                while (i < this.children.length) {
                    if (this.children[i] == null) {
                        set = true;
                        this.children[i] = child;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (!set) {
            if (this.children == null || this.children.length == 0) {
                this.children = new LayoutBox[1];
                this.children[0] = child;
            } else {
                LayoutBox[] newKids = new LayoutBox[this.numChildren() + 1];
                System.arraycopy(this.children, 0, newKids, 0, this.numChildren());
                newKids[newKids.length - 1] = child;
                this.children = newKids;
            }
            set = true;
        }
        if (set) {
            ++this.numChildren;
        }
        this.validLayout = false;
    }

    @Override
    public void removeChild(int index) {
        LayoutBox[] newKids = new LayoutBox[this.numChildren() - 1];
        System.arraycopy(this.children, 0, newKids, 0, index);
        System.arraycopy(this.children, index + 1, newKids, index, this.numChildren() - index - 1);
        --this.numChildren;
        this.validLayout = false;
    }

    @Override
    public Iterator getChildren() {
        return new ChildArrayIterator();
    }

    @Override
    public SelectionData getSelectionData() {
        SelectionData temp = null;
        if (this.selectionData != null) {
            temp = this.selectionData;
        } else if (this.getDefaultSelectionData() == null) {
            this.setDefaultSelectionData(new StandardSelectionData(this.getSelectionCode()));
        }
        temp = temp == null ? this.getDefaultSelectionData() : temp;
        return temp;
    }

    public void setDefaultSelectionData(SelectionData defaultSD) {
    }

    public SelectionData getDefaultSelectionData() {
        return null;
    }

    protected int getSelectionCode() {
        return 1;
    }

    @Override
    public void setSelectionData(SelectionData sD) {
        this.selectionData = sD;
    }

    @Override
    public void setTheFirstOrigin() {
        LayoutBox child = this.getChild(0);
        if (child.hasChildren()) {
            child.setTheFirstOrigin();
        } else {
            child.setOrigin(0.0, 0.0);
        }
    }

    @Override
    public void computeSize() {
        double width = 0.0;
        double top = 0.0;
        double bottom = this.getYorig();
        LayoutBox child = null;
        double childOffset = 0.0;
        double childHeight = 0.0;
        int i = 0;
        while (i < this.numChildren()) {
            child = this.getChild(i);
            childOffset = child.getYorig();
            childHeight = child.getHeight();
            if (childOffset < bottom) {
                bottom = childOffset;
            }
            if (childOffset + childHeight > top) {
                top = childOffset + childHeight;
            }
            width += child.getTotalWidth();
            ++i;
        }
        this.adjustBaselineAndOrigins(bottom);
        this.setSize(width, top - bottom);
        this.setOrigin(0.0, 0.0);
        this.validLayout = true;
    }

    protected void adjustBaselineAndOrigins(double bottomMeasure) {
        this.baseline = 0.0;
        if (this.hasChildren() && this.getChild(0) != null) {
            this.baseline = this.getChild(0).getBaseline();
        }
        if (bottomMeasure != 0.0) {
            LayoutPoint offset = new LayoutPoint(0.0, -bottomMeasure);
            int i = 0;
            while (i < this.numChildren()) {
                this.getChild(i).translateOrigin(offset);
                ++i;
            }
            this.baseline -= bottomMeasure;
        }
    }

    @Override
    public void invalidateAll() {
        int i = 0;
        while (i < this.numChildren()) {
            if (this.getChild(i) != null) {
                this.getChild(i).invalidateAll();
            }
            ++i;
        }
        this.validate(false);
    }

    @Override
    public abstract Iterator getAnchors();

    @Override
    public abstract void addLayoutAnchor(LayoutAnchor var1);

    @Override
    public abstract void applyLayout();

    static void resetLayout(LayoutBox box) {
        box.invalidateAll();
        box.applyLayout();
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.sizeSet) {
            result.append(" Size ");
            result.append(this.getSize());
        } else {
            result.append(" Size not Set");
        }
        result.append(" Origin ");
        result.append(this.origin);
        result.append("\nLayoutAnchors:\n");
        Iterator iLayoutAnchors = this.getAnchors();
        int cnt = 0;
        while (iLayoutAnchors.hasNext()) {
            LayoutAnchor an = (LayoutAnchor)iLayoutAnchors.next();
            result.append(an);
            if (++cnt >= this.numChildren() - 1) continue;
            result.append("\n");
        }
        if (cnt > 0) {
            result.append("\n");
        }
        if (this.numChildren() > 0) {
            result.append("Children:\n");
        }
        Iterator iChildren = this.getChildren();
        while (iChildren.hasNext()) {
            LayoutBox b = (LayoutBox)iChildren.next();
            result.append(b);
        }
        result.append("Data: ");
        result.append(this.data);
        result.append("\n");
        result.append("end ");
        result.append(this.name);
        result.append("\n");
        return result.toString();
    }

    @Override
    public void setDag(Dag dag) {
        this.dag = dag;
    }

    @Override
    public void setAllDags(Dag dag) {
        int i = 0;
        while (i < this.numChildren()) {
            this.getChild(i).setAllDags(dag);
            ++i;
        }
        this.setDag(dag);
    }

    @Override
    public Dag getDag() {
        return this.dag;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private class ChildArrayIterator
    implements Iterator {
        int position = 0;

        private ChildArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < AbstractBranchLayoutBox.this.numChildren;
        }

        public Object next() {
            return AbstractBranchLayoutBox.this.getChild(this.position++);
        }

        @Override
        public void remove() {
            AbstractBranchLayoutBox.this.removeChild(this.position);
        }
    }
}

