/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.linebreaker.DefaultLineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractLayoutBox
implements LayoutBox {
    protected double width = 0.0;
    protected double height = 0.0;
    protected double baseline = 0.0;
    protected double lsb;
    protected double rsb;
    protected boolean sizeSet = false;
    protected boolean validLayout = false;
    protected LayoutPoint origin = new LayoutPoint(0.0, 0.0);
    protected LayoutBox endPoint = null;
    protected Dag dag;
    protected LineBreaker linebreaker = LineBreakerFactory.newLineBreaker(0);
    protected LayoutBox displayLayoutBox;
    protected LayoutBox idealLayoutBox;

    protected AbstractLayoutBox() {
    }

    @Override
    public void setLineBreaker(LineBreaker linebreaker) {
        this.linebreaker = linebreaker;
    }

    @Override
    public LineBreaker getLineBreaker() {
        return this.linebreaker;
    }

    @Override
    public abstract void setSelectionData(SelectionData var1);

    @Override
    public abstract SelectionData getSelectionData();

    @Override
    public List getSelectionBoxes() {
        return null;
    }

    @Override
    public void setSelectionBoxes(List list) {
    }

    @Override
    public LayoutBox getPairEndPointBox() {
        return this.endPoint;
    }

    @Override
    public void setPairEndPointBox(LayoutBox box) {
        this.endPoint = box;
    }

    @Override
    public abstract void setData(String var1);

    @Override
    public abstract String getData();

    @Override
    public abstract boolean hasChildren();

    @Override
    public abstract int numChildren();

    @Override
    public abstract int indexOf(LayoutBox var1);

    @Override
    public abstract LayoutBox getChild(int var1);

    @Override
    public abstract void addChild(LayoutBox var1);

    @Override
    public abstract void removeChild(int var1);

    @Override
    public abstract Iterator getChildren();

    @Override
    public abstract void setTheFirstOrigin();

    @Override
    public void setOrigin(LayoutPoint o) {
        this.setOrigin(o.getX(), o.getY());
    }

    @Override
    public void setOrigin(double x, double y) {
        this.origin = new LayoutPoint(x, y);
    }

    @Override
    public LayoutPoint getOrigin() {
        return this.origin;
    }

    @Override
    public void translateOrigin() {
        LayoutPoint origin = this.getOrigin();
        LayoutPoint translation = new LayoutPoint(2.0 - origin.getX(), 2.0 - origin.getY());
        this.translateOrigin(translation);
    }

    @Override
    public void translateOrigin(LayoutPoint pt) {
        LayoutPoint origin = this.getOrigin();
        this.setOrigin(origin.getX() + pt.getX(), origin.getY() + pt.getY());
    }

    @Override
    public double getXorig() {
        return this.origin.getX();
    }

    @Override
    public double getYorig() {
        return this.origin.getY();
    }

    @Override
    public double getAdjustedYorig() {
        return this.origin.getY();
    }

    @Override
    public double getBaseline() {
        return this.baseline;
    }

    @Override
    public void setBaseline(double base) {
        this.baseline = base;
    }

    @Override
    public void setSize(double w, double h) {
        this.width = w;
        this.height = h;
        this.sizeSet = true;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public double getLeftSideBearing() {
        return this.lsb;
    }

    @Override
    public double getRightSideBearing() {
        return this.rsb;
    }

    @Override
    public void setRightSideBearing(double bearing) {
        this.rsb = bearing;
    }

    @Override
    public void setLeftSideBearing(double bearing) {
        this.lsb = bearing;
    }

    @Override
    public double getTotalWidth() {
        return this.getWidth() + this.getRightSideBearing() + this.getLeftSideBearing();
    }

    @Override
    public double getAdjustedHeight() {
        return this.height;
    }

    @Override
    public double getDescentAdjustment() {
        return 0.0;
    }

    @Override
    public String getSize() {
        return this.width + "," + this.height;
    }

    @Override
    public abstract void computeSize();

    @Override
    public boolean isLayoutValid() {
        return this.validLayout;
    }

    @Override
    public abstract void invalidateAll();

    @Override
    public void validate(boolean state) {
        this.validLayout = state;
    }

    @Override
    public abstract Iterator getAnchors();

    @Override
    public abstract void addLayoutAnchor(LayoutAnchor var1);

    @Override
    public abstract void applyLayout();

    @Override
    public LayoutBox getDisplayLayoutBox() {
        LayoutBox toReturn = this.displayLayoutBox == null ? this : this.displayLayoutBox;
        return toReturn;
    }

    @Override
    public void setDisplayLayoutBox(LayoutBox display) {
        this.displayLayoutBox = display;
    }

    @Override
    public LayoutBox getIdealLayoutBox() {
        LayoutBox toReturn = this.idealLayoutBox == null ? this : this.idealLayoutBox;
        return toReturn;
    }

    @Override
    public void setIdealLayoutBox(LayoutBox ideal) {
        this.idealLayoutBox = ideal;
    }

    @Override
    public void linebreak(LayoutFormatter formatter, double width) {
        double linebreakWidth = width;
        if (this.getLineBreaker() != null && linebreakWidth < this.getWidth()) {
            linebreakWidth = Math.max(linebreakWidth, DefaultLineBreaker.getMinimumBreakWidth(width, formatter));
            if (this.displayLayoutBox != null) {
                this.displayLayoutBox = null;
                AbstractLayoutBox.resetLayout(this);
            }
            this.displayLayoutBox = this.getLineBreaker().startLinebreak(this, formatter, linebreakWidth);
            this.displayLayoutBox.setIdealLayoutBox(this);
        } else if (this.displayLayoutBox != null) {
            this.displayLayoutBox = null;
            AbstractLayoutBox.resetLayout(this);
        }
    }

    static void resetLayout(LayoutBox box) {
        box.invalidateAll();
        box.applyLayout();
    }

    @Override
    public void setDag(Dag dag) {
        this.dag = dag;
    }

    @Override
    public void setAllDags(Dag dag) {
        int i = 0;
        while (i < this.numChildren()) {
            this.getChild(i).setAllDags(dag);
            ++i;
        }
        this.setDag(dag);
    }

    @Override
    public Dag getDag() {
        return this.dag;
    }

    @Override
    public int[] getAncestorPath() {
        return null;
    }

    @Override
    public abstract String getName();

    public abstract String toString();
}

