/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BoxUtils {
    public static LayoutBox whichIsFirstBox(LayoutBox root, LayoutBox one, LayoutBox two) {
        LayoutBox returnBox = one;
        List pone = BoxUtils.findPathToBox(root, one);
        List ptwo = BoxUtils.findPathToBox(root, two);
        pone.add(one);
        ptwo.add(two);
        LayoutBox common = (LayoutBox)BoxUtils.findFirstCommonElement(pone, ptwo);
        int oneidx = -1;
        int twoidx = -1;
        int i = 0;
        while (i < pone.size()) {
            if (pone.get(i) == common && i + 1 < pone.size()) {
                oneidx = common.indexOf((LayoutBox)pone.get(i + 1));
                break;
            }
            ++i;
        }
        i = 0;
        while (i < ptwo.size()) {
            if (ptwo.get(i) == common && i + 1 < ptwo.size()) {
                twoidx = common.indexOf((LayoutBox)ptwo.get(i + 1));
                break;
            }
            ++i;
        }
        SelectionData sd = common.getSelectionData();
        if (sd != null && !(common instanceof LineBreakLayoutBox)) {
            int sdidx = sd.getTraversalArrayIndex(oneidx, 1);
            int tdidx = sd.getTraversalArrayIndex(twoidx, 1);
            oneidx = oneidx == sdidx ? oneidx : sdidx;
            twoidx = twoidx == tdidx ? twoidx : tdidx;
        }
        returnBox = oneidx <= twoidx ? one : two;
        return returnBox;
    }

    public static BoxIterator getBoxIterator(LayoutBox box) {
        return new BoxIterator(box);
    }

    public static boolean isBetween(LayoutBox root, LayoutBox test, LayoutBox start, LayoutBox finish) {
        int curPos;
        boolean result = true;
        if (test == start || test == finish) {
            return true;
        }
        int[] pathToStart = BoxUtils.getBoxPath(root, start);
        int[] pathToTarget = BoxUtils.getBoxPath(root, test);
        int[] pathToFinish = BoxUtils.getBoxPath(root, finish);
        int i = 0;
        while (i < pathToTarget.length && result) {
            curPos = pathToTarget[i];
            if (i < pathToStart.length) {
                result = curPos > pathToStart[i];
                if (result) break;
                result = curPos >= pathToStart[i];
            }
            ++i;
        }
        i = 0;
        while (i < pathToTarget.length && result) {
            curPos = pathToTarget[i];
            if (i < pathToFinish.length) {
                result = curPos < pathToFinish[i];
                if (result) break;
                result = curPos <= pathToFinish[i];
            }
            ++i;
        }
        return result;
    }

    public static LayoutBox findParent(LayoutBox rootBox, LayoutBox target) {
        LayoutBox parent = null;
        List path = BoxUtils.findPathToBox(rootBox, target);
        if (path != null) {
            parent = (LayoutBox)path.get(path.size() - 1);
        }
        return parent;
    }

    public static List findPathToBox(LayoutBox root, LayoutBox target, List dags) {
        CollectDags pathBuilder = new CollectDags(dags);
        BoxUtils.walkPath(root, target, pathBuilder);
        return pathBuilder.getPath();
    }

    public static List findPathToBox(LayoutBox root, LayoutBox target) {
        BuildPath pathBuilder = new BuildPath();
        BoxUtils.walkPath(root, target, pathBuilder);
        return pathBuilder.getPath();
    }

    public static int[] getBoxPath(LayoutBox root, LayoutBox target) {
        List pathlist = BoxUtils.findPathToBox(root, target);
        pathlist.add(target);
        int[] path = new int[pathlist.size() - 1];
        LayoutBox currentParent = root;
        Iterator pathit = pathlist.iterator();
        if (pathit.hasNext()) {
            pathit.next();
        }
        int i = 0;
        while (pathit.hasNext()) {
            LayoutBox box = (LayoutBox)pathit.next();
            path[i] = currentParent.indexOf(box);
            currentParent = box;
            ++i;
        }
        return path;
    }

    public static LayoutBox getBoxFromPath(LayoutBox root, int[] path) throws IndexOutOfBoundsException {
        LayoutBox currentBox = root;
        int i = 0;
        while (i < path.length) {
            if ((currentBox = currentBox.getChild(path[i])) == null) {
                throw new IndexOutOfBoundsException("Path want wrong at step " + i + " index " + path[i]);
            }
            ++i;
        }
        return currentBox;
    }

    public static void walkPath(LayoutBox root, LayoutBox target, BoxWalkOperation operation) {
        LayoutBox operand = root;
        LayoutBox child = null;
        block0: do {
            child = null;
            operation.visited(operand);
            int i = 0;
            while (i < operand.numChildren()) {
                child = operand.getChild(i);
                if (child == target || BoxUtils.containsBoxInDepth(child, target)) {
                    operand = child;
                    continue block0;
                }
                ++i;
            }
        } while (operand != target && BoxUtils.containsBoxInDepth(operand, target));
    }

    public static boolean containsBoxInDepth(LayoutBox search, LayoutBox target) {
        boolean result = false;
        if (search == target) {
            result = true;
        } else if (search != null) {
            int i = 0;
            while (i < search.numChildren() && !result) {
                LayoutBox child = search.getChild(i);
                if (child == target) {
                    result = true;
                    break;
                }
                result = BoxUtils.containsBoxInDepth(child, target);
                if (result) break;
                ++i;
            }
        }
        return result;
    }

    public static LayoutBox findCommonParent(LayoutBox root, LayoutBox one, LayoutBox two) {
        List pathOne = BoxUtils.findPathToBox(root, one);
        List pathTwo = BoxUtils.findPathToBox(root, two);
        return (LayoutBox)BoxUtils.findFirstCommonElement(pathOne, pathTwo);
    }

    public static Object findFirstCommonElement(List one, List two) {
        Object parent = null;
        Object test = null;
        Object other = null;
        int pos = one.size();
        int pts = two.size();
        int end = Math.max(pos, pts);
        int i = 0;
        while (i < end) {
            if (i >= pos || i >= pts || (test = one.get(i)) != (other = two.get(i))) break;
            parent = test;
            ++i;
        }
        return parent;
    }

    public static class BoxIterator
    implements Iterator {
        private LayoutBox targBox;
        private int position = 0;
        private SelectionData sd = null;
        private LayoutBox lastBox;

        public BoxIterator(LayoutBox targBox) {
            this.targBox = targBox;
            this.sd = this.targBox.getSelectionData();
            this.position = 0;
        }

        public Object next() {
            return this.forward();
        }

        @Override
        public boolean hasNext() {
            return this.isBoxForward();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("BoxIterator cannot remove layout boxes");
        }

        public LayoutBox forward() {
            return this.targBox.getChild(this.position++);
        }

        public LayoutBox backward() {
            return this.targBox.getChild(this.position--);
        }

        public boolean isBoxForward() {
            return this.position < this.targBox.numChildren();
        }

        public boolean isBoxBehind() {
            return this.position > 0;
        }
    }

    public static interface BoxWalkOperation {
        public void visited(LayoutBox var1);
    }

    public static class BuildPath
    implements BoxWalkOperation {
        List path = new LinkedList();

        @Override
        public void visited(LayoutBox visited) {
            this.path.add(visited);
        }

        public List getPath() {
            return this.path;
        }
    }

    public static class CollectDags
    extends BuildPath {
        private List daglist;

        public CollectDags(List daglist) {
            this.daglist = daglist;
        }

        @Override
        public void visited(LayoutBox visited) {
            super.visited(visited);
            if (!this.daglist.contains(visited.getDag())) {
                this.daglist.add(visited.getDag());
            }
        }

        public List getDags() {
            return this.daglist;
        }
    }
}

