/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.BlockingEvaluation;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.NameDagFactory;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.BoxUtils;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionDagBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DagModifier {
    public static Dag seekDagParent(Dag rootDag, Dag targetChild) {
        List dags = new LinkedList();
        Dag parent = null;
        parent = (dags = DagModifier.getDagPath(rootDag, targetChild, dags)).size() > 1 ? (Dag)dags.get(dags.size() - 2) : null;
        return parent;
    }

    public static List getDagPath(Dag rootDag, Dag targetDag, List resultDags) {
        resultDags.add(rootDag);
        int i = 0;
        while (i < rootDag.getLength()) {
            Dag child = rootDag.getChild(i);
            if (DagModifier.containsDagInDepth(child, targetDag) && (resultDags = DagModifier.getDagPath(child, targetDag, resultDags)).get(resultDags.size() - 1) == targetDag) break;
            ++i;
        }
        return resultDags;
    }

    public static Dag modify(LayoutBox root, LayoutBox target, String newDagString, int kernelid) {
        return DagModifier.modify(root, target, newDagString, kernelid, 41);
    }

    public static Dag modify(LayoutBox root, LayoutBox target, String newDagString, int kernelid, int how) {
        Dag backupDag = root.getIdealLayoutBox().getDag().copy();
        try {
            List<Dag> dagPath = new LinkedList();
            Dag changeDag = null;
            if (target instanceof LineBreakLayoutBox.LineBrokenRow) {
                LinkedList<LayoutBox> targets = new LinkedList<LayoutBox>();
                targets.add(target);
                changeDag = DagModifier.modify(root, targets, newDagString, kernelid);
            } else {
                Dag resultDag;
                root = root.getIdealLayoutBox();
                ModificationTargets mt = new ModificationTargets(null, null);
                List path = BoxUtils.findPathToBox(root, target, dagPath);
                Dag rootDag = (Dag)dagPath.get(0);
                DagModifier.cleanNonMembers(dagPath);
                dagPath = DagModifier.modifyDagsForAncestorArrays(dagPath, root, path, target, mt);
                if (!dagPath.get(dagPath.size() - 1).equals(target.getDag())) {
                    dagPath.add(target.getDag());
                }
                DagModifier.fillInHoles(dagPath);
                DagModifier.removeExtras(dagPath);
                dagPath = DagModifier.deduplicate(dagPath);
                changeDag = DagModifier.cloneDagPathElements(rootDag, dagPath, mt, new HashMap(), null, -1);
                mt.targetDag = resultDag = DagModifier.commandToDag(newDagString, kernelid, how);
                if (DagUtil.isSum(mt.singleModParentDag) && DagUtil.isOne(target.getDag())) {
                    int i = mt.singleModParentDag.getLength() - 1;
                    while (i > 0) {
                        Dag term;
                        Dag scale = mt.singleModParentDag.getChild(i);
                        if (DagUtil.isOne(term = mt.singleModParentDag.getChild(--i)) && DagUtil.isOne(scale)) {
                            mt.singleModLocationIndex = i;
                            break;
                        }
                        --i;
                    }
                }
                if (mt.targetDag.getType() == 29 && mt.targetDag.getLength() == 1) {
                    mt.targetDag = mt.targetDag.getChild(0);
                }
                if (mt.targetDag != null && mt.singleModParentDag != null && changeDag != null) {
                    mt.singleModLocationIndex = mt.singleModLocationIndex < 0 ? 0 : mt.singleModLocationIndex;
                    mt.singleModParentDag.setChild(mt.singleModLocationIndex, mt.targetDag);
                }
            }
            return changeDag;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return backupDag;
    }

    private static void removeExtras(List dagPath) {
        int i = 0;
        while (i < dagPath.size()) {
            Dag c;
            Dag p;
            if (i < dagPath.size() - 1 && !DagModifier.dagContains(p = (Dag)dagPath.get(i), c = (Dag)dagPath.get(i + 1))) {
                dagPath.remove(i + 1);
            }
            ++i;
        }
    }

    private static void fillInHoles(List dagPath) {
        int i = 0;
        while (i < dagPath.size()) {
            Dag parent = (Dag)dagPath.get(i);
            if (i + 1 >= dagPath.size()) break;
            Dag child = (Dag)dagPath.get(i + 1);
            if (!DagModifier.dagContains(parent, child) && DagModifier.searchForDag(parent, child)) {
                DagModifier.fillHole(dagPath, i, parent, child);
            }
            ++i;
        }
    }

    private static void fillHole(List path, int pathStep, Dag parent, Dag child) {
        int i = 0;
        while (i < parent.getLength()) {
            Dag kid = parent.getChild(i);
            if (DagModifier.dagContains(kid, child)) {
                path.add(pathStep + 1, kid);
                break;
            }
            if (DagModifier.searchForDag(kid, child)) {
                path.add(pathStep + 1, kid);
                ++pathStep;
                parent = kid;
            }
            ++i;
        }
    }

    public static List deduplicate(List list) {
        int i = 0;
        while (i < list.size() - 1) {
            if (list.get(i) == list.get(i + 1)) {
                list.remove(i + 1);
            }
            ++i;
        }
        return list;
    }

    private static void cleanNonMembers(List dagPath) {
        Dag rootTestDag = (Dag)dagPath.get(0);
        int k = dagPath.size() - 1;
        while (k > 1) {
            Dag testDag = (Dag)dagPath.get(k);
            if (!DagModifier.searchForDag(rootTestDag, testDag)) {
                dagPath.remove(k);
            }
            --k;
        }
    }

    private static boolean searchForDag(Dag parent, Dag target) {
        boolean found = false;
        found = DagModifier.searchForDag(parent, target, found);
        return found;
    }

    private static boolean dagContains(Dag parent, Dag child) {
        boolean isPresent = false;
        int i = 0;
        while (i < parent.getLength() && !isPresent) {
            if (parent.getChild(i) == child) {
                isPresent = true;
            }
            ++i;
        }
        return isPresent;
    }

    private static boolean searchForDag(Dag parent, Dag target, boolean found) {
        if (parent == target) {
            found = true;
        } else if (parent.getLength() > 0) {
            int i = 0;
            while (i < parent.getLength()) {
                found = DagModifier.searchForDag(parent.getChild(i), target, found);
                if (found) break;
                ++i;
            }
        }
        return found;
    }

    public static Dag modify(LayoutBox root, List targets, String newDagString, int kernelid) {
        return DagModifier.modify(root, targets, newDagString, kernelid, 41);
    }

    public static Dag modify(LayoutBox root, List targets, String newDagString, int kernelid, int how) {
        Dag rootDag;
        root = root.getIdealLayoutBox();
        Dag changeDag = rootDag = root.getDag();
        MultiModificationTargets mt = new MultiModificationTargets();
        targets = SelectionDagBuilder.expandLineBroken(targets, root);
        LinkedList<Dag> dagTargets = new LinkedList<Dag>();
        Dag addDag = null;
        LayoutBox box = null;
        int i = 0;
        while (i < targets.size()) {
            box = (LayoutBox)targets.get(i);
            addDag = box.getDag();
            dagTargets.add(addDag);
            box = null;
            addDag = null;
            ++i;
        }
        Dag curDag = null;
        LayoutBox curBox = null;
        List<Dag> dags = null;
        HashMap cloneToOriginal = new HashMap();
        int i2 = 0;
        while (i2 < dagTargets.size()) {
            curDag = (Dag)dagTargets.get(i2);
            if (curDag != null) {
                curBox = (LayoutBox)targets.get(i2);
                dags = new LinkedList<Dag>();
                List path = BoxUtils.findPathToBox(root, curBox, dags);
                path.add(curBox);
                dags.add(curBox.getDag());
                dags = DagModifier.modifyDagsForAncestorArrays(dags, root, path, curBox, mt);
                changeDag = DagModifier.cloneDagPathElements(changeDag, dags, mt, cloneToOriginal, dagTargets, i2);
            }
            ++i2;
        }
        Dag resultDag = DagModifier.commandToDag(newDagString, kernelid, how);
        if (DagModifier.isTotalSelection(root, targets)) {
            changeDag = resultDag;
        } else if (DagModifier.confirmSharedParent(changeDag, mt.singleModParentDag, dagTargets)) {
            if (resultDag != null && mt.singleModParentDag != null && mt.startIndex > -1) {
                mt.endIndex = mt.startIndex > mt.endIndex ? mt.startIndex : mt.endIndex;
                mt.singleModParentDag.replaceChildren(mt.startIndex, mt.endIndex, resultDag);
            }
        } else {
            changeDag = null;
        }
        return changeDag;
    }

    private static boolean isTotalSelection(LayoutBox root, List items) {
        boolean result = true;
        if (root.numChildren() == items.size()) {
            int i = 0;
            while (i < root.numChildren()) {
                if (root.getChild(i) != items.get(i)) {
                    result = false;
                    break;
                }
                ++i;
            }
        } else {
            result = false;
        }
        return result;
    }

    private static List modifyDagsForAncestorArrays(List dags, LayoutBox root, List layoutPath, LayoutBox targetBox, ModificationTargets mt) {
        List<Dag> newDags = new LinkedList();
        if (layoutPath.size() > dags.size() || DagModifier.containsNulls(dags)) {
            int i = 0;
            while (i < layoutPath.size()) {
                LayoutBox box = (LayoutBox)layoutPath.get(i);
                if (box instanceof AncestorArrayLayoutBox) {
                    int[] apath = box.getAncestorPath();
                    Dag additionPoint = null;
                    int k = i;
                    while (k >= 0 && additionPoint == null) {
                        Dag testStart;
                        additionPoint = testStart = ((LayoutBox)layoutPath.get(k)).getDag();
                        --k;
                    }
                    int j = 0;
                    while (j < apath.length) {
                        if (additionPoint != null) {
                            Dag ancestorDag = additionPoint.getChild(apath[j]);
                            if (ancestorDag == newDags.get(newDags.size() - 1)) break;
                            newDags.add(ancestorDag);
                            additionPoint = ancestorDag;
                            if (j == apath.length - 1 && targetBox.getDag() == newDags.get(newDags.size() - 1)) {
                                mt.singleModLocationIndex = apath[j];
                            }
                        }
                        ++j;
                    }
                } else {
                    Dag dag = null;
                    if (dags.size() > 0) {
                        dag = (Dag)dags.remove(0);
                    }
                    if (dag != null && (newDags.size() == 0 || dag != newDags.get(newDags.size() - 1))) {
                        newDags.add(dag);
                    }
                }
                ++i;
            }
        } else {
            newDags = DagModifier.isDagPathClean(dags) ? dags : DagModifier.fillInPath(dags);
        }
        return newDags;
    }

    private static List fillInPath(List dagPath) {
        LinkedList<Dag> cleanList = new LinkedList<Dag>();
        if (dagPath.size() > 0) {
            Dag root;
            Dag testDag = root = (Dag)dagPath.get(0);
            int i = 1;
            while (i < dagPath.size()) {
                boolean childSeen = false;
                Dag currentTargetDag = (Dag)dagPath.get(i);
                childSeen = DagModifier.scanForChild(testDag, currentTargetDag);
                cleanList.add(testDag);
                if (childSeen) {
                    testDag = currentTargetDag;
                } else {
                    int j = 0;
                    while (j < testDag.getLength()) {
                        if (DagModifier.scanForChildInDepth(testDag.getChild(j), currentTargetDag)) {
                            testDag = testDag.getChild(j);
                            cleanList.add(testDag);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        cleanList.add((Dag)dagPath.get(dagPath.size() - 1));
        return cleanList;
    }

    private static boolean scanForChild(Dag potentialParent, Dag target) {
        boolean childSeen = false;
        int j = 0;
        while (j < potentialParent.getLength()) {
            if (potentialParent.getChild(j) == target) {
                childSeen = true;
                break;
            }
            ++j;
        }
        return childSeen;
    }

    private static boolean scanForChildInDepth(Dag potentialParent, Dag target) {
        boolean childSeen = false;
        int j = 0;
        while (j < potentialParent.getLength()) {
            Dag child = potentialParent.getChild(j);
            if (child == target) {
                childSeen = true;
            }
            if (!childSeen && child.getLength() > 0) {
                childSeen = DagModifier.scanForChildInDepth(child, target);
            }
            if (childSeen) break;
            ++j;
        }
        return childSeen;
    }

    public static boolean isDagPathClean(List dagPath) {
        boolean pathIsClean = true;
        if (dagPath.size() > 0) {
            Dag root;
            Dag testDag = root = (Dag)dagPath.get(0);
            int i = 1;
            while (i < dagPath.size()) {
                boolean childSeen = false;
                Dag currentTargetDag = (Dag)dagPath.get(i);
                childSeen = DagModifier.scanForChild(testDag, currentTargetDag);
                Dag dag = testDag = childSeen ? currentTargetDag : testDag;
                if (!childSeen) {
                    pathIsClean = false;
                    break;
                }
                ++i;
            }
        }
        return pathIsClean;
    }

    private static boolean containsNulls(List path) {
        int i = 0;
        while (i < path.size()) {
            if (path.get(i) == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean confirmSharedParent(Dag root, Dag potentialParent, List dags) {
        Dag check = null;
        Dag parent = null;
        int i = 0;
        while (i < dags.size()) {
            check = (Dag)dags.get(i);
            if (check != null && (parent = DagModifier.seekDagParent(root, check)) != null && parent != potentialParent) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Dag commandToDag(String command, int kernelid) {
        return DagModifier.commandToDag(command, kernelid, 41);
    }

    private static Dag commandToDag(String command, int kernelid, int how) {
        Dag result = NameDagFactory.createNameDag("%?");
        if (command != null && command.length() > 0) {
            ModificationListener modder = new ModificationListener(command, kernelid, how);
            modder.process();
            result = modder.getDagResult();
        }
        return result;
    }

    public static Dag cloneDagPathElements(Dag dag, List dagPath) {
        return DagModifier.cloneDagPathElements(dag, dagPath, new ModificationTargets(null, null), new HashMap(), new LinkedList(), 0);
    }

    private static Dag cloneDagPathElements(Dag dag, List dagPath, ModificationTargets mt, HashMap cloneToOriginal, List targets, int loc) {
        Dag target = dag;
        block0: while (dagPath.size() > 0) {
            dagPath.remove(0);
            target = target.copy();
            cloneToOriginal.put(target, dag);
            if (dagPath.size() == 0) {
                mt.targetDag = target;
                if (targets != null && loc >= 0 && loc < targets.size()) {
                    targets.set(loc, target);
                }
            }
            Dag dag2 = mt.singleModParentDag = dagPath.size() == 1 ? target : mt.singleModParentDag;
            if (dagPath.size() <= 0) continue;
            Dag nextDag = (Dag)dagPath.get(0);
            int j = 0;
            while (j < target.getLength()) {
                if (target.getChild(j) == nextDag || cloneToOriginal.get(target.getChild(j)) == nextDag) {
                    if (mt.singleModLocationIndex < 0) {
                        int n = mt.singleModLocationIndex = dagPath.size() == 1 ? j : mt.singleModLocationIndex;
                    }
                    if (mt instanceof MultiModificationTargets) {
                        MultiModificationTargets mmt = (MultiModificationTargets)mt;
                        if (dagPath.size() == 1) {
                            mmt.startIndex = mmt.startIndex > -1 ? mmt.startIndex : j;
                            mmt.endIndex = j;
                        }
                    }
                    target.setChild(j, DagModifier.cloneDagPathElements(target.getChild(j), dagPath, mt, cloneToOriginal, targets, loc));
                    continue block0;
                }
                ++j;
            }
        }
        return target;
    }

    private static boolean containsDagInDepth(Dag root, Dag target) {
        if (root == target) {
            return true;
        }
        int i = 0;
        while (i < root.getLength()) {
            Dag child = root.getChild(i);
            boolean answer = DagModifier.containsDagInDepth(child, target);
            if (answer) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static class ModificationListener
    extends BlockingEvaluation {
        String command = null;
        String lprintedResult = null;
        Dag dagResult = null;

        protected ModificationListener(String command, int kernelid) {
            this(command, kernelid, 41);
        }

        protected ModificationListener(String command, int kernelid, int how) {
            super(kernelid, null, how);
            this.command = command;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public void update() {
            this.dagResult = (Dag)this.getResult();
            if (this.dagResult != null) {
                this.lprintedResult = DagBuilder.lPrint(this.dagResult);
            }
        }

        public String getLPrintResult() {
            return this.lprintedResult;
        }

        public Dag getDagResult() {
            return this.dagResult;
        }
    }

    private static class ModificationTargets {
        protected int singleModLocationIndex = -1;
        protected Dag singleModParentDag = null;
        protected Dag targetDag = null;
        protected Dag rootDag = null;

        private ModificationTargets() {
        }

        /* synthetic */ ModificationTargets(ModificationTargets modificationTargets, ModificationTargets modificationTargets2) {
            this();
        }
    }

    private static class MultiModificationTargets
    extends ModificationTargets {
        protected int startIndex = -1;
        protected int endIndex = 0;

        private MultiModificationTargets() {
        }
    }
}

