/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.InlineAnchorIterator;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;

public class InlineLayoutBox
extends AbstractBranchLayoutBox {
    public static SelectionData sd = null;

    public InlineLayoutBox() {
        this.name = "";
        this.children = new LayoutBox[0];
    }

    public InlineLayoutBox(String name) {
        this();
        this.name = name;
    }

    public InlineLayoutBox(int expectedChildren) {
        this.name = "";
        this.children = new LayoutBox[expectedChildren + 1];
    }

    public InlineLayoutBox(String name, int expectedChildren) {
        this(expectedChildren);
        this.name = name;
    }

    @Override
    public void setDefaultSelectionData(SelectionData defaultSD) {
        sd = defaultSD;
    }

    @Override
    public SelectionData getDefaultSelectionData() {
        return sd;
    }

    @Override
    public Iterator getAnchors() {
        return new InlineAnchorIterator(this.numChildren());
    }

    @Override
    public void addLayoutAnchor(LayoutAnchor a) {
    }

    @Override
    public void applyLayout() {
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            if (this.hasChildren()) {
                if (this.getChild(0) != null) {
                    LayoutBox firstChild = this.getChild(0);
                    firstChild.setOrigin(0.0, 0.0);
                    if (firstChild.hasChildren() && !firstChild.isLayoutValid()) {
                        firstChild.applyLayout();
                    }
                }
                int i = 1;
                while (i < this.numChildren()) {
                    LayoutBox prev = this.getChild(i - 1);
                    LayoutBox child = this.getChild(i);
                    if (child.hasChildren() && !child.isLayoutValid()) {
                        child.applyLayout();
                    }
                    double newXorig = prev.getXorig() + prev.getRightSideBearing() + child.getLeftSideBearing() + prev.getWidth();
                    double newYorig = prev.getYorig() + (prev.getBaseline() - child.getBaseline());
                    child.setOrigin(newXorig, newYorig);
                    ++i;
                }
                this.computeSize();
            }
        }
    }
}

