/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.LayoutPoint;

public class LayoutVector {
    public static final LayoutVector NORTH = new LayoutVector("center", "bottom");
    public static final LayoutVector NORTHEAST = new LayoutVector("right", "bottom");
    public static final LayoutVector EAST = new LayoutVector("right", "center");
    public static final LayoutVector SOUTHEAST = new LayoutVector("right", "top");
    public static final LayoutVector SOUTH = new LayoutVector("center", "top");
    public static final LayoutVector SOUTHWEST = new LayoutVector("left", "top");
    public static final LayoutVector WEST = new LayoutVector("left", "center");
    public static final LayoutVector NORTHWEST = new LayoutVector("left", "bottom");
    private String origWidth = "";
    private String origHeight = "";
    private double width;
    private double height;

    public LayoutVector(String w, String h) {
        this.origWidth = w;
        this.origHeight = h;
        if (this.origWidth.equals("left")) {
            this.width = 0.0;
        } else if (this.origWidth.equals("center")) {
            this.width = 0.5;
        } else if (this.origWidth.equals("right")) {
            this.width = 1.0;
        }
        if (this.origHeight.equals("top")) {
            this.height = 1.0;
        } else if (this.origHeight.equals("center")) {
            this.height = 0.5;
        } else if (this.origHeight.equals("bottom")) {
            this.height = 0.0;
        }
    }

    public LayoutVector(double x, double y) {
        this.width = x;
        this.height = y;
    }

    public String toString() {
        String result = "LayoutVector: ";
        result = String.valueOf(result) + this.origWidth + " " + this.width + " ";
        result = String.valueOf(result) + this.origHeight + " " + this.height + "\n";
        return result;
    }

    public LayoutPoint subtract(LayoutVector second) {
        return new LayoutPoint(this.width - second.getWidth(), this.height - second.getHeight());
    }

    public LayoutVector add(LayoutPoint second) {
        return new LayoutVector(this.width + second.getX(), this.height + second.getY());
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

