/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.MultilineAnchorIterator;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;

public class MultilineTextLayoutBox
extends AbstractBranchLayoutBox {
    public static SelectionData sd = null;

    public MultilineTextLayoutBox() {
        this.name = "";
        this.children = new LayoutBox[0];
    }

    public MultilineTextLayoutBox(String name) {
        this();
        this.name = name;
    }

    public MultilineTextLayoutBox(int expectedChildren) {
        this.name = "";
        this.children = new LayoutBox[expectedChildren + 1];
    }

    public MultilineTextLayoutBox(String name, int expectedChildren) {
        this(expectedChildren);
        this.name = name;
    }

    public void addChildToBreak(LayoutFormatter f, String label) {
        String str = "";
        while (label.indexOf(10) != -1) {
            str = label.substring(0, label.indexOf(10));
            if (str.equals("")) {
                str = " ";
            }
            this.addChild(NotationLayoutBox.createCustomBox(f, str));
            label = label.substring(label.indexOf(10) + 1);
        }
        this.addChild(NotationLayoutBox.createCustomBox(f, label));
    }

    @Override
    public int getSelectionCode() {
        return 2;
    }

    @Override
    public void setDefaultSelectionData(SelectionData defaultSD) {
        sd = defaultSD;
    }

    @Override
    public SelectionData getDefaultSelectionData() {
        return sd;
    }

    @Override
    public void computeSize() {
        double width = 0.0;
        double top = 0.0;
        double bottom = this.getYorig();
        LayoutBox child = null;
        int i = 0;
        while (i < this.numChildren()) {
            child = this.getChild(i);
            if (child.getWidth() > width) {
                width = child.getWidth();
            }
            ++i;
        }
        if (this.numChildren() > 0) {
            bottom = this.getChild(0).getYorig();
            top = this.getChild(this.numChildren() - 1).getYorig() + this.getChild(this.numChildren() - 1).getHeight();
        }
        this.adjustBaselineAndOrigins(bottom);
        this.setSize(width, top - bottom);
        this.setOrigin(0.0, 0.0);
        this.validLayout = true;
    }

    @Override
    public Iterator getAnchors() {
        return new MultilineAnchorIterator(this.numChildren());
    }

    @Override
    public void addLayoutAnchor(LayoutAnchor a) {
    }

    @Override
    public void applyLayout() {
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            if (this.hasChildren()) {
                this.getChild(0).setOrigin(0.0, 0.0);
                int i = 1;
                while (i < this.numChildren()) {
                    LayoutBox prev = this.getChild(i - 1);
                    double newXorig = 0.0;
                    double newYorig = prev.getYorig() + prev.getHeight();
                    this.getChild(i).setOrigin(newXorig, newYorig);
                    ++i;
                }
                this.computeSize();
            }
        }
    }
}

