/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.DefaultLeafLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.util.RuntimePlatform;
import java.util.HashMap;
import java.util.HashSet;

public class NotationLayoutBox
extends DefaultLeafLayoutBox {
    public static final int NB_PLUS = 1;
    public static final int NB_MINUS = 2;
    public static final int NB_LPAREN = 3;
    public static final int NB_RPAREN = 4;
    public static final int NB_EQUAL = 5;
    public static final int NB_NOTEQUAL = 6;
    public static final int NB_LESSTHAN = 7;
    public static final int NB_LESSEQ = 8;
    public static final int NB_AND = 9;
    public static final int NB_NOT = 10;
    public static final int NB_OR = 11;
    public static final int NB_XOR = 12;
    public static final int NB_IMPLIES = 13;
    public static final int NB_COMMA = 14;
    public static final int NB_BAR = 15;
    public static final int NB_RANGE = 16;
    public static final int NB_ASSIGN = 17;
    public static final int NB_ELIPSIS = 18;
    public static final int NB_SOLIDUS = 19;
    public static final int NB_LBRACE = 20;
    public static final int NB_RBRACE = 21;
    public static final int NB_LBRACKET = 22;
    public static final int NB_RBRACKET = 23;
    public static final int NB_UMINUS = 24;
    public static final int NB_SEMICOLON = 26;
    public static final int NB_RIGHTARROW = 25;
    public static final int NB_LANGLE = 26;
    public static final int NB_RANGLE = 27;
    public static final int NB_UNEVAL_QUOTE = 28;
    public static final int NB_CAT = 29;
    public static final int NB_DCOLON = 30;
    public static final int NB_DI = 31;
    public static final int NB_LOCAL = 32;
    public static final int NB_GLOBAL = 33;
    public static final int NB_DESCR = 34;
    public static final int NB_OPTIONS = 35;
    public static final int NB_PROC = 36;
    public static final int NB_END = 37;
    public static final int NB_IF = 38;
    public static final int NB_THEN = 39;
    public static final int NB_ELSEIF = 40;
    public static final int NB_ELSE = 41;
    public static final int NB_FI = 42;
    public static final int NB_FOR = 43;
    public static final int NB_IN = 44;
    public static final int NB_FROM = 45;
    public static final int NB_BY = 46;
    public static final int NB_TO = 47;
    public static final int NB_WHILE = 48;
    public static final int NB_DO = 49;
    public static final int NB_OD = 50;
    public static final int NB_EXPON = 51;
    public static final int NB_EXPL_EXPON = 52;
    public static final int NB_COMMENT = 53;
    public static final int NB_READ = 54;
    public static final int NB_SAVE = 55;
    public static final int NB_STOP = 56;
    public static final int NB_ERROR = 57;
    public static final int NB_TRY = 58;
    public static final int NB_CATCH = 59;
    public static final int NB_CATCHSTAT = 60;
    public static final int NB_FINALLY = 61;
    public static final int NB_RETURN = 62;
    public static final int NB_BREAK = 63;
    public static final int NB_NEXT = 64;
    public static final int NB_MEMBER = 65;
    public static final int NB_MODDEF = 66;
    public static final int NB_EXPORT = 67;
    public static final int NB_USE = 68;
    public static final int NB_ENDIF = 69;
    public static final int NB_ENDDO = 70;
    public static final int NB_ENDPROC = 71;
    public static final int NB_ENDTRY = 72;
    public static final int NB_ENDUSE = 73;
    public static final int NB_ENDMODULE = 74;
    public static final int NB_EXPL_MULT = 75;
    public static final int NB_IMPL_MULT = 76;
    public static final int NB_UNION = 77;
    public static final int NB_INTERSECT = 78;
    public static final int NB_SUBSET = 79;
    public static final int NB_SETIN = 81;
    public static final int NB_SYMAND = 82;
    public static final int NB_SYMNOT = 83;
    public static final int NB_SYMOR = 84;
    public static final int NB_SYMXOR = 85;
    public static final int NB_SYMIMPLIES = 86;
    public static final int NB_GRADIENT = 87;
    public static final int NB_DIVERGENCE = 88;
    public static final int NB_VSIGMA = 89;
    public static final int NB_VPI = 90;
    public static final int NB_GLYPHS_BASE = 91;
    public static final int NB_VLPAREN = 91;
    public static final int NB_VRPAREN = 92;
    public static final int NB_VLBRACE = 93;
    public static final int NB_VRBRACE = 94;
    public static final int NB_VLBRACKET = 95;
    public static final int NB_VRBRACKET = 96;
    public static final int NB_VINTEGRAL = 97;
    public static final int NB_VSOLIDUS = 98;
    public static final int NB_VROOT = 99;
    public static final int NB_VLSOLIDUS = 100;
    public static final int NB_VLABSBAR = 103;
    public static final int NB_VRABSBAR = 104;
    public static final int NB_VOVERBAR = 105;
    public static final int NB_VEVALBAR = 106;
    public static final int NB_EMPTY = 107;
    public static final int NB_VDIV_SLASH = 108;
    public static final int NB_SETMINUS = 109;
    public static final int NB_CROSS = 110;
    public static final int NB_RATIO_UMINUS = 111;
    public static final int NB_OTHER_BASE = 112;
    public static final int NB_COMPOSITION = 112;
    public static final int NB_RCOMPOSITION = 113;
    public static final int NB_EXPRSEQ_OP = 114;
    public static final int NB_MODOP = 115;
    public static final int NB_LIMIT_RIGHT = 116;
    public static final int NB_LIMIT_LEFT = 117;
    public static final int NB_LIMIT_REAL = 118;
    public static final int NB_LIMIT_COMPLEX = 119;
    public static final int NB_NON_COM_MULT = 120;
    public static final int NB_IMAGE_BASE = 121;
    public static final int NB_ALPHA_L = 122;
    public static final int NB_BETA_L = 123;
    public static final int NB_GAMMA_L = 124;
    public static final int NB_DELTA_L = 125;
    public static final int NB_EPSILON_L = 126;
    public static final int NB_ZETA_L = 127;
    public static final int NB_ETA_L = 128;
    public static final int NB_THETA_L = 129;
    public static final int NB_IOTA_L = 130;
    public static final int NB_KAPPA_L = 131;
    public static final int NB_LAMBDA_L = 132;
    public static final int NB_MU_L = 133;
    public static final int NB_NU_L = 134;
    public static final int NB_XI_L = 135;
    public static final int NB_OMICRON_L = 136;
    public static final int NB_PI_L = 137;
    public static final int NB_RHO_L = 138;
    public static final int NB_SIGMA_L = 139;
    public static final int NB_TAU_L = 140;
    public static final int NB_UPSILON_L = 141;
    public static final int NB_PHI_L = 142;
    public static final int NB_CHI_L = 143;
    public static final int NB_PSI_L = 144;
    public static final int NB_OMEGA_L = 145;
    public static final int NB_ALPHA_U = 146;
    public static final int NB_BETA_U = 147;
    public static final int NB_GAMMA_U = 148;
    public static final int NB_DELTA_U = 149;
    public static final int NB_EPSILON_U = 150;
    public static final int NB_ZETA_U = 151;
    public static final int NB_ETA_U = 152;
    public static final int NB_THETA_U = 153;
    public static final int NB_IOTA_U = 154;
    public static final int NB_KAPPA_U = 155;
    public static final int NB_LAMBDA_U = 156;
    public static final int NB_MU_U = 157;
    public static final int NB_NU_U = 158;
    public static final int NB_XI_U = 159;
    public static final int NB_OMICRON_U = 160;
    public static final int NB_PI_U = 161;
    public static final int NB_RHO_U = 162;
    public static final int NB_SIGMA_U = 163;
    public static final int NB_TAU_U = 164;
    public static final int NB_UPSILON_U = 165;
    public static final int NB_PHI_U = 166;
    public static final int NB_CHI_U = 167;
    public static final int NB_PSI_U = 168;
    public static final int NB_OMEGA_U = 169;
    public static final int NB_INFINITY = 170;
    public static final int NB_ALEPH = 171;
    public static final int NB_IM = 172;
    public static final int NB_RE = 173;
    public static final int NB_CUSTOM = 174;
    public static final int NB_MAX = 175;
    public static final int FONT_DEFAULT = 0;
    public static final int FONT_PLAIN = 1;
    public static final int FONT_BOLD = 2;
    public static final int FONT_SYMBOL = 3;
    public static final int FONT_BIGSYMBOL = 6;
    public static final int FONT_NUMERIC = 4;
    public static final int FONT_MATH = 0;
    public static final int FONT_OPERATOR = 5;
    public static final int FONT_KEYWORD = 2;
    public static final int FONT_BUILTIN = 4;
    public static final int FONT_FUNCTION_NAME = 4;
    public static final int FONT_STRING = 4;
    static String[] operators = new String[175];
    static String[] keywords = new String[175];
    static String[] symbols = new String[175];
    static String[] bigSymbols = new String[175];
    static HashMap symbolMap = new HashMap();
    static HashMap imageSymbolMap = new HashMap();
    static HashMap altSymbolMap = new HashMap();
    static HashSet nameSet = new HashSet();
    private LayoutFormatter formatter = null;
    private boolean customDraw;
    private int type;
    private int fontID;

    static {
        NotationLayoutBox.buildOperators();
        NotationLayoutBox.buildKeywords();
        if (NotationLayoutBox.useInstalledSymbolFont()) {
            NotationLayoutBox.buildSymbols();
            NotationLayoutBox.buildBigSymbols();
            NotationLayoutBox.buildSymbolMap();
        } else {
            NotationLayoutBox.buildImageSymbolMap();
        }
        NotationLayoutBox.buildNameSet();
    }

    public NotationLayoutBox(int type, String value, int fontID) {
        this.setData(value);
        this.type = type;
        this.fontID = fontID;
        this.customDraw = false;
    }

    public NotationLayoutBox(int type) {
        this.type = type;
        this.fontID = 0;
        this.customDraw = true;
    }

    public static NotationLayoutBox createNotationBox(LayoutFormatter f, int type) {
        NotationLayoutBox box = null;
        int fontID = 1;
        String value = null;
        if (type >= 0 && type < 175) {
            if (f.useSymbolFont() && (!f.isInProc() || type == 25)) {
                value = symbols[type];
                if (value != null) {
                    fontID = 3;
                    box = f.createNotationBox(type, value, fontID);
                } else {
                    value = bigSymbols[type];
                    if (value != null) {
                        fontID = 6;
                        box = f.createNotationBox(type, value, fontID);
                    }
                }
            }
            if (value == null && (value = keywords[type]) != null) {
                fontID = 2;
                box = f.createNotationBox(type, value, fontID);
            }
            if (value == null && (value = operators[type]) != null) {
                fontID = 5;
                box = f.createNotationBox(type, value, fontID);
            }
        }
        if (box == null) {
            box = f.createNotationBox(type);
        }
        return box;
    }

    public static boolean useInstalledSymbolFont() {
        return !RuntimePlatform.isDec() && !RuntimePlatform.isIrix();
    }

    public static boolean isBracketNotationType(int typecode) {
        return typecode == 91 || typecode == 92 || typecode == 97 || typecode == 95 || typecode == 96 || typecode == 103 || typecode == 104 || typecode == 106 || typecode == 93 || typecode == 94;
    }

    public static NotationLayoutBox createCustomBox(LayoutFormatter f, String label) {
        NotationLayoutBox box = null;
        int fontID = f.isFunctionName() ? 4 : 1;
        f.setIsFunctionName(false);
        boolean foundSymbol = false;
        if (f.useSymbolFont() && (!f.isInProc() || f.isInOperatorProc())) {
            Integer boxType = (Integer)imageSymbolMap.get(label);
            if (boxType != null) {
                box = NotationLayoutBox.createNotationBox(f, boxType);
            } else {
                String replaced = null;
                if (label != null && !label.equals("")) {
                    replaced = NotationLayoutBox.replaceSymbolStrings(label, false);
                }
                if (replaced != null) {
                    if (NotationLayoutBox.useSymbolFont(f, fontID, replaced)) {
                        label = NotationLayoutBox.replaceSymbolStrings(label, true);
                        fontID = 3;
                    } else {
                        label = replaced;
                    }
                    foundSymbol = true;
                }
            }
        }
        if (box == null) {
            if (!foundSymbol && f.useSymbolFont() && nameSet.contains(label)) {
                fontID = 4;
            }
            if (label.length() > 0 && label.startsWith("\"") && label.endsWith("\"")) {
                fontID = 4;
            }
            box = f.createNotationBox(174, label, fontID);
        }
        return box;
    }

    public static NotationLayoutBox createCustomBox(LayoutFormatter f, String label, int fontID) {
        NotationLayoutBox box = f.createNotationBox(174, label, fontID);
        return box;
    }

    private static String replaceSymbolStrings(String str, boolean useSymbolFont) {
        String symLabel;
        String label = str;
        String cutString = NotationLayoutBox.removeEndingCharacters(label);
        String removed = null;
        if (!cutString.equals(label)) {
            removed = "";
            if (label.charAt(0) == '_') {
                removed = String.valueOf(removed) + "_";
                label = label.substring(1);
            }
            removed = String.valueOf(removed) + label.substring(cutString.length());
        }
        String string = symLabel = useSymbolFont ? (String)symbolMap.get(cutString) : (String)altSymbolMap.get(cutString);
        if (symLabel != null) {
            label = symLabel;
        }
        if (symLabel != null && removed != null) {
            if (removed.charAt(0) == '_') {
                label = String.valueOf(removed.charAt(0)) + label;
                removed = removed.substring(1);
            }
            label = String.valueOf(label) + removed;
        }
        return !label.equals(str) && symLabel != null ? label : null;
    }

    private static boolean useSymbolFont(LayoutFormatter f, int fontID, String label) {
        return false;
    }

    private static String removeEndingCharacters(String str) {
        StringBuffer copy = new StringBuffer(str);
        StringBuffer temp = new StringBuffer("");
        boolean isExpectedForm = true;
        if (copy.charAt(0) == '_') {
            copy = copy.deleteCharAt(0);
        }
        while (copy.length() > 0) {
            if (!Character.isLetter(copy.charAt(0))) break;
            temp.append(copy.charAt(0));
            copy = copy.deleteCharAt(0);
        }
        Character tilde = new Character('~');
        int i = 0;
        while (i < copy.length()) {
            Character current = new Character(copy.charAt(i));
            if (!Character.isDigit(copy.charAt(i)) && !current.equals(tilde)) {
                isExpectedForm = false;
                break;
            }
            ++i;
        }
        return isExpectedForm && temp.length() > 0 ? temp.toString() : str;
    }

    public int getSplitPosition(double width, int offset) {
        int position = -1;
        if (this.customDraw) {
            position = 0;
        } else {
            String contents = this.getData();
            if (contents != null) {
                int length = contents.length() - offset;
                position = (double)length > width ? (int)((double)offset + width - 1.0) : contents.length();
            }
        }
        return position;
    }

    public boolean isCustomDrawn() {
        return this.customDraw;
    }

    public int getType() {
        return this.type;
    }

    public int getFontID() {
        return this.fontID;
    }

    @Override
    public String getName() {
        return "Notation";
    }

    @Override
    public LineBreaker getLineBreaker() {
        return this.customDraw ? LineBreakerFactory.newLineBreaker(5) : LineBreakerFactory.newLineBreaker(8);
    }

    private static void buildOperators() {
        NotationLayoutBox.operators[1] = " + ";
        NotationLayoutBox.operators[2] = " - ";
        NotationLayoutBox.operators[3] = "(";
        NotationLayoutBox.operators[4] = ")";
        NotationLayoutBox.operators[5] = " = ";
        NotationLayoutBox.operators[6] = " <> ";
        NotationLayoutBox.operators[7] = " < ";
        NotationLayoutBox.operators[8] = " <= ";
        NotationLayoutBox.operators[14] = ", ";
        NotationLayoutBox.operators[15] = " | ";
        NotationLayoutBox.operators[16] = " .. ";
        NotationLayoutBox.operators[17] = " := ";
        NotationLayoutBox.operators[18] = " ... ";
        NotationLayoutBox.operators[19] = "/";
        NotationLayoutBox.operators[20] = "{";
        NotationLayoutBox.operators[21] = "}";
        NotationLayoutBox.operators[22] = "[";
        NotationLayoutBox.operators[23] = "]";
        NotationLayoutBox.operators[24] = "-";
        NotationLayoutBox.operators[26] = ";";
        NotationLayoutBox.operators[25] = " -> ";
        NotationLayoutBox.operators[26] = "<";
        NotationLayoutBox.operators[27] = ">";
        NotationLayoutBox.operators[28] = "'";
        NotationLayoutBox.operators[29] = " || ";
        NotationLayoutBox.operators[30] = "::";
        NotationLayoutBox.operators[31] = "d";
        NotationLayoutBox.operators[51] = "^";
        NotationLayoutBox.operators[52] = "^";
        NotationLayoutBox.operators[53] = "#";
        NotationLayoutBox.operators[60] = ":";
        NotationLayoutBox.operators[65] = ":-";
        NotationLayoutBox.operators[75] = "*";
        NotationLayoutBox.operators[76] = " ";
        NotationLayoutBox.operators[111] = "- ";
        NotationLayoutBox.operators[112] = "@";
        NotationLayoutBox.operators[113] = "@@";
        NotationLayoutBox.operators[114] = " $ ";
        NotationLayoutBox.operators[115] = " mod ";
        NotationLayoutBox.operators[116] = "+";
        NotationLayoutBox.operators[117] = "-";
        NotationLayoutBox.operators[118] = ",real";
        NotationLayoutBox.operators[119] = ",complex";
        NotationLayoutBox.operators[120] = " . ";
    }

    private static void buildKeywords() {
        NotationLayoutBox.keywords[9] = " and ";
        NotationLayoutBox.keywords[10] = "not ";
        NotationLayoutBox.keywords[11] = " or ";
        NotationLayoutBox.keywords[12] = " xor ";
        NotationLayoutBox.keywords[13] = " implies ";
        NotationLayoutBox.keywords[32] = "local";
        NotationLayoutBox.keywords[33] = "global";
        NotationLayoutBox.keywords[34] = "description";
        NotationLayoutBox.keywords[35] = "options";
        NotationLayoutBox.keywords[36] = "proc";
        NotationLayoutBox.keywords[37] = "end";
        NotationLayoutBox.keywords[38] = "if";
        NotationLayoutBox.keywords[39] = "then";
        NotationLayoutBox.keywords[40] = "elif";
        NotationLayoutBox.keywords[41] = "else";
        NotationLayoutBox.keywords[42] = "fi";
        NotationLayoutBox.keywords[43] = "for";
        NotationLayoutBox.keywords[44] = "in";
        NotationLayoutBox.keywords[45] = "from";
        NotationLayoutBox.keywords[46] = "by";
        NotationLayoutBox.keywords[47] = "to";
        NotationLayoutBox.keywords[48] = "while";
        NotationLayoutBox.keywords[49] = "do";
        NotationLayoutBox.keywords[50] = "od";
        NotationLayoutBox.keywords[54] = "read";
        NotationLayoutBox.keywords[55] = "save";
        NotationLayoutBox.keywords[56] = "stop";
        NotationLayoutBox.keywords[57] = "error";
        NotationLayoutBox.keywords[58] = "try";
        NotationLayoutBox.keywords[59] = "catch";
        NotationLayoutBox.keywords[61] = "finally";
        NotationLayoutBox.keywords[62] = "return";
        NotationLayoutBox.keywords[63] = "break";
        NotationLayoutBox.keywords[64] = "next";
        NotationLayoutBox.keywords[66] = "moddef";
        NotationLayoutBox.keywords[67] = "export";
        NotationLayoutBox.keywords[68] = "use";
        NotationLayoutBox.keywords[69] = "end if";
        NotationLayoutBox.keywords[70] = "end do";
        NotationLayoutBox.keywords[71] = "end proc";
        NotationLayoutBox.keywords[72] = "end try";
        NotationLayoutBox.keywords[73] = "end use";
        NotationLayoutBox.keywords[74] = "end module";
        NotationLayoutBox.keywords[77] = " union ";
        NotationLayoutBox.keywords[78] = " intersect ";
        NotationLayoutBox.keywords[79] = " subset ";
        NotationLayoutBox.keywords[81] = " in ";
    }

    private static void buildSymbols() {
        NotationLayoutBox.symbols[6] = NotationLayoutBox.makeString(185, true);
        NotationLayoutBox.symbols[8] = NotationLayoutBox.makeString(163, true);
        NotationLayoutBox.symbols[25] = NotationLayoutBox.makeString(174, true);
        NotationLayoutBox.symbols[31] = NotationLayoutBox.makeString(182, true);
        NotationLayoutBox.symbols[77] = NotationLayoutBox.makeString(200, true);
        NotationLayoutBox.symbols[78] = NotationLayoutBox.makeString(199, true);
        NotationLayoutBox.symbols[79] = NotationLayoutBox.makeString(205, true);
        NotationLayoutBox.symbols[81] = NotationLayoutBox.makeString(206, true);
        NotationLayoutBox.symbols[87] = NotationLayoutBox.makeString(209);
        NotationLayoutBox.symbols[88] = NotationLayoutBox.makeString(209, 215);
        NotationLayoutBox.symbols[13] = NotationLayoutBox.makeString(222, true);
    }

    private static void buildBigSymbols() {
        NotationLayoutBox.bigSymbols[89] = "S";
        NotationLayoutBox.bigSymbols[90] = "P";
    }

    private static void buildNameSet() {
        String[] names = new String[]{"abs", "AiryAi", "AiryAiZeros", "AiryBi", "AiryBiZeros", "AngerJ", "arccos", "arccosh", "arccot", "arccoth", "arccsc", "arccsch", "arcsec", "arcsech", "arcsin", "arcsinh", "arctan", "arctanh", "argument", "bernoulli", "BesselI", "BesselIZeros", "BesselJ", "BesselJZeros", "BesselK", "BesselKZeros", "BesselY", "BesselYZeros", "Beta", "binomial", "ceil", "ChebyshevT", "ChebyshevU", "Chi", "Ci", "CoulombF", "cos", "cosh", "cot", "coth", "csc", "csch", "csgn", "CylinderD", "CylinderU", "CylinderV", "D", "dawson", "dilog", "Dirac", "doublefactorial", "Ei", "EllipticCE", "EllipticCK", "EllipticCPi", "EllipticE", "EllipticF", "EllipticK", "EllipticModulus", "EllipticNome", "EllipticPi", "erf", "erfc", "erfi", "euler", "exp", "factorial", "floor", "frac", "FresnelC", "Fresnelf", "Fresnelg", "FresnelS", "GAMMA", "GaussAGM", "GegenbauerC", "HankelH1", "HankelH2", "harmonic", "Heaviside", "HermiteH", "Hypergeom", "hypergeom", "ilog", "ilog10", "ilog2", "Im", "InverseJacobiAM", "InverseJacobiCD", "InverseJacobiCN", "InverseJacobiCS", "InverseJacobiDC", "InverseJacobiDN", "InverseJacobiDS", "InverseJacobiNC", "InverseJacobiND", "InverseJacobiNS", "InverseJacobiSC", "InverseJacobiSD", "InverseJacobiSN", "JacobiAM", "JacobiCD", "JacobiCN", "JacobiCS", "JacobiDC", "JacobiDN", "JacobiDS", "JacobiNC", "JacobiND", "JacobiNS", "JacobiP", "JacobiSC", "JacobiSD", "JacobiSN", "JacobiTheta1", "JacobiTheta2", "JacobiTheta3", "JacobiTheta4", "JacobiZeta", "KelvinBei", "KelvinBer", "KelvinHei", "KelvinHer", "KelvinKei", "KelvinKer", "KummerM", "KummerU", "LaguerreL", "LambertW", "LegendreP", "LegendreQ", "LerchPhi", "Li", "lim", "ln", "lnGAMMA", "log", "log10", "LommelS1", "LommelS2", "MathieuA", "MathieuB", "MathieuC", "MathieuCE", "MathieuCEPrime", "MathieuCPrime", "MathieuExponent", "MathieuFloquet", "MathieuFloquetPrime", "MathieuS", "MathieuSE", "MathieuSEPrime", "MathieuSPrime", "max", "MeijerG", "min", "pochhammer", "polar", "polylog", "Psi", "Re", "RiemannTheta", "RootOf", "round", "sec", "sech", "Shi", "Si", "signum", "sin", "sinh", "sqrt", "Ssi", "stirling1", "stirling2", "StruveH", "StruveL", "surd", "tan", "tanh", "trunc", "WeberE", "WeierstrassP", "WeierstrassPPrime", "WeierstrassSigma", "WeierstrassZeta", "WhittakerM", "WhittakerW", "Zeta"};
        int size = names.length;
        int i = 0;
        while (i < size) {
            nameSet.add(names[i]);
            ++i;
        }
    }

    private static void buildImageSymbolMap() {
        imageSymbolMap.put("alpha", new Integer(122));
        imageSymbolMap.put("beta", new Integer(123));
        imageSymbolMap.put("gamma", new Integer(124));
        imageSymbolMap.put("delta", new Integer(125));
        imageSymbolMap.put("epsilon", new Integer(126));
        imageSymbolMap.put("zeta", new Integer(127));
        imageSymbolMap.put("eta", new Integer(128));
        imageSymbolMap.put("iota", new Integer(130));
        imageSymbolMap.put("theta", new Integer(129));
        imageSymbolMap.put("kappa", new Integer(131));
        imageSymbolMap.put("lambda", new Integer(132));
        imageSymbolMap.put("mu", new Integer(133));
        imageSymbolMap.put("nu", new Integer(134));
        imageSymbolMap.put("xi", new Integer(135));
        imageSymbolMap.put("omicron", new Integer(136));
        imageSymbolMap.put("pi", new Integer(137));
        imageSymbolMap.put("rho", new Integer(138));
        imageSymbolMap.put("sigma", new Integer(139));
        imageSymbolMap.put("tau", new Integer(140));
        imageSymbolMap.put("upsilon", new Integer(141));
        imageSymbolMap.put("phi", new Integer(142));
        imageSymbolMap.put("chi", new Integer(143));
        imageSymbolMap.put("psi", new Integer(144));
        imageSymbolMap.put("omega", new Integer(145));
        imageSymbolMap.put("Alpha", new Integer(146));
        imageSymbolMap.put("Beta", new Integer(147));
        imageSymbolMap.put("Gamma", new Integer(148));
        imageSymbolMap.put("Delta", new Integer(149));
        imageSymbolMap.put("Epsilon", new Integer(150));
        imageSymbolMap.put("Zeta", new Integer(151));
        imageSymbolMap.put("Eta", new Integer(152));
        imageSymbolMap.put("Iota", new Integer(154));
        imageSymbolMap.put("Theta", new Integer(153));
        imageSymbolMap.put("Kappa", new Integer(155));
        imageSymbolMap.put("Lambda", new Integer(156));
        imageSymbolMap.put("Mu", new Integer(157));
        imageSymbolMap.put("Nu", new Integer(158));
        imageSymbolMap.put("Xi", new Integer(159));
        imageSymbolMap.put("Omicron", new Integer(160));
        imageSymbolMap.put("Pi", new Integer(137));
        imageSymbolMap.put("Rho", new Integer(162));
        imageSymbolMap.put("Sigma", new Integer(163));
        imageSymbolMap.put("Tau", new Integer(164));
        imageSymbolMap.put("Upsilon", new Integer(165));
        imageSymbolMap.put("Phi", new Integer(166));
        imageSymbolMap.put("Psi", new Integer(168));
        imageSymbolMap.put("Omega", new Integer(169));
        imageSymbolMap.put("GAMMA", new Integer(148));
        imageSymbolMap.put("ZETA", new Integer(151));
        imageSymbolMap.put("PI", new Integer(161));
        imageSymbolMap.put("CHI", new Integer(167));
        imageSymbolMap.put("infinity", new Integer(170));
        imageSymbolMap.put("aleph", new Integer(171));
        imageSymbolMap.put("Im", new Integer(172));
        imageSymbolMap.put("Re", new Integer(173));
    }

    private static void buildSymbolMap() {
        symbolMap.put("alpha", "a");
        symbolMap.put("beta", "b");
        symbolMap.put("gamma", "g");
        symbolMap.put("delta", "d");
        symbolMap.put("epsilon", "e");
        symbolMap.put("zeta", "z");
        symbolMap.put("eta", "h");
        symbolMap.put("iota", "i");
        symbolMap.put("theta", "q");
        symbolMap.put("kappa", "k");
        symbolMap.put("lambda", "l");
        symbolMap.put("mu", "m");
        symbolMap.put("nu", "n");
        symbolMap.put("xi", "x");
        symbolMap.put("omicron", "o");
        symbolMap.put("pi", "p");
        symbolMap.put("rho", "r");
        symbolMap.put("sigma", "s");
        symbolMap.put("tau", "t");
        symbolMap.put("upsilon", "u");
        symbolMap.put("phi", "f");
        symbolMap.put("chi", "c");
        symbolMap.put("psi", "y");
        symbolMap.put("omega", "w");
        symbolMap.put("Alpha", "A");
        symbolMap.put("Beta", "B");
        symbolMap.put("Gamma", "G");
        symbolMap.put("Delta", "D");
        symbolMap.put("Epsilon", "E");
        symbolMap.put("Zeta", "z");
        symbolMap.put("Eta", "H");
        symbolMap.put("Iota", "I");
        symbolMap.put("Theta", "Q");
        symbolMap.put("Kappa", "K");
        symbolMap.put("Lambda", "L");
        symbolMap.put("Mu", "M");
        symbolMap.put("Nu", "N");
        symbolMap.put("Xi", "X");
        symbolMap.put("Omicron", "O");
        symbolMap.put("Pi", "p");
        symbolMap.put("Rho", "R");
        symbolMap.put("Sigma", "S");
        symbolMap.put("Tau", "T");
        symbolMap.put("Upsilon", "U");
        symbolMap.put("Phi", "F");
        symbolMap.put("Psi", "Y");
        symbolMap.put("Omega", "W");
        symbolMap.put("GAMMA", "G");
        symbolMap.put("ZETA", "Z");
        symbolMap.put("PI", "P");
        symbolMap.put("CHI", "C");
        symbolMap.put("infinity", "\u00a5");
        symbolMap.put("aleph", "\u00c0");
        symbolMap.put("Im", "\u00c1");
        symbolMap.put("Re", "\u00c2");
        symbolMap.put("%?", "?");
        altSymbolMap.put("alpha", "\u03b1");
        altSymbolMap.put("beta", "\u03b2");
        altSymbolMap.put("gamma", "\u03b3");
        altSymbolMap.put("delta", "\u03b4");
        altSymbolMap.put("epsilon", "\u03b5");
        altSymbolMap.put("zeta", "\u03b6");
        altSymbolMap.put("eta", "\u03b7");
        altSymbolMap.put("theta", "\u03b8");
        altSymbolMap.put("iota", "\u03b9");
        altSymbolMap.put("kappa", "\u03ba");
        altSymbolMap.put("lambda", "\u03bb");
        altSymbolMap.put("mu", "\u03bc");
        altSymbolMap.put("nu", "\u03bd");
        altSymbolMap.put("xi", "\u03be");
        altSymbolMap.put("omicron", "\u03bf");
        altSymbolMap.put("pi", "\u03c0");
        altSymbolMap.put("rho", "\u03c1");
        altSymbolMap.put("sigma", "\u03c3");
        altSymbolMap.put("tau", "\u03c4");
        altSymbolMap.put("upsilon", "\u03c5");
        altSymbolMap.put("phi", "\u03c6");
        altSymbolMap.put("chi", "\u03c7");
        altSymbolMap.put("psi", "\u03c8");
        altSymbolMap.put("omega", "\u03c9");
        altSymbolMap.put("Alpha", "\u0391");
        altSymbolMap.put("Beta", "\u0392");
        altSymbolMap.put("Gamma", "\u0393");
        altSymbolMap.put("Delta", "\u0394");
        altSymbolMap.put("Epsilon", "\u0395");
        altSymbolMap.put("Zeta", "\u03b6");
        altSymbolMap.put("Eta", "\u0397");
        altSymbolMap.put("Theta", "\u0398");
        altSymbolMap.put("Iota", "\u0399");
        altSymbolMap.put("Kappa", "\u039a");
        altSymbolMap.put("Lambda", "\u039b");
        altSymbolMap.put("Mu", "\u039c");
        altSymbolMap.put("Nu", "\u039d");
        altSymbolMap.put("Xi", "\u039e");
        altSymbolMap.put("Omicron", "\u039f");
        altSymbolMap.put("Pi", "\u03c0");
        altSymbolMap.put("Rho", "\u03a1");
        altSymbolMap.put("Sigma", "\u03a3");
        altSymbolMap.put("Tau", "\u03a4");
        altSymbolMap.put("Upsilon", "\u03a5");
        altSymbolMap.put("Phi", "\u03a6");
        altSymbolMap.put("Psi", "\u03a8");
        altSymbolMap.put("Omega", "\u03a9");
        altSymbolMap.put("GAMMA", "\u0393");
        altSymbolMap.put("ZETA", "\u0396");
        altSymbolMap.put("PI", "\u03a0");
        altSymbolMap.put("CHI", "\u03a7");
        altSymbolMap.put("infinity", "\u221e");
        altSymbolMap.put("aleph", "\u2135");
        altSymbolMap.put("Im", "\u2111");
        altSymbolMap.put("Re", "\u211c");
        altSymbolMap.put("%?", "?");
    }

    private static String makeString(int value) {
        Character ch = new Character((char)value);
        return ch.toString();
    }

    private static String makeString(int first, int second) {
        char[] array = new char[]{(char)first, (char)second};
        return String.valueOf(array);
    }

    private static String makeString(int value, boolean spacing) {
        return " " + NotationLayoutBox.makeString(value) + " ";
    }
}

