/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.PowerAnchorIterator;
import com.maplesoft.client.prettyprinter.TTYFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;

public class PowerLayoutBox
extends AbstractBranchLayoutBox {
    public static final double EXPONENT_ADJUSTMENT_FACTOR = 0.4;
    public static SelectionData sd = null;
    private static LineBreaker lb = LineBreakerFactory.newLineBreaker(9);
    private static final double ITALICS_ADJUSTMENT_FACTOR = 0.19438030913772;
    private boolean forceNoItalicAdjustment = false;
    private AbstractFormatter formatter = null;

    public PowerLayoutBox() {
        this.name = "";
        this.children = new LayoutBox[2];
    }

    public PowerLayoutBox(String name) {
        this();
        this.name = name;
    }

    public PowerLayoutBox(LayoutBox base, LayoutBox exponent) {
        this.name = "";
        this.children = new LayoutBox[2];
        this.children[0] = base;
        this.children[1] = exponent;
        this.numChildren = 2;
    }

    public PowerLayoutBox(String name, LayoutBox base, LayoutBox exponent) {
        this(base, exponent);
        this.name = name;
    }

    public PowerLayoutBox(String name, LayoutBox base, LayoutBox exponent, boolean forceNoItalicAdj) {
        this(name, base, exponent);
        this.forceNoItalicAdjustment = forceNoItalicAdj;
    }

    public PowerLayoutBox(LayoutBox base, LayoutBox exponent, boolean forceNoItalicAdj, AbstractFormatter format) {
        this(base, exponent);
        this.forceNoItalicAdjustment = forceNoItalicAdj;
        this.formatter = format;
    }

    @Override
    public void setSelectionData(SelectionData sd) {
    }

    @Override
    public SelectionData getSelectionData() {
        if (this.getDefaultSelectionData() == null) {
            this.setDefaultSelectionData(new SelectionData(this.getSelectionCode()));
            int[] nArray = new int[2];
            nArray[1] = 1;
            int[] EWTraversal = nArray;
            sd.setStandardNorthSouthArray();
            sd.setTraversalEastWest(EWTraversal);
        }
        return sd;
    }

    @Override
    public void setDefaultSelectionData(SelectionData defaultSD) {
        sd = defaultSD;
    }

    @Override
    public SelectionData getDefaultSelectionData() {
        return sd;
    }

    @Override
    public void setLineBreaker(LineBreaker linebreaker) {
        lb = linebreaker;
    }

    @Override
    public LineBreaker getLineBreaker() {
        return lb;
    }

    @Override
    public void computeSize() {
        double width = 0.0;
        double height = 0.0;
        double yOrig = 0.0;
        LayoutBox base = this.getChild(0);
        LayoutBox exp = this.getChild(1);
        width = base.getXorig() + exp.getXorig() + exp.getWidth();
        double baseHeightForCalculation = base.getHeight();
        if (this.formatter != null && !(this.formatter instanceof TTYFormatter) && baseHeightForCalculation == 0.0) {
            baseHeightForCalculation = this.formatter.getFontHeight(0);
        }
        height = baseHeightForCalculation - exp.getYorig();
        yOrig = exp.getYorig();
        this.baseline = base.getBaseline();
        if (yOrig != 0.0) {
            LayoutPoint offset = new LayoutPoint(0.0, -yOrig);
            this.getChild(0).translateOrigin(offset);
            this.getChild(1).translateOrigin(offset);
            this.baseline -= yOrig;
        }
        this.setSize(width, height);
        this.setOrigin(0.0, 0.0);
        this.validLayout = true;
    }

    @Override
    public Iterator getAnchors() {
        return new PowerAnchorIterator();
    }

    @Override
    public void addLayoutAnchor(LayoutAnchor a) {
    }

    @Override
    public void applyLayout() {
        double italicsAdjustment = 0.0;
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            if (this.hasChildren()) {
                LayoutBox base = this.getChild(0);
                LayoutBox exp = this.getChild(1);
                if (base.hasChildren() && !base.isLayoutValid()) {
                    base.applyLayout();
                }
                if (exp.hasChildren() && !exp.isLayoutValid()) {
                    exp.applyLayout();
                }
                base.setOrigin(0.0, 0.0);
                double fontHeight = 0.0;
                if (this.formatter != null && !(this.formatter instanceof TTYFormatter)) {
                    fontHeight = this.formatter.getFontHeight(0);
                }
                double baseHeight = base.getHeight();
                double newXorig = base.getXorig() + base.getWidth() + baseHeight * italicsAdjustment;
                double fontHeightAdjustment = fontHeight > 1.0 ? fontHeight * 0.4 : 0.0;
                double newYorig = -1.0 * exp.getHeight() + fontHeightAdjustment;
                exp.setOrigin(newXorig, newYorig);
                this.computeSize();
            }
        }
    }
}

