/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.BracketLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.template.IntegralTemplate;

public class ResizableNotationBox
extends InlineLayoutBox {
    public static final int HEIGHT_CONSTRAINT = 0;
    public static final int WIDTH_CONSTRAINT = 1;
    public static final int HEIGHT_WIDTH_CONSTRAINT = 2;
    public static final int HEIGHT_SUM_CONSTRAINT = 3;
    public static final int NULL_CONSTRAINT = 4;
    public static final int NESTED_INTEGRAL_CONSTRAINT = 5;
    public static int counter = 0;
    protected LayoutFormatter formatter;
    protected NotationLayoutBox box;
    protected int constraintType;
    protected LayoutBox constraint1;
    protected LayoutBox constraint2;
    protected boolean adjustBaseline;
    protected boolean singleHeight;
    protected double baselineFF;

    public ResizableNotationBox(LayoutFormatter formatter, int boxType, int constraintType, LayoutBox constraint) {
        this(formatter, boxType, constraintType, constraint, null);
    }

    public ResizableNotationBox(LayoutFormatter formatter, int boxType, int constraintType, LayoutBox constraint1, LayoutBox constraint2) {
        this.box = NotationLayoutBox.createNotationBox(formatter, boxType);
        this.addChild(this.box);
        this.formatter = formatter;
        this.constraintType = constraintType;
        this.constraint1 = constraint1;
        this.constraint2 = constraint2;
        this.baselineFF = 0.0;
    }

    public void setBaselineAdjustment(boolean state) {
        this.adjustBaseline = state;
    }

    @Override
    public void invalidateAll() {
        this.validLayout = false;
    }

    @Override
    public LayoutBox getPairEndPointBox() {
        return this.getChild(0).getPairEndPointBox();
    }

    @Override
    public void setPairEndPointBox(LayoutBox box) {
        this.getChild(0).setPairEndPointBox(box);
    }

    @Override
    public void computeSize() {
        double height1 = 0.0;
        double height2 = 0.0;
        double width1 = 0.0;
        double width2 = 0.0;
        switch (this.constraintType) {
            case 4: {
                this.formatter.resizeNotationBox(this.box);
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
                break;
            }
            case 0: {
                height1 = this.constraint1.getHeight();
                if (this.constraint2 == null) {
                    this.formatter.resizeNotationBox(this.box, height1);
                } else {
                    height2 = this.constraint2.getHeight();
                    this.formatter.resizeNotationBox(this.box, height1, height2);
                }
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
                break;
            }
            case 1: {
                width1 = this.constraint1.getWidth();
                if (this.constraint2 == null) {
                    this.formatter.resizeNotationBox(this.box, width1);
                } else {
                    width2 = this.constraint2.getWidth();
                    this.formatter.resizeNotationBox(this.box, width1, width2);
                }
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
                break;
            }
            case 2: {
                width1 = this.constraint1.getWidth();
                height1 = this.constraint2.getHeight();
                this.formatter.resizeNotationBox(this.box, width1, height1);
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
                break;
            }
            case 3: {
                height1 = this.constraint1.getHeight() + this.constraint2.getHeight();
                this.formatter.resizeNotationBox(this.box, height1);
                break;
            }
            case 5: {
                height1 = 10.0;
                LayoutBox integral = IntegralTemplate.findLastConsecutiveIntegralBox(this.constraint1);
                LayoutBox hsource = integral.getChild(0).getChild(2);
                height1 = hsource.getHeight();
                this.formatter.resizeNotationBox(this.box, height1);
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
            }
        }
        this.setSize(this.box.getWidth(), this.box.getHeight());
        this.box.validate(true);
        this.validate(true);
    }

    @Override
    public void applyLayout() {
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            if (this.constraint1 != null && !this.constraint1.isLayoutValid()) {
                this.constraint1.applyLayout();
            }
            if (this.constraint2 != null && !this.constraint2.isLayoutValid()) {
                this.constraint2.applyLayout();
            }
            this.computeSize();
        }
    }

    @Override
    public void setSelectionData(SelectionData sd) {
        super.setSelectionData(sd);
        if (this.getChild(0) != null) {
            this.getChild(0).setSelectionData(sd);
        }
    }

    public void setBaselineFudgeFactor(double ff) {
        this.baselineFF = ff;
    }

    @Override
    public void setBaseline(double baseline) {
        this.baseline = baseline;
    }

    public NotationLayoutBox getBox() {
        return this.box;
    }

    public LayoutFormatter getFormatter() {
        return this.formatter;
    }

    public LayoutBox getConstraint1() {
        return this.constraint1;
    }

    public int getType() {
        return this.box.getType();
    }

    public void setBoxBaseline(double baseline) {
        this.box.setBaseline(baseline);
    }

    public boolean getResize() {
        boolean b = false;
        if (this.box instanceof BracketLayoutBox) {
            b = ((BracketLayoutBox)this.box).getResize();
        }
        return b;
    }

    public void setResize(boolean b) {
        if (this.box instanceof BracketLayoutBox) {
            ((BracketLayoutBox)this.box).setResize(b);
        }
    }
}

