/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.PostLayoutJobQueue;

public class SubexpressionLabelLayoutBox
extends DefaultLayoutBox {
    private LayoutBox target;
    private LayoutBox renderer;
    private int labelNumber;
    private String label;
    private String lprint;

    public SubexpressionLabelLayoutBox(LayoutFormatter formatter, LayoutBox target, String lprint) {
        this.target = target;
        this.lprint = lprint;
        PostLayoutJobQueue jobs = formatter.getPostLayoutJobQueue();
        boolean oldJob = jobs.containsJobForIdentifier(lprint);
        if (oldJob) {
            AbstractFormatter.SubexpressionLabelJob job = (AbstractFormatter.SubexpressionLabelJob)jobs.getJob(lprint);
            this.labelNumber = job.getSubexpressionBox().getLabelNumber();
        } else {
            this.labelNumber = jobs.getSubexpressionNumber();
            ++this.labelNumber;
            jobs.setSubexpressionNumber(this.labelNumber);
        }
        this.renderer = formatter.createNotationBox(174, this.getLabel(), 1);
        this.addChild(this.renderer);
        this.setSize(this.renderer.getWidth(), this.renderer.getHeight());
        this.setBaseline(this.renderer.getBaseline());
        if (!oldJob) {
            jobs.addJob(lprint, new AbstractFormatter.SubexpressionLabelJob(formatter, this));
        }
    }

    public void setLabelTarget(LayoutBox target) {
        this.target = target;
    }

    public String getLPrint() {
        return this.lprint;
    }

    public LayoutBox getLabelTarget() {
        return this.target;
    }

    public int getLabelNumber() {
        return this.labelNumber;
    }

    public LayoutBox getRenderer() {
        return this.renderer;
    }

    @Override
    public Dag getDag() {
        Dag toReturn = null;
        if (this.target != null) {
            toReturn = this.target.getDag();
        }
        return toReturn;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = "%" + this.labelNumber;
        }
        return this.label;
    }

    @Override
    public String getData() {
        return this.getLabel();
    }
}

