/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ProcLayoutBox;
import com.maplesoft.client.prettyprinter.TTYBracketLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakLayoutBox;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class TTYFormatter
extends AbstractFormatter {
    private static final int PRODUCT_WIDTH = 10;
    private static final int PRODUCT_HEIGHT = 5;
    private static final int SUM_WIDTH = 6;
    private static final int SUM_HEIGHT = 5;
    private static final int MIN_INTEGRAL_HEIGHT = 5;
    private static final int ROW_SEPARATOR = 1;
    private static final int COLUMN_SEPARATOR = 2;
    public static final int DEFAULT_BREAK_WIDTH = 79;
    private static final int INLINE_PROD_TEST_LENGTH = 4;
    private static final int INLINE_NUMERATOR_INDEX = 0;
    private static final int INLINE_DENOMINATOR_INDEX = 2;
    private static final int INLINE_RATIONAL_TEST_INDEX = 3;
    private static final HashSet expandedSpecialFunctions = new HashSet();
    private boolean centerIndent = true;
    private int breakWidth = 79;
    private char[][] outputBuffer = null;

    static {
        String[] functionArray = new String[]{"abs", "conjugate", "diff", "Diff", "Eval", "Int", "Limit", "matrix", "Matrix", "MATRIX", "PIECEWISE", "product", "Product", "RTABLE", "sum", "Sum", "@", "$", "<,>", "<|>", "vector", "union", "intersect", "minus", "subset", "in", "mod", "series", "_SERIES", "modp1", "modp2", ".", "Typesetting:-mfrac", "Typesetting:-mi", "Typesetting:-mmultiscripts", "Typesetting:-mscripts", "Typesetting:-mn", "Typesetting:-mo", "Typesetting:-mover", "Typesetting:-mambiguous", "Typesetting:-maction", "Typesetting:-mroot", "Typesetting:-mrow", "Typesetting:-mspace", "Typesetting:-msqrt", "Typesetting:-ms", "Typesetting:-mstyle", "Typesetting:-msub", "Typesetting:-msubsup", "Typesetting:-msup", "Typesetting:-mtext", "Typesetting:-merror", "Typesetting:-munder", "Typesetting:-mphantom", "Typesetting:-munderover", "Typesetting:-mprescripts", "Typesetting:-none", "Typesetting:-mfenced", "Typesetting:-mtable", "Typesetting:-mtr", "Typesetting:-mtd", "Typesetting:-mprintslash", "Typesetting:-mparsed", "Typesetting:-mverbatim"};
        int i = 0;
        while (i < functionArray.length) {
            expandedSpecialFunctions.add(functionArray[i]);
            ++i;
        }
    }

    @Override
    public void setBreakWidth(double breakWidth) {
        this.breakWidth = (int)breakWidth;
    }

    @Override
    public double getBreakWidth() {
        return this.breakWidth;
    }

    @Override
    public double getBearingMultiplier() {
        return 0.0;
    }

    @Override
    public boolean useSymbolFont() {
        return false;
    }

    @Override
    public boolean useRootSymbol() {
        return false;
    }

    public void setCenterIndent(boolean centerIndent) {
        this.centerIndent = centerIndent;
    }

    @Override
    public int getRowSeparator() {
        return 1;
    }

    @Override
    public int getColumnSeparator() {
        return 2;
    }

    @Override
    public LayoutBox format(Dag dag, String styleName, double width) {
        this.updateContext();
        LayoutBox b = super.format(dag, styleName, width);
        b.linebreak(this, width);
        return b;
    }

    public void display(Dag dag, PrintWriter writer) {
        this.display(dag, writer, 79.0);
    }

    public void display(Dag dag, PrintWriter writer, double displayWidth) {
        LayoutBox box = this.format(dag, "Text Output", displayWidth);
        LayoutBox b = box.getDisplayLayoutBox();
        int width = (int)b.getWidth();
        int indent = Math.max((this.breakWidth - width) / 2 - 1, 0);
        int n = indent = this.centerIndent ? indent : 0;
        if (box instanceof LineBreakLayoutBox) {
            Iterator ic = box.getChildren();
            while (ic.hasNext()) {
                this.display((LayoutBox)ic.next(), writer, indent);
            }
        } else if (b instanceof LineBreakLayoutBox) {
            this.display(b, writer);
        } else if (b instanceof ProcLayoutBox) {
            this.display(box, writer, 0);
        } else {
            this.display(box, writer, indent);
        }
    }

    private void display(LayoutBox box, PrintWriter writer) {
        LayoutBox b = box.getDisplayLayoutBox();
        int width = (int)b.getWidth();
        int indent = Math.max((this.breakWidth - width) / 2 - 1, 0);
        int n = indent = this.centerIndent ? indent : 0;
        if (box instanceof LineBreakLayoutBox) {
            Iterator ic = box.getChildren();
            while (ic.hasNext()) {
                this.display((LayoutBox)ic.next(), writer, indent);
            }
        } else if (b instanceof LineBreakLayoutBox) {
            this.display(b, writer);
        } else if (b instanceof ProcLayoutBox) {
            this.display(box, writer, 0);
        } else {
            this.display(box, writer, indent);
        }
    }

    public void display(LayoutBox box, PrintWriter writer, int indent) {
        LayoutBox b = box.getDisplayLayoutBox();
        int height = (int)b.getHeight();
        int width = (int)b.getWidth();
        if (this.outputBuffer == null || this.outputBuffer.length < height) {
            this.outputBuffer = new char[height][];
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < height) {
            if (this.outputBuffer[i] == null || this.outputBuffer[i].length < width) {
                this.outputBuffer[i] = new char[width];
            }
            Arrays.fill(this.outputBuffer[i], ' ');
            ++i;
        }
        this.fill(b, this.outputBuffer, -b.getXorig(), -b.getYorig());
        String separator = System.getProperty("line.separator");
        i = 0;
        while (i < height) {
            if (width > 0) {
                j = 0;
                while (j < indent) {
                    writer.print(' ');
                    ++j;
                }
                char[] row = this.outputBuffer[i];
                j = 0;
                while (j < width) {
                    writer.print(row[j]);
                    ++j;
                }
                writer.flush();
            }
            writer.print(separator);
            ++i;
        }
    }

    private char[][] fill(LayoutBox b, char[][] out, double xoffset, double yoffset) {
        LayoutPoint p = b.getOrigin();
        xoffset += p.getX();
        yoffset += p.getY();
        if (b instanceof NotationLayoutBox && ((NotationLayoutBox)b).isCustomDrawn()) {
            this.drawNotationBox((NotationLayoutBox)b, out, (int)xoffset, (int)yoffset);
        } else if (b.hasChildren()) {
            Iterator ic = b.getChildren();
            while (ic.hasNext()) {
                this.fill((LayoutBox)ic.next(), out, xoffset, yoffset);
            }
        } else {
            this.drawString(b.getData(), out, (int)xoffset, (int)yoffset);
        }
        return out;
    }

    private void drawString(String value, char[][] out, int xoffset, int yoffset) {
        try {
            if (xoffset > -1 && yoffset > -1 && out.length > 0 && out[0].length > 0) {
                int length = value.length();
                char[] row = out[yoffset];
                int i = 0;
                while (i < length) {
                    row[xoffset + i] = value.charAt(i);
                    ++i;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public boolean useInLine(Dag dag) {
        boolean result = false;
        if (dag.getType() == 18) {
            if (dag.getLength() > 0 && dag.getChild(0).getType() == 8) {
                result = !expandedSpecialFunctions.contains(dag.getChild(0).getData());
            }
        } else if (dag.getType() == 14) {
            if (dag.getLength() == 4 && DagUtil.isMinusOne(dag.getChild(3))) {
                String firstChild = dag.getChild(0).getData();
                String secondChild = dag.getChild(2).getData();
                if (firstChild != null && firstChild.length() == 1 && secondChild != null && secondChild.length() == 1) {
                    result = true;
                }
            }
        } else if (dag.getType() == 10) {
            result = true;
        }
        return result;
    }

    private void drawNotationBox(NotationLayoutBox b, char[][] out, int xoffset, int yoffset) {
        int width = (int)b.getWidth();
        switch (b.getType()) {
            case 98: 
            case 105: {
                char[] line = new char[width];
                Arrays.fill(line, b.getType() == 98 ? (char)'-' : '_');
                System.arraycopy(line, 0, out[yoffset], xoffset, width);
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 103: 
            case 104: 
            case 106: {
                ((TTYBracketLayoutBox)b).drawBracket(out, xoffset, yoffset);
                break;
            }
            case 90: {
                this.drawProduct(out, xoffset, yoffset);
                break;
            }
            case 89: {
                this.drawSum(out, xoffset, yoffset);
                break;
            }
            case 108: {
                this.drawString("/", out, xoffset, yoffset);
                break;
            }
            case 109: {
                this.drawString(" minus ", out, xoffset, yoffset);
            }
        }
    }

    private void drawProduct(char[][] out, int xoffset, int yoffset) {
        int i = 0;
        try {
            out[yoffset][xoffset] = 44;
            i = 1;
            while (i < 9) {
                out[yoffset][xoffset + i] = 45;
                ++i;
            }
            out[yoffset][xoffset + 10 - 1] = 39;
            ++yoffset;
            i = 0;
            while (i < 4) {
                out[yoffset + i][xoffset + 3] = 124;
                out[yoffset + i][xoffset + 10 - 4] = 124;
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException abE) {
            abE.printStackTrace();
        }
    }

    private void drawSum(char[][] out, int xoffset, int yoffset) {
        int i = 0;
        try {
            i = 0;
            while (i < 5) {
                out[yoffset][xoffset + i] = 45;
                out[yoffset + 5 - 1][xoffset + i] = 45;
                ++i;
            }
            i = 1;
            while (i < 2) {
                out[yoffset + i][xoffset + i] = 92;
                out[yoffset + 5 - 1 - i][xoffset + i] = 47;
                ++i;
            }
            out[yoffset + 2][xoffset + 2] = 41;
        }
        catch (ArrayIndexOutOfBoundsException abE) {
            abE.printStackTrace();
        }
    }

    @Override
    public void resizeNotationBox(NotationLayoutBox b) {
        boolean found = true;
        double height = 1.0;
        double width = 1.0;
        switch (b.getType()) {
            case 90: {
                height = 5.0;
                width = 10.0;
                break;
            }
            case 89: {
                height = 5.0;
                width = 6.0;
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                width = 1.0;
                height = 1.0;
                break;
            }
            default: {
                found = false;
            }
        }
        if (found) {
            b.setSize(width, height);
        }
    }

    @Override
    public void resizeNotationBox(NotationLayoutBox b, double hint) {
        boolean found = true;
        double height = 1.0;
        double width = 1.0;
        switch (b.getType()) {
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 103: 
            case 104: 
            case 106: {
                height = hint;
                break;
            }
            case 93: 
            case 94: {
                height = hint;
                height = (int)height | 1;
                width = height == 1.0 ? 1 : 2;
                break;
            }
            case 105: {
                width = hint;
                break;
            }
            case 97: {
                height = hint;
                if (height < 5.0) {
                    height = 5.0;
                }
                width = 3.0;
                b.setBaseline(height / 2.0);
                break;
            }
            case 108: {
                width = 1.0;
                height = 1.0;
                break;
            }
            default: {
                found = false;
            }
        }
        if (found) {
            b.setSize(width, height);
        }
    }

    @Override
    public void resizeNotationBox(NotationLayoutBox b, double hint1, double hint2) {
        boolean found = true;
        double height = 1.0;
        double width = 1.0;
        switch (b.getType()) {
            case 98: {
                width = hint1 > hint2 ? hint1 : hint2;
                break;
            }
            default: {
                found = false;
            }
        }
        if (found) {
            b.setSize(width, height);
        }
    }

    @Override
    public double getFontWidth(int fontID) {
        return 1.0;
    }

    @Override
    public double getFontHeight(int fontID) {
        return 1.0;
    }

    @Override
    public NotationLayoutBox createNotationBox(int type) {
        NotationLayoutBox box = null;
        if (NotationLayoutBox.isBracketNotationType(type)) {
            box = new TTYBracketLayoutBox(type);
        }
        if (box == null) {
            box = new TTYTextLayoutBox(type);
        }
        return box;
    }

    @Override
    public NotationLayoutBox createNotationBox(int type, String value, int fontID) {
        return new TTYTextLayoutBox(type, value, fontID);
    }

    private static class TTYTextLayoutBox
    extends NotationLayoutBox {
        TTYTextLayoutBox(int type, String value, int fontID) {
            super(type, value, fontID);
            this.setSize(value.length(), 1.0);
        }

        TTYTextLayoutBox(int type) {
            super(type);
        }
    }
}

