/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.linebreaker;

import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.DefaultLineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;

public class BracketLineBreaker
extends DefaultLineBreaker {
    @Override
    public LayoutBox linebreak(LayoutBox source, LineBreakLayoutBox target, LayoutFormatter formatter, double widthHint, boolean forceLine, double xOffset, double yOffset) {
        LineBreakLayoutBox rootBox = target;
        if (BracketLineBreaker.fitsOnLine(source, rootBox, widthHint)) {
            rootBox.addChild(source, xOffset, yOffset);
        } else {
            xOffset += source.getXorig();
            yOffset += source.getYorig();
            LayoutBox leftBracket = source.getChild(1);
            LayoutBox rightBracket = source.getChild(2);
            LayoutBox content = source.getChild(0);
            if (leftBracket == null || rightBracket == null || content == null) {
                LineBreakerFactory.newLineBreaker(0).linebreak(source, rootBox, formatter, widthHint, forceLine, xOffset, yOffset);
            } else {
                if (!this.findGoodBreakPoint(source, rootBox, widthHint, 0)) {
                    rootBox.finishCurrentRow(formatter);
                    rootBox.createNewRow(formatter);
                }
                rootBox.addChild(leftBracket, xOffset, yOffset);
                BracketLineBreaker.nextLinebreak(content, rootBox, formatter, widthHint, false, xOffset, yOffset);
                if (!BracketLineBreaker.fitsOnLine(rightBracket, rootBox, widthHint)) {
                    rootBox.finishCurrentRow(formatter);
                    rootBox.createNewRow(formatter);
                }
                rootBox.addChild(rightBracket, xOffset, yOffset);
            }
        }
        return rootBox;
    }

    @Override
    public boolean findGoodBreakPoint(LayoutBox box, LineBreakLayoutBox rootBox, double width, int startIndex) {
        boolean goodBreak = false;
        if (startIndex == 2) {
            goodBreak = true;
        } else {
            LayoutBox left = box.getChild(1);
            LayoutBox content = box.getChild(0);
            double adjustedWidth = 0.0;
            if (startIndex == 0 && left != null) {
                adjustedWidth = width - left.getWidth();
            }
            if (adjustedWidth > 0.0 && width > 0.0) {
                LineBreaker breaker = content.getLineBreaker();
                goodBreak = breaker.findGoodBreakPoint(content, rootBox, width, 0);
            } else if (adjustedWidth <= 0.0 && width > 0.0) {
                goodBreak = true;
            }
        }
        return goodBreak;
    }
}

