/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.linebreaker;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.LayoutSwitchBox;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.IndentSelectionData;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LineBreakLayoutBox
extends DefaultLayoutBox {
    protected ArrayList childRows;
    protected LineBrokenRow currentRow;
    protected LayoutBox firstChild = null;
    protected LayoutBox lastChild = null;
    protected LayoutFormatter formatter = null;
    protected double procWidth = 0.0;
    protected double currentBaseline = 0.0;
    public static int LEFT = 0;
    public static int RIGHT = 1;

    public LineBreakLayoutBox(LayoutFormatter f) {
        this.formatter = f;
        this.childRows = new ArrayList();
        this.currentRow = new LineBrokenRow();
    }

    @Override
    public void addChild(LayoutBox child) {
        this.addChild(child, 0.0, 0.0);
    }

    public void addChild(LayoutBox child, double xOffset, double yOffset) {
        LayoutBox child2;
        int type = -4;
        if (child instanceof NotationLayoutBox) {
            type = ((NotationLayoutBox)child).getType();
        } else if (child.numChildren() > 0 && (child2 = child.getChild(0)) instanceof NotationLayoutBox) {
            type = ((NotationLayoutBox)child2).getType();
        }
        if (type != -4 && (type == 71 || type == 69 || type == 41 || type == 40 || type == 70 || type == 59 || type == 61 || type == 72 || type == 74) && this.currentRow.numChildren() == 1) {
            this.currentRow.removeChild(this.currentRow.numChildren() - 1);
            if (this.formatter.getProcCount() > 1) {
                this.addIndentChild(this.formatter, this.formatter.getProcCount() - 1);
            }
            this.firstChild = this.currentRow.getChild(this.currentRow.numChildren() - 1);
        }
        this.firstChild = this.firstChild == null ? child : this.firstChild;
        this.lastChild = child;
        this.currentRow.addChild(child, xOffset, yOffset);
        this.currentBaseline = Math.max(this.currentBaseline, child.getBaseline());
    }

    public LayoutBox getFirstChild() {
        return this.firstChild;
    }

    public LayoutBox getLastChild() {
        return this.lastChild;
    }

    @Override
    public int numChildren() {
        return this.childRows.size();
    }

    public LayoutBox getCurrentRow() {
        return this.currentRow;
    }

    public double getCurrentBaseline() {
        return this.currentBaseline;
    }

    @Override
    public SelectionData getSelectionData() {
        SelectionData data = null;
        if (this.getIdealLayoutBox() == this) {
            data = super.getSelectionData();
        } else {
            this.getIdealLayoutBox().getSelectionData();
        }
        return data;
    }

    @Override
    public boolean hasChildren() {
        return !this.childRows.isEmpty();
    }

    @Override
    public Iterator getChildren() {
        return this.childRows.iterator();
    }

    public ArrayList getChildArray() {
        return this.childRows;
    }

    public void setProcWidth(double width) {
        this.procWidth = width;
    }

    public double getProcWidth() {
        return this.procWidth;
    }

    public void createNewRow(LayoutFormatter formatter) {
        this.currentBaseline = 0.0;
        this.currentRow = new LineBrokenRow();
        IndentSelectionData sd = new IndentSelectionData();
        this.currentRow.setSelectionData(sd);
        int numLevels = formatter.getProcCount();
        if (!formatter.isInProc() && numLevels == 0) {
            this.addIndentChild(formatter, 1);
            sd.setNumIndents(1);
        } else {
            int indentAmount = 0;
            int i = 0;
            while (i < numLevels) {
                indentAmount += formatter.getColumnSeparator();
                ++i;
            }
            while (this.procWidth > 0.0 && (double)indentAmount > this.procWidth) {
                indentAmount = (int)((double)indentAmount - this.procWidth);
            }
            if (indentAmount > 0) {
                this.addIndentChild(indentAmount);
                sd.setNumIndents(1);
            }
        }
    }

    public void createNewRow() {
        this.currentBaseline = 0.0;
        this.currentRow = new LineBrokenRow();
    }

    public void addIndentChild(LayoutFormatter f, int numIndents) {
        IndentLayoutBox procIndent = new IndentLayoutBox();
        procIndent.setSize(numIndents * f.getColumnSeparator(), 0.0);
        this.currentRow.addChild(procIndent, 0.0, 0.0);
        if (this.currentRow.getSelectionData() instanceof IndentSelectionData) {
            IndentSelectionData sd = (IndentSelectionData)this.currentRow.getSelectionData();
            sd.setNumIndents(sd.getNumIndents() + 1);
        }
    }

    public void addIndentChild(double indentSize) {
        IndentLayoutBox procIndent = new IndentLayoutBox();
        procIndent.setSize(indentSize, 0.0);
        this.currentRow.addChild(procIndent);
    }

    public void finishCurrentRow(LayoutFormatter formatter) {
        this.childRows.add(this.currentRow);
        if (this.numChildren() != 0) {
            IndentLayoutBox rowSpacer = new IndentLayoutBox();
            double height = 0.5 * (double)formatter.getRowSeparator();
            if (height < 1.0 && !formatter.isInProc()) {
                height += 1.0;
            }
            rowSpacer.setSize(0.0, height);
            this.childRows.add(rowSpacer);
        }
    }

    public void finishCurrentRow() {
        this.childRows.add(this.currentRow);
    }

    public double getCurrentLineWidth() {
        return this.currentRow.getLineWidth();
    }

    @Override
    public LayoutBox getChild(int index) {
        LayoutBox child = null;
        if (index >= 0 && index < this.childRows.size()) {
            child = (LayoutBox)this.childRows.get(index);
        }
        return child;
    }

    @Override
    public void applyLayout() {
        double height = 0.0;
        double width = 0.0;
        for (LayoutBox row : this.childRows) {
            if (row instanceof LineBrokenRow) {
                ((LineBrokenRow)row).applyLayout();
            }
            width = Math.max(row.getWidth(), width);
            row.setOrigin(0.0, height);
            height += row.getHeight();
        }
        this.setSize(width, height);
        this.setOrigin(0.0, 0.0);
    }

    @Override
    public void computeSize() {
    }

    public static class IndentLayoutBox
    extends DefaultLayoutBox {
    }

    public static class LineBrokenRow
    extends AbstractBranchLayoutBox {
        private static final SelectionData sd = new StandardSelectionData(1);
        protected double lineWidth = 0.0;

        public double getLineWidth() {
            return this.lineWidth;
        }

        public void addLineWidth(double width) {
            this.lineWidth += width;
        }

        @Override
        public void addChild(LayoutBox child) {
            this.addChild(child, 0.0, 0.0);
        }

        @Override
        public void removeChild(int index) {
            LayoutBox child = super.getChild(index);
            this.lineWidth -= child.getWidth();
            super.removeChild(index);
        }

        public void addChild(LayoutBox child, double xOffset, double yOffset) {
            LineBrokenRowBox box = new LineBrokenRowBox(child, this.lineWidth, yOffset);
            super.addChild(box);
            this.addLineWidth(child.getWidth());
            this.validate(false);
        }

        @Override
        public void applyLayout() {
            this.computeSize();
        }

        @Override
        public void addLayoutAnchor(LayoutAnchor a) {
        }

        @Override
        public void computeSize() {
            int i = 0;
            int numChildren = this.numChildren();
            double top = 0.0;
            double bottom = 0.0;
            double height = 0.0;
            double maxTop = 0.0;
            double minBottom = 0.0;
            boolean assigned = false;
            LayoutBox child = null;
            i = 0;
            while (i < numChildren) {
                child = this.getChild(i);
                bottom = child.getYorig();
                height = child.getHeight();
                top = bottom + height;
                if (height > 0.0) {
                    if (bottom < minBottom || !assigned) {
                        minBottom = bottom;
                    }
                    if (top > maxTop || !assigned) {
                        maxTop = top;
                    }
                    assigned = true;
                }
                ++i;
            }
            if (minBottom != 0.0) {
                LayoutPoint offset = new LayoutPoint(0.0, -minBottom);
                i = 0;
                while (i < numChildren) {
                    super.getChild(i).translateOrigin(offset);
                    ++i;
                }
                maxTop -= minBottom;
            }
            this.setSize(this.lineWidth, maxTop);
            this.setOrigin(0.0, 0.0);
        }

        @Override
        public Iterator getAnchors() {
            return null;
        }

        @Override
        public SelectionData getSelectionData() {
            return sd;
        }

        @Override
        public void setSelectionData(SelectionData selectionData) {
        }

        @Override
        public String toString() {
            return "LineBreakLayoutBox";
        }
    }

    public static class LineBrokenRowBox
    extends AbstractBranchLayoutBox {
        private static SelectionData selectionData = null;

        public LineBrokenRowBox(LayoutBox child, double xOffset, double yOffset) {
            if (child instanceof LayoutSwitchBox) {
                double xOrigin = child.getXorig();
                double yOrigin = child.getYorig();
                child = ((LayoutSwitchBox)child).getChildBox();
                child.setOrigin(xOrigin, yOrigin);
            }
            double childOrigin = child.getYorig();
            super.addChild(child);
            this.setOrigin(xOffset, yOffset + childOrigin);
            this.setSize(child.getWidth(), child.getHeight());
            child.setOrigin(0.0, 0.0);
        }

        @Override
        public List getSelectionBoxes() {
            return super.getChild(0).getSelectionBoxes();
        }

        @Override
        public LayoutBox getPairEndPointBox() {
            return super.getChild(0).getPairEndPointBox();
        }

        @Override
        public void setPairEndPointBox(LayoutBox box) {
            super.getChild(0).setPairEndPointBox(box);
        }

        @Override
        public void addLayoutAnchor(LayoutAnchor a) {
        }

        @Override
        public void applyLayout() {
        }

        @Override
        public void computeSize() {
        }

        @Override
        public Iterator getAnchors() {
            return null;
        }

        @Override
        public Dag getDag() {
            Dag dag = null;
            LayoutBox child = null;
            child = super.getChild(0);
            if (child != null) {
                dag = child.getDag();
            }
            return dag;
        }

        @Override
        public SelectionData getSelectionData() {
            SelectionData sd = null;
            LayoutBox child = null;
            child = super.getChild(0);
            if (child != null) {
                sd = child.getSelectionData();
            }
            return sd;
        }

        @Override
        public void setSelectionData(SelectionData selectionData) {
        }

        @Override
        public String toString() {
            return "row-box";
        }
    }
}

