/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.linebreaker;

import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.DefaultLineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakLayoutBox;
import java.util.LinkedList;

public class StringLineBreaker
extends DefaultLineBreaker {
    private static final int HUGE = 100000;

    @Override
    public LayoutBox linebreak(LayoutBox box, LineBreakLayoutBox target, LayoutFormatter formatter, double width, boolean forceLine, double xOffset, double yOffset) {
        LineBreakLayoutBox rootBox = target;
        if (StringLineBreaker.fitsOnLine(box, rootBox, width)) {
            rootBox.addChild(box, xOffset, yOffset);
        } else if (box instanceof NotationLayoutBox) {
            this.linebreakNotationBox(box, target, formatter, width, forceLine, xOffset, yOffset);
        } else {
            int size = box.numChildren() - 1;
            int i = 0;
            while (i < size) {
                LayoutBox child = box.getChild(i);
                this.linebreak(child, target, formatter, width, forceLine, xOffset, yOffset);
                if (i < size - 1) {
                    rootBox.finishCurrentRow(formatter);
                    rootBox.createNewRow(formatter);
                }
                ++i;
            }
        }
        return rootBox;
    }

    public LayoutBox linebreakNotationBox(LayoutBox box, LineBreakLayoutBox target, LayoutFormatter formatter, double width, boolean forceLine, double xOffset, double yOffset) {
        Object b = null;
        LineBreakLayoutBox rootBox = target;
        xOffset += box.getXorig();
        yOffset += box.getYorig();
        NotationLayoutBox nbox = (NotationLayoutBox)box;
        int fontID = nbox.getFontID();
        String source = box.getData();
        int sourceLength = source.length();
        int position = 0;
        StringBuffer subdata = new StringBuffer();
        boolean firstLine = true;
        LinkedList<NotationLayoutBox> selectedBoxes = new LinkedList<NotationLayoutBox>();
        while (position < sourceLength) {
            double remainder = width - rootBox.getCurrentLineWidth();
            int endIndex = nbox.getSplitPosition(remainder, position);
            if (endIndex < 0) {
                endIndex = sourceLength;
            } else if (endIndex > position + 1 && endIndex < sourceLength) {
                --endIndex;
            }
            if (firstLine) {
                if (this.badLineBreak(position, endIndex, sourceLength)) {
                    endIndex = position;
                }
            } else if (endIndex == position) {
                ++endIndex;
            }
            if (endIndex > position) {
                subdata.append(source.substring(position, endIndex));
                if (endIndex != sourceLength) {
                    subdata.append("\\");
                }
                NotationLayoutBox subdataBox = NotationLayoutBox.createCustomBox(formatter, subdata.toString(), fontID);
                box.setDisplayLayoutBox(subdataBox);
                StringBuffer subdataTwo = new StringBuffer(subdata.toString());
                int lastSpace = subdataTwo.toString().lastIndexOf(" ") + 1;
                if (lastSpace > 0) {
                    subdataTwo = new StringBuffer(subdataTwo.substring(0, lastSpace));
                }
                NotationLayoutBox subdataTwoBox = NotationLayoutBox.createCustomBox(formatter, subdataTwo.toString(), fontID);
                if (endIndex != sourceLength && subdataTwoBox.getWidth() + rootBox.getCurrentLineWidth() >= width * 0.8) {
                    subdataTwoBox.setIdealLayoutBox(box);
                    rootBox.addChild(subdataTwoBox, xOffset, yOffset);
                    selectedBoxes.add(subdataTwoBox);
                    subdataTwoBox.setSelectionBoxes(selectedBoxes);
                    int numCharsChopped = subdata.length() - subdataTwo.length();
                    endIndex -= numCharsChopped;
                } else {
                    subdataBox.setIdealLayoutBox(box);
                    rootBox.addChild(subdataBox, xOffset, yOffset);
                    selectedBoxes.add(subdataBox);
                    subdataBox.setSelectionBoxes(selectedBoxes);
                }
            }
            if ((position = endIndex) < sourceLength) {
                rootBox.finishCurrentRow(formatter);
                rootBox.createNewRow(formatter);
            }
            subdata.setLength(0);
            firstLine = false;
        }
        return rootBox;
    }

    private boolean badLineBreak(int start, int end, int length) {
        return end - start <= 3 && end < length;
    }

    public static class LinebrokenStringTerminatorBox
    extends InlineLayoutBox {
        public LinebrokenStringTerminatorBox() {
            this.width = 100000.0;
        }
    }
}

