/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.selection;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.LayoutBox;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EquationSelectionEvent
extends EventObject {
    protected boolean consumed = false;
    protected boolean actionTrigger;
    protected boolean contextTrigger;
    protected boolean multiSelection;
    protected EventObject sourceEvent;
    protected LayoutBox selected;
    protected List multiSelected;
    protected Dag selectedDag;
    protected boolean partialSelection = false;
    protected LayoutBox rootBox;

    public EquationSelectionEvent(LayoutBox rootBox, EventObject sourceEvent, LayoutBox selected) {
        this(rootBox, sourceEvent, selected, null, null);
    }

    public EquationSelectionEvent(LayoutBox rootBox, EventObject sourceEvent, LayoutBox selected, Dag dag) {
        this(rootBox, sourceEvent, selected, null, dag);
    }

    public EquationSelectionEvent(LayoutBox rootBox, EventObject sourceEvent) {
        this(rootBox, sourceEvent, null, null, null);
    }

    public EquationSelectionEvent(LayoutBox rootBox, EventObject sourceEvent, List multiSelected) {
        this(rootBox, sourceEvent, null, multiSelected, null);
    }

    public EquationSelectionEvent(LayoutBox rootBox, EventObject sourceEvent, List multiSelected, Dag repDag) {
        this(rootBox, sourceEvent, null, multiSelected, repDag);
    }

    private EquationSelectionEvent(LayoutBox rootBox, EventObject sourceEvent, LayoutBox selected, List multiSelected, Dag repDag) {
        super(sourceEvent.getSource());
        this.sourceEvent = sourceEvent;
        this.rootBox = rootBox;
        this.selected = selected;
        this.multiSelected = multiSelected;
        this.selectedDag = repDag;
        this.multiSelection = multiSelected != null;
    }

    public void setPartialSelection(boolean partialSelection) {
        this.partialSelection = partialSelection;
    }

    public boolean isPartialSelection() {
        return this.partialSelection;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    public void setSelectedDag(Dag dag) {
        this.selectedDag = dag;
    }

    public EventObject getSourceEvent() {
        return this.sourceEvent;
    }

    public LayoutBox getRootBox() {
        return this.rootBox;
    }

    public boolean isActionTrigger() {
        return this.actionTrigger;
    }

    public boolean isContextTrigger() {
        return this.contextTrigger;
    }

    public void setActionTrigger(boolean actionTrigger) {
        this.actionTrigger = actionTrigger;
        this.contextTrigger = !this.actionTrigger;
    }

    public void setContextTrigger(boolean contextTrigger) {
        this.contextTrigger = contextTrigger;
        this.actionTrigger = !this.contextTrigger;
    }

    public LayoutBox getSelectedBox() {
        return this.selected;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public List getMultiSelectedBoxes() {
        return this.multiSelected;
    }

    public boolean isClearedSelection() {
        return this.selected == null && this.multiSelected == null;
    }

    public String getSelectedName() {
        String name = "";
        if (this.multiSelection) {
            name = ((LayoutBox)this.multiSelected.get(0)).getName();
        } else if (this.selected != null) {
            name = this.selected.getName();
        }
        return name;
    }

    public String getData() {
        return this.selected == null ? null : this.selected.getData();
    }

    public boolean hasData() {
        return this.selected == null ? false : this.selected.getData() != null && !this.selected.getData().equals("");
    }

    public boolean hasChildren() {
        return this.selected == null ? false : this.selected.numChildren() > 0;
    }

    public Iterator getChildren() {
        return this.selected == null ? new LinkedList().iterator() : this.selected.getChildren();
    }

    public String getLPrint() {
        Dag dag = null;
        dag = this.selected == null ? null : this.selected.getDag();
        dag = dag == null && this.selectedDag != null ? this.selectedDag : dag;
        return dag == null ? "" : DagBuilder.lPrint(dag);
    }

    public Dag getDag() {
        Dag toReturn = this.selectedDag;
        toReturn = toReturn == null && this.selected != null ? this.selected.getIdealLayoutBox().getDag() : toReturn;
        return toReturn;
    }
}

