/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;

public class BracketTemplate {
    static final SelectionData bracketSD = new StandardSelectionData(4);
    public static final int ALWAYS_BRACKET_PRECEDENCE = -1;
    static final LayoutAnchor RIGHT_BRACKET_ANCHOR = new LayoutAnchor(0, LayoutVector.WEST, 1, LayoutVector.EAST, 2);
    static final LayoutAnchor LEFT_BRACKET_ANCHOR = new LayoutAnchor(0, LayoutVector.EAST, 2, LayoutVector.WEST, 2);
    public static final int GREATER_EQUAL = 0;
    public static final int GREATER = 1;

    static {
        bracketSD.setContextHelpAvailable(false);
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox box, Dag dag, int precedence) {
        return BracketTemplate.apply(formatter, box, dag, precedence, 1);
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox box, Dag dag, int precedence, int type) {
        LayoutBox brBox = box;
        boolean add = false;
        int compareTo = DagBuilder.getPrecedence(dag, formatter);
        if (type == 0) {
            add = compareTo >= precedence;
        } else {
            boolean bl = add = compareTo > precedence;
        }
        if (add) {
            brBox = BracketTemplate.apply(formatter, box, 91, 92);
        }
        return brBox;
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox proceeding, LayoutBox box) {
        return BracketTemplate.apply(formatter, proceeding, box, 91, 92);
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox box) {
        return BracketTemplate.apply(formatter, null, box, 91, 92);
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox box, int leftID, int rightID) {
        return BracketTemplate.apply(formatter, null, box, leftID, rightID);
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox preceeding, LayoutBox box, int leftID, int rightID) {
        DefaultLayoutBox brBox = new DefaultLayoutBox(3);
        brBox.setLineBreaker(LineBreakerFactory.newLineBreaker(1));
        box.applyLayout();
        brBox.addChild(box);
        brBox.setDag(box.getDag());
        double height = box.getHeight() + box.getDescentAdjustment();
        boolean resize = true;
        int smallLeftID = -1;
        int smallRightID = -1;
        double minHeight = -1.0;
        if (leftID == 91) {
            smallLeftID = 3;
            smallRightID = 4;
        } else if (leftID == 93) {
            smallLeftID = 20;
            smallRightID = 21;
        } else if (leftID == 95) {
            smallLeftID = 22;
            smallRightID = 23;
        }
        if (smallLeftID >= 0) {
            minHeight = NotationLayoutBox.createNotationBox(formatter, smallLeftID).getHeight();
        }
        if ((height == 0.0 || height < 1.7 * minHeight) && (box.numChildren() == 0 || box.getData() == null || box.getData() != null && box.getData().length() == 0)) {
            if (minHeight > 0.0) {
                leftID = smallLeftID;
                rightID = smallRightID;
                resize = false;
            } else if (preceeding != null) {
                height = preceeding.getHeight();
                if (formatter.getFontHeight(1) > 1.0) {
                    box.setSize(box.getWidth(), height);
                    box.setBaseline(height);
                }
            }
        }
        AbstractLayoutBox left = null;
        AbstractLayoutBox right = null;
        if (resize) {
            left = new ResizableNotationBox(formatter, leftID, 0, box);
            right = new ResizableNotationBox(formatter, rightID, 0, box);
            brBox.addLayoutAnchor(LayoutAnchor.RIGHTOF_01);
            brBox.addLayoutAnchor(LayoutAnchor.LEFTOF_02);
        } else {
            left = NotationLayoutBox.createNotationBox(formatter, leftID);
            right = NotationLayoutBox.createNotationBox(formatter, rightID);
            brBox.addLayoutAnchor(RIGHT_BRACKET_ANCHOR);
            brBox.addLayoutAnchor(LEFT_BRACKET_ANCHOR);
        }
        left.setSelectionData(bracketSD);
        right.setSelectionData(bracketSD);
        left.setPairEndPointBox(right);
        right.setPairEndPointBox(left);
        brBox.addChild(left);
        brBox.addChild(right);
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        int[] traversal = nArray;
        SelectionData sd = new SelectionData(1);
        sd.setTraversalEastWest(traversal);
        sd.setStandardNorthSouthArray();
        sd.setFirstCaretPosition(1);
        brBox.setSelectionData(sd);
        return brBox;
    }
}

