/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class CurlTemplate
implements SpecialFunctionTemplate {
    private static final String CURL_NAME = "curl";
    private static final SelectionData curlSD = new StandardSelectionData(4);

    static {
        curlSD.setContextHelpAvailable(false);
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        CurlLayoutBox box = null;
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] path = nArray;
        if (formatter.useSymbolFont() && args != null && args.length == 1) {
            box = new CurlLayoutBox(CURL_NAME, 3);
            NotationLayoutBox left = NotationLayoutBox.createNotationBox(formatter, 87);
            ResizableNotationBox cross = new ResizableNotationBox(formatter, 110, 4, null, null);
            cross.setBaselineAdjustment(true);
            left.setSelectionData(curlSD);
            cross.setSelectionData(curlSD);
            LayoutBox right = DagBuilder.createLayout(formatter, args[0]);
            right = AncestorArrayLayoutBox.wrapWithAncestorData(right, function, path);
            right = BracketTemplate.apply(formatter, right, args[0], 3);
            box.addChild(left);
            box.addChild(cross);
            box.addChild(right);
            box.setLineBreaker(LineBreakerFactory.newLineBreaker(11));
        }
        return box;
    }

    static class CurlLayoutBox
    extends InlineLayoutBox {
        CurlLayoutBox(String s, int i) {
            super(s, i);
        }

        CurlLayoutBox() {
        }
    }
}

