/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.DivideTemplate;
import com.maplesoft.client.prettyprinter.template.PowerTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class DiffTemplate
implements SpecialFunctionTemplate {
    boolean fail = false;

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        DiffLayoutBox box = null;
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] funcPath = nArray;
        int[] varPath = new int[]{1, 1};
        if (args != null && args.length >= 2 && !formatter.isInProc()) {
            int maxSize = this.extractMaxVariables(args, 1);
            Dag[] vars = new Dag[maxSize];
            int[] order = new int[maxSize];
            String[] labels = new String[maxSize];
            this.fail = false;
            this.extractVariables(args, 1, vars, order, labels);
            if (!this.fail) {
                this.fail = true;
                int i = 0;
                while (i < maxSize) {
                    if (order[i] > 0) {
                        this.fail = false;
                        break;
                    }
                    ++i;
                }
            }
            if (maxSize > 0 && !this.fail) {
                LayoutBox diff = this.buildDifferentialBox(formatter, args[0], vars, order, labels);
                diff = AncestorArrayLayoutBox.wrapWithAncestorData(diff, function, varPath);
                LayoutBox func = DagBuilder.createLayout(formatter, args[0]);
                func = BracketTemplate.apply(formatter, func, args[0], 3);
                func = AncestorArrayLayoutBox.wrapWithAncestorData(func, function, funcPath);
                box = new DiffLayoutBox(diff, NotationLayoutBox.createNotationBox(formatter, 76), func);
            }
            this.fail = false;
        }
        return box;
    }

    private LayoutBox buildDifferentialBox(LayoutFormatter formatter, Dag function, Dag[] vars, int[] order, String[] labels) {
        int totalOrder = 0;
        int numvars = 0;
        int i = 0;
        boolean firstLabel = true;
        StringBuffer buffer = new StringBuffer();
        i = 0;
        while (i < vars.length) {
            if (vars[i] == null) break;
            totalOrder += order[i];
            ++numvars;
            if (labels[i] != null) {
                if (!firstLabel) {
                    buffer.append("+");
                }
                buffer.append(labels[i]);
                firstLabel = false;
            }
            ++i;
        }
        if (buffer.length() == 0) {
            buffer = null;
        }
        boolean dNotation = numvars == 1 ? this.numFunctionVars(function, vars[0]) == 0 : false;
        LayoutBox numerator = this.buildVarBox(formatter, null, totalOrder, buffer != null ? buffer.toString() : null, dNotation);
        InlineLayoutBox denominator = new InlineLayoutBox(vars.length);
        i = vars.length - 1;
        while (i > -1) {
            denominator.addChild(NotationLayoutBox.createNotationBox(formatter, 76));
            if (vars[i] == null) break;
            denominator.addChild(this.buildVarBox(formatter, vars[i], order[i], labels[i], dNotation));
            --i;
        }
        return DivideTemplate.apply(formatter, numerator, denominator);
    }

    private LayoutBox buildVarBox(LayoutFormatter formatter, Dag var, int order, String label, boolean dNotation) {
        InlineLayoutBox box = new InlineLayoutBox(2);
        LayoutBox base = null;
        boolean n = false;
        if (dNotation) {
            if (var == null) {
                base = NotationLayoutBox.createCustomBox(formatter, "d");
            } else {
                box.addChild(NotationLayoutBox.createCustomBox(formatter, "d"));
                base = DagBuilder.createLayout(formatter, var);
            }
        } else if (var == null) {
            base = NotationLayoutBox.createNotationBox(formatter, 31);
        } else {
            box.addChild(NotationLayoutBox.createNotationBox(formatter, 31));
            base = DagBuilder.createLayout(formatter, var);
        }
        if (order != 1 || label != null) {
            String value = null;
            value = label == null ? Integer.toString(order) : (order == 0 ? label : String.valueOf(Integer.toString(order)) + "+" + label);
            formatter.incSuperscriptCount();
            NotationLayoutBox exp = NotationLayoutBox.createCustomBox(formatter, value);
            formatter.decSuperscriptCount();
            if (!dNotation && var == null) {
                box.addChild(PowerTemplate.apply(formatter, base, exp, true));
            } else {
                box.addChild(PowerTemplate.apply(formatter, base, exp));
            }
        } else {
            box.addChild(base);
        }
        return box;
    }

    private int extractMaxVariables(Dag[] args, int base) {
        int count = 0;
        int i = base;
        while (i < args.length) {
            count += this.extractMaxVariables(args[i]);
            ++i;
        }
        return count;
    }

    private int extractMaxVariables(Dag arg) {
        int count = 0;
        if (arg.getType() == 30) {
            int length = arg.getLength();
            int j = 0;
            while (j < length) {
                count += this.extractMaxVariables(arg.getChild(j));
                ++j;
            }
        } else {
            ++count;
        }
        return count;
    }

    private int numFunctionVars(Dag dag, Dag var) {
        int numvars = 0;
        boolean checkSubDags = false;
        int base = 0;
        int i = 0;
        if (dag == null) {
            numvars = 0;
        } else {
            switch (dag.getType()) {
                case 8: 
                case 10: {
                    numvars = DagBuilder.lPrint(dag).equals(DagBuilder.lPrint(var)) ? 0 : 1;
                    break;
                }
                case 18: 
                case 34: {
                    base = 1;
                    checkSubDags = true;
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 29: {
                    base = 0;
                    checkSubDags = true;
                    break;
                }
                default: {
                    numvars = 0;
                }
            }
            if (checkSubDags) {
                int length = dag.getLength();
                i = base;
                while (i < length) {
                    numvars += this.numFunctionVars(dag.getChild(i), var);
                    ++i;
                }
            }
        }
        return numvars;
    }

    private void extractVariables(Dag[] args, int base, Dag[] vars, int[] order, String[] labels) {
        Dag varDiff = null;
        Dag varOrder = null;
        Dag name = null;
        Dag[] kids = null;
        int position = 0;
        int i = base;
        while (i < args.length) {
            switch (args[i].getType()) {
                case 8: 
                case 9: 
                case 10: {
                    varDiff = args[i];
                    position = this.findVariable(vars, varDiff);
                    if (position < 0) {
                        position = this.addVariable(vars, varDiff);
                    }
                    if (position < 0) break;
                    int n = position;
                    order[n] = order[n] + 1;
                    break;
                }
                case 30: {
                    if (!(args[i] instanceof BranchDag)) break;
                    this.extractVariables(((BranchDag)args[i]).getChildrenAsArray(), 0, vars, order, labels);
                    break;
                }
                case 18: {
                    name = args[i].getChild(0);
                    if (!name.getData().equals("$")) break;
                    if (args[i].getLength() > 1) {
                        Dag varDag = args[i].getChild(1);
                        varDiff = varDag.getChild(0);
                        varOrder = varDag.getChild(1);
                        position = this.findVariable(vars, varDiff);
                        if (position < 0) {
                            position = this.addVariable(vars, varDiff);
                        }
                    } else {
                        position = -1;
                    }
                    if (position < 0) break;
                    if (varOrder.getType() == 2) {
                        int value = Integer.parseInt(varOrder.getData());
                        int n = position;
                        order[n] = order[n] + value;
                        break;
                    }
                    if (labels[position] == null) {
                        labels[position] = DagBuilder.lPrint(varOrder);
                        break;
                    }
                    int n = position;
                    labels[n] = String.valueOf(labels[n]) + "+";
                    int n2 = position;
                    labels[n2] = String.valueOf(labels[n2]) + DagBuilder.lPrint(varOrder);
                    break;
                }
                default: {
                    this.fail = true;
                }
            }
            ++i;
        }
    }

    private int addVariable(Dag[] vars, Dag varDiff) {
        int position = -1;
        int i = 0;
        while (i < vars.length) {
            if (vars[i] == null) {
                vars[i] = varDiff;
                position = i;
                break;
            }
            ++i;
        }
        return position;
    }

    private int findVariable(Dag[] vars, Dag varDiff) {
        int position = -1;
        int i = 0;
        while (i < vars.length) {
            if (vars[i] == varDiff) {
                position = i;
                break;
            }
            if (vars[i] == null) break;
            ++i;
        }
        return position;
    }

    static class DiffLayoutBox
    extends InlineLayoutBox {
        DiffLayoutBox(LayoutBox diff, LayoutBox notation, LayoutBox func) {
            super(3);
            this.addChild(diff);
            this.addChild(notation);
            this.addChild(func);
        }

        DiffLayoutBox() {
        }
    }
}

