/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.ProdDagFactory;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;

public class DivideTemplate {
    public static final int LAYOUT_STACK = 0;
    public static final int LAYOUT_INLINE = 1;
    public static final int BRACKET_NUMERATOR = 2;
    public static final int BRACKET_DENOMINATOR = 4;
    public static final int LAYOUT_RATIONAL = 8;
    private static final int[] NS_TRAVERSAL;
    private static final int[] EXIT_TRAVERSAL;
    private static final int[] EW_TRAVERSAL;
    private static SelectionData divideSD;

    static {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = -10;
        NS_TRAVERSAL = nArray;
        EXIT_TRAVERSAL = new int[]{-10};
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[2] = 2;
        nArray2[3] = -10;
        EW_TRAVERSAL = nArray2;
        divideSD = null;
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox numerator, LayoutBox denominator) {
        return DivideTemplate.apply(formatter, numerator, denominator, 0);
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox numerator, LayoutBox denominator, int mode) {
        int operator = 0;
        LayoutAnchor anchor1 = null;
        LayoutAnchor anchor2 = null;
        numerator.setLineBreaker(LineBreakerFactory.newLineBreaker(10));
        denominator.setLineBreaker(LineBreakerFactory.newLineBreaker(10));
        if (formatter.isInProc() || (mode & 1) != 0) {
            if ((mode & 2) != 0) {
                numerator = BracketTemplate.apply(formatter, numerator, 91, 92);
                numerator.setLineBreaker(LineBreakerFactory.newLineBreaker(1));
            }
            if ((mode & 4) != 0) {
                denominator = BracketTemplate.apply(formatter, denominator, 91, 92);
                denominator.setLineBreaker(LineBreakerFactory.newLineBreaker(1));
            }
            operator = formatter.isInProc() || (mode & 8) != 0 ? 19 : 108;
            anchor1 = LayoutAnchor.RIGHTOF_01;
            anchor2 = LayoutAnchor.LEFTOF_02;
        } else {
            operator = 98;
            anchor1 = LayoutAnchor.UNDER_01;
            anchor2 = LayoutAnchor.OVER_02;
        }
        return DivideTemplate.reallyApply(formatter, numerator, denominator, operator, anchor1, anchor2);
    }

    public static LayoutBox reallyApply(LayoutFormatter formatter, LayoutBox numerator, LayoutBox denominator, int operator, LayoutAnchor anchor1, LayoutAnchor anchor2) {
        DefaultLayoutBox box = new DefaultLayoutBox("divide", 3);
        if (numerator.getDag() != null && denominator.getDag() != null) {
            Dag divDag = ProdDagFactory.create(numerator.getDag(), 1, denominator.getDag(), -1);
            box.setDag(divDag);
        }
        AbstractLayoutBox divide = null;
        int linebreakMode = 6;
        if (operator == 19) {
            divide = NotationLayoutBox.createNotationBox(formatter, operator);
        } else if (operator == 98) {
            divide = new ResizableNotationBox(formatter, operator, 1, numerator, denominator);
            ((ResizableNotationBox)divide).setBaselineAdjustment(true);
            linebreakMode = 5;
        } else {
            divide = new ResizableNotationBox(formatter, operator, 0, numerator, denominator);
            ((ResizableNotationBox)divide).setBaselineAdjustment(true);
        }
        if (divideSD == null) {
            divideSD = new StandardSelectionData(4);
            divideSD.setContextHelpAvailable(false);
        }
        divide.setSelectionData(divideSD);
        if (anchor2 == LayoutAnchor.OVER_02 && anchor1 == LayoutAnchor.UNDER_01) {
            divide.setLeftSideBearing(1.0 * formatter.getBearingMultiplier());
            divide.setRightSideBearing(1.0 * formatter.getBearingMultiplier());
        }
        box.addChild(divide);
        box.addChild(numerator);
        box.addChild(denominator);
        box.addLayoutAnchor(anchor1);
        box.addLayoutAnchor(anchor2);
        box.setLineBreaker(LineBreakerFactory.newLineBreaker(linebreakMode));
        SelectionData sd = new SelectionData(1);
        boolean leftRightArrangement = anchor1 == LayoutAnchor.RIGHTOF_01 && anchor2 == LayoutAnchor.LEFTOF_02;
        int[] traversal = leftRightArrangement ? EW_TRAVERSAL : NS_TRAVERSAL;
        int[] nstraversal = leftRightArrangement ? EXIT_TRAVERSAL : NS_TRAVERSAL;
        sd.setTraversalNorthSouth(nstraversal);
        sd.setTraversalEastWest(traversal);
        sd.setFirstCaretPosition(1);
        box.setSelectionData(sd);
        return box;
    }
}

