/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;

public abstract class NeutralOpInfixTemplate {
    public static LayoutBox apply(LayoutFormatter f, Dag function, Dag args) {
        NeuOpInfixLayoutBox box = null;
        if (args != null && args.getLength() == 2) {
            NotationLayoutBox notation = null;
            String operatorName = function.getData();
            if (operatorName != null && operatorName.startsWith("&")) {
                notation = f.createNotationBox(174, operatorName, 5);
                int precedence = FunctionDagFactory.getNeutralOperatorPrecedence(operatorName);
                LayoutBox left = DagBuilder.createLayout(f, args.getChild(0));
                left = BracketTemplate.apply(f, left, args.getChild(0), precedence, 0);
                LayoutBox right = DagBuilder.createLayout(f, args.getChild(1));
                right = BracketTemplate.apply(f, right, args.getChild(1), precedence, 0);
                box = new NeuOpInfixLayoutBox(f, left, notation, right);
            }
        }
        return box;
    }

    static class NeuOpInfixLayoutBox
    extends InlineLayoutBox {
        NeuOpInfixLayoutBox(LayoutFormatter f, LayoutBox left, LayoutBox notation, LayoutBox right) {
            super(5);
            this.addChild(left);
            this.addChild(NotationLayoutBox.createCustomBox(f, " "));
            this.addChild(notation);
            this.addChild(NotationLayoutBox.createCustomBox(f, " "));
            this.addChild(right);
        }

        NeuOpInfixLayoutBox() {
        }
    }
}

