/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.MatrixLayoutBox;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class PiecewiseTemplate
implements SpecialFunctionTemplate {
    private static final SelectionData braceSD = new StandardSelectionData(4);

    static {
        braceSD.setContextHelpAvailable(false);
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        LayoutBox box = null;
        int length = args.length;
        if (length > 0) {
            int numChildren;
            box = new DefaultLayoutBox(3);
            MatrixLayoutBox pieces = new MatrixLayoutBox(length, 3, 1);
            pieces.setJustification(1);
            int i = 0;
            while (i < length) {
                Dag arg = args[i];
                LayoutBox term = DagBuilder.createLayout(formatter, arg.getChild(0));
                DefaultLayoutBox spaces = new DefaultLayoutBox();
                spaces.setSize(formatter.getColumnSeparator(), 0.0);
                LayoutBox condition = DagBuilder.createLayout(formatter, arg.getChild(1));
                pieces.addChild(term);
                pieces.addChild(spaces);
                pieces.addChild(condition);
                ++i;
            }
            SelectionData piecesSD = new SelectionData(3);
            int numChildrenModThree = numChildren = pieces.numChildren();
            while (numChildrenModThree >= 3) {
                numChildrenModThree -= 3;
            }
            if (numChildrenModThree == 0) {
                int[] EWtraversal = new int[numChildren / 3 * 2];
                int[] NStraversal = new int[(numChildren / 3 + 1) * 3];
                int i2 = 0;
                while (i2 < 3) {
                    int j = 0;
                    while (j < numChildren / 3) {
                        NStraversal[i2 * (1 + numChildren / 3) + j] = j * 3 + i2;
                        ++j;
                    }
                    ++i2;
                }
                NStraversal[numChildren + 2] = -10;
                NStraversal[2 * (numChildren / 3) + 1] = -10;
                NStraversal[numChildren / 3] = -10;
                i2 = 0;
                while (i2 < EWtraversal.length / 2) {
                    EWtraversal[i2 * 2] = i2 * 2 + i2;
                    EWtraversal[i2 * 2 + 1] = i2 * 2 + i2 + 2;
                    ++i2;
                }
                piecesSD.setTraversalEastWest(EWtraversal);
                piecesSD.setTraversalNorthSouth(NStraversal);
            } else {
                piecesSD.setStandardEastWestArray(pieces);
                piecesSD.setStandardNorthSouthArray();
            }
            pieces.setSelectionData(piecesSD);
            DefaultLayoutBox separator = new DefaultLayoutBox();
            separator.setSize(1.0, 0.0);
            ResizableNotationBox brace = new ResizableNotationBox(formatter, 93, 0, pieces);
            brace.setSelectionData(braceSD);
            brace.setBaselineAdjustment(true);
            brace.setBaselineFudgeFactor(formatter.getFontHeight(1) / 3.0);
            box.addChild(brace);
            box.addChild(separator);
            box.addChild(pieces);
            box.addLayoutAnchor(new LayoutAnchor(0, LayoutVector.EAST, 1, LayoutVector.WEST));
            box.addLayoutAnchor(new LayoutAnchor(1, LayoutVector.EAST, 2, LayoutVector.WEST));
            box.applyLayout();
            if (box.getWidth() < formatter.getSafeBreakWidth()) {
                SelectionData boxSD = new SelectionData(1);
                int[] nArray = new int[4];
                nArray[1] = 2;
                nArray[2] = -10;
                nArray[3] = 1;
                int[] EWBoxTraversal = nArray;
                boxSD.setStandardNorthSouthArray();
                boxSD.setTraversalEastWest(EWBoxTraversal);
                box.setSelectionData(boxSD);
                box.setLineBreaker(LineBreakerFactory.newLineBreaker(5));
            } else {
                box = FunctionDagFactory.createGenericLayout(formatter, function);
            }
        }
        return box;
    }
}

