/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.PowerLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;

public class PowerTemplate {
    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox base, LayoutBox exponent) {
        return PowerTemplate.apply(formatter, base, exponent, false);
    }

    public static LayoutBox apply(LayoutFormatter formatter, LayoutBox base, LayoutBox exponent, boolean forceNoItalicAdjustment) {
        AbstractBranchLayoutBox box = null;
        if (formatter.isInProc()) {
            box = new InlineLayoutBox(3);
            base = BracketTemplate.apply(formatter, base, base.getDag(), 3, 0);
            box.addChild(base);
            box.addChild(NotationLayoutBox.createNotationBox(formatter, 51));
            box.addChild(exponent);
            box.setLineBreaker(LineBreakerFactory.newLineBreaker(9));
        } else {
            if (base.getDag() != null) {
                base = BracketTemplate.apply(formatter, base, base.getDag(), 3, 0);
            }
            if (exponent.getDag() != null) {
                formatter.incSuperscriptCount();
                exponent = BracketTemplate.apply(formatter, exponent, exponent.getDag(), 3, 0);
                formatter.decSuperscriptCount();
            }
            box = new PowerLayoutBox(base, exponent, forceNoItalicAdjustment, (AbstractFormatter)formatter);
        }
        return box;
    }
}

