/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.MatrixTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;
import com.maplesoft.client.prettyprinter.template.VectorTemplate;
import java.util.HashMap;

public class RtableTemplate
implements SpecialFunctionTemplate {
    private static final String ARRAY_TYPE = "Array";
    private static final String DIMENSION_STRING = "-D ";
    private static final int NAME_POS = 0;
    private static final int FUNCTION_POS = 1;
    private static final int FUNCTION_ARG_POS = 1;
    private static final int DATA_TYPE_POS = 1;
    private static final int OBJECT_TYPE_POS = 2;
    private static final int STORAGE_POS = 3;
    private static final int ORDER_POS = 4;
    private static final int DIMENSION_COUNT_POS = 6;
    private static final int UPPER_RANGE_POS = 1;
    private static MatrixTemplate matrixFormatter = new MatrixTemplate();
    private static VectorTemplate vectorFormatter = new VectorTemplate();
    private static HashMap rtableMap = new HashMap();
    private static HashMap idTranslationMap = new HashMap();
    private static HashMap idAliasMap = new HashMap();

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        LayoutBox box = null;
        if (args != null) {
            Dag id = null;
            if (args.length > 1) {
                id = args[0];
            }
            if (id != null) {
                LayoutBox dimensionBox;
                Dag data;
                if (id.getType() == 2) {
                    long value = Long.parseLong(id.getData());
                    this.addRtableID(value, function);
                }
                if ((data = args[1]).getType() == 18) {
                    Dag[] functionArgs;
                    String name = data.getChild(0).getData();
                    Dag functionDag = data.getChild(1);
                    Dag[] dagArray = functionArgs = functionDag instanceof BranchDag ? ((BranchDag)functionDag).getChildrenAsArray() : null;
                    if (functionArgs != null) {
                        if (name.equals("MATRIX")) {
                            box = matrixFormatter.apply(formatter, function, functionArgs);
                        } else if (name.equals("VECTOR")) {
                            box = vectorFormatter.apply(formatter, function, functionArgs);
                        }
                    }
                } else if (args.length > 6 && (dimensionBox = this.createDimensionBox(formatter, args)) != null) {
                    box = new DefaultLayoutBox();
                    box.addChild(dimensionBox);
                    box.addChild(this.createPropertyBox(formatter, args, 1, "Data Type"));
                    box.addChild(this.createPropertyBox(formatter, args, 3, "Storage"));
                    box.addChild(this.createPropertyBox(formatter, args, 4, "Order"));
                    int j = 1;
                    while (j < box.numChildren()) {
                        box.addLayoutAnchor(new LayoutAnchor(j - 1, LayoutVector.SOUTHWEST, j, LayoutVector.NORTHWEST));
                        ++j;
                    }
                    box.applyLayout();
                    box.setBaseline(box.getHeight() / 2.0);
                    SelectionData sd = new SelectionData(2);
                    int[] nArray = new int[4];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    nArray[3] = 3;
                    int[] NStraversal = nArray;
                    sd.setStandardEastWestArray(box);
                    sd.setTraversalNorthSouth(NStraversal);
                    box.setSelectionData(sd);
                    box = BracketTemplate.apply(formatter, box, 95, 96);
                }
            }
        }
        return box;
    }

    private LayoutBox createDimensionBox(LayoutFormatter formatter, Dag[] args) {
        NotationLayoutBox box = null;
        boolean error = false;
        Dag dimensionDag = args[6];
        Dag type = args[2];
        String typeString = type != null ? DagBuilder.lPrint(type) : "";
        int numberOfDimensions = Integer.parseInt(DagBuilder.lPrint(dimensionDag));
        StringBuffer sizeBuffer = new StringBuffer(" ");
        if (numberOfDimensions == 1) {
            Dag range = args[7];
            sizeBuffer.append(DagBuilder.lPrint(range));
        } else {
            int dim = 1;
            while (dim <= numberOfDimensions) {
                Dag range = args[6 + dim];
                if (range.getType() == 35) {
                    Dag upper = range.getChild(1);
                    sizeBuffer.append(DagBuilder.lPrint(upper));
                    if (dim < numberOfDimensions) {
                        sizeBuffer.append(" x ");
                    }
                } else {
                    error = true;
                    break;
                }
                ++dim;
            }
        }
        if (typeString.equals(ARRAY_TYPE)) {
            sizeBuffer.append(" ");
            sizeBuffer.append(numberOfDimensions);
            sizeBuffer.append(DIMENSION_STRING);
        }
        if (!error) {
            sizeBuffer.append(" ");
            sizeBuffer.append(typeString);
            sizeBuffer.append(" ");
            box = NotationLayoutBox.createCustomBox(formatter, sizeBuffer.toString());
            StandardSelectionData sd = new StandardSelectionData(4);
            box.setSelectionData(sd);
        }
        return box;
    }

    private LayoutBox createPropertyBox(LayoutFormatter formatter, Dag[] args, int propertyPosition, String propertyName) {
        StringBuffer buffer = new StringBuffer(" ");
        buffer.append(propertyName);
        buffer.append(": ");
        if (args.length > propertyPosition) {
            buffer.append(DagBuilder.lPrint(args[propertyPosition]));
            buffer.append(" ");
        }
        NotationLayoutBox box = NotationLayoutBox.createCustomBox(formatter, buffer.toString());
        StandardSelectionData sd = new StandardSelectionData(4);
        box.setSelectionData(sd);
        return box;
    }

    public static long getCorretedRTableID(long value) {
        long correctedValue = value;
        Long iValue = new Long(value);
        if (!rtableMap.containsKey(iValue) && idAliasMap.containsKey(iValue)) {
            correctedValue = (Long)idAliasMap.get(iValue);
        }
        return correctedValue;
    }

    private void addRtableID(long value, Dag function) {
        Long iValue = new Long(value);
        if (idTranslationMap.containsKey(iValue)) {
            Long newValue = (Long)idTranslationMap.get(iValue);
            idAliasMap.put(iValue, newValue);
            iValue = newValue;
            if (iValue != null) {
                RtableTemplate.updateRTableID(function, iValue);
                rtableMap.put(iValue, function);
            }
            idTranslationMap.remove(iValue);
        }
        rtableMap.put(iValue, function);
    }

    public static boolean containsRTableID(long value) {
        return rtableMap.containsKey(new Long(value));
    }

    public static void release(long value) {
        Long iValue = new Long(value);
        rtableMap.remove(iValue);
        idAliasMap.remove(iValue);
    }

    public static void addRTableTranslation(long oldValue, long newValue) {
        if (RtableTemplate.containsRTableID(oldValue)) {
            Long iOldValue = new Long(oldValue);
            Long iNewValue = new Long(newValue);
            Dag dag = (Dag)rtableMap.get(iOldValue);
            if (dag != null) {
                RtableTemplate.updateRTableID(dag, newValue);
                rtableMap.remove(iOldValue);
                idAliasMap.put(iOldValue, iNewValue);
                rtableMap.put(iNewValue, dag);
            }
        } else {
            idTranslationMap.put(new Long(oldValue), new Long(newValue));
        }
    }

    public static void updateRTableID(Dag function, long value) {
        Dag expseq = function.getChild(1);
        expseq.setChild(0, Dag.createDag(2, null, Long.toString(value), false));
    }
}

