/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.TTYFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class SumProductTemplate
implements SpecialFunctionTemplate {
    private static final double NOTATION_CENTER = 0.5;
    private static final double NOTATION_TOP = 0.2;
    private static SelectionData notationSD = null;
    private int notationType;

    SumProductTemplate(int type) {
        this.notationType = type;
    }

    public SumLayoutBuilder getSumLayoutBuilder(LayoutFormatter formatter, Dag function, Dag[] args) {
        SumLayoutBuilder box = null;
        Dag eval = null;
        if (args != null && args.length == 2) {
            eval = args[1];
        }
        if (eval != null) {
            Dag var = null;
            Dag from = null;
            Dag to = null;
            if (eval.getType() == 20) {
                var = eval.getChild(0);
                Dag range = eval.getChild(1);
                if (range.getType() == 35) {
                    from = range.getChild(0);
                    to = range.getChild(1);
                    if (from.getType() > 19 || to.getType() > 19) {
                        box = null;
                    }
                    box = new RangeLayoutBuilder(formatter, function, args);
                } else {
                    box = new ExprLayoutBuilder(formatter, function, args);
                }
            } else if (eval.getType() == 8) {
                if (eval.getType() > 19) {
                    box = null;
                }
                box = new NameLayoutBuilder(formatter, function, args);
            }
        } else if (args != null && args.length == 1) {
            box = new NoArgsLayoutBuilder(formatter, function, args);
        }
        return box;
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        LayoutBox box = null;
        SumLayoutBuilder builder = this.getSumLayoutBuilder(formatter, function, args);
        if (builder != null) {
            box = builder.getBox();
        }
        return box;
    }

    private class ExprLayoutBuilder
    extends SumLayoutBuilder {
        private LayoutBox box;
        protected int[] fromPath;

        private ExprLayoutBuilder(LayoutFormatter formatter, Dag function, Dag[] args) {
            super(formatter);
            this.box = null;
            this.fromPath = new int[]{1, 1};
            Dag from = args[1];
            LayoutBox functionBox = this.buildFunctionBox(function, args[0]);
            LayoutBox notationBox = this.buildNotationBox();
            formatter.incSuperscriptCount();
            this.addFromBox(notationBox, function, from);
            formatter.decSuperscriptCount();
            notationBox.addLayoutAnchor(LayoutAnchor.OVER_01);
            this.buildNotationTraversal(notationBox, false);
            this.box = new SumProdLayoutBox(notationBox, functionBox, formatter);
        }

        public void addFromBox(LayoutBox notationBox, Dag function, Dag from) {
            LayoutBox fromBox = DagBuilder.createLayout(this.formatter, from);
            fromBox = AncestorArrayLayoutBox.wrapWithAncestorData(fromBox, function, this.fromPath);
            if (from != null) {
                notationBox.addChild(fromBox);
            }
        }

        @Override
        public LayoutBox getBox() {
            return this.box;
        }
    }

    private class NameLayoutBuilder
    extends SumLayoutBuilder {
        private LayoutBox box;
        protected int[] fromPath;

        private NameLayoutBuilder(LayoutFormatter formatter, Dag function, Dag[] args) {
            super(formatter);
            this.box = null;
            this.fromPath = new int[]{1, 1};
            Dag from = args[1];
            LayoutBox functionBox = this.buildFunctionBox(function, args[0]);
            LayoutBox notationBox = this.buildNotationBox();
            formatter.incSuperscriptCount();
            this.addFromBox(notationBox, function, from);
            formatter.decSuperscriptCount();
            notationBox.addLayoutAnchor(LayoutAnchor.OVER_01);
            this.buildNotationTraversal(notationBox, false);
            this.box = new SumProdLayoutBox(notationBox, functionBox, formatter);
        }

        public void addFromBox(LayoutBox notationBox, Dag function, Dag from) {
            LayoutBox fromBox = DagBuilder.createLayout(this.formatter, from);
            fromBox = AncestorArrayLayoutBox.wrapWithAncestorData(fromBox, function, this.fromPath);
            if (from != null) {
                notationBox.addChild(fromBox);
            }
        }

        @Override
        public LayoutBox getBox() {
            return this.box;
        }
    }

    private class NoArgsLayoutBuilder
    extends SumLayoutBuilder {
        private LayoutBox box;

        private NoArgsLayoutBuilder(LayoutFormatter formatter, Dag function, Dag[] args) {
            super(formatter);
            this.box = null;
            LayoutBox functionBox = this.buildFunctionBox(function, args[0]);
            LayoutBox notationBox = this.buildNotationBox();
            this.buildNotationTraversal(notationBox, false);
            this.box = new SumProdLayoutBox(notationBox, functionBox, formatter);
        }

        @Override
        public LayoutBox getBox() {
            return this.box;
        }
    }

    private class RangeLayoutBuilder
    extends SumLayoutBuilder {
        private LayoutBox box;
        protected int[] varPath;
        protected int[] fromPath;
        protected int[] toPath;

        private RangeLayoutBuilder(LayoutFormatter formatter, Dag function, Dag[] args) {
            super(formatter);
            this.box = null;
            int[] nArray = new int[3];
            nArray[0] = 1;
            nArray[1] = 1;
            this.varPath = nArray;
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            this.fromPath = nArray2;
            this.toPath = new int[]{1, 1, 1, 1};
            Dag eval = args[1];
            Dag var = eval.getChild(0);
            Dag range = eval.getChild(1);
            Dag from = range.getChild(0);
            Dag to = range.getChild(1);
            LayoutBox functionBox = this.buildFunctionBox(function, args[0]);
            LayoutBox notationBox = this.buildNotationBox();
            formatter.incSuperscriptCount();
            this.addFromBox(notationBox, function, var, from);
            formatter.decSuperscriptCount();
            notationBox.addLayoutAnchor(LayoutAnchor.OVER_01);
            this.addToBox(notationBox, function, to);
            this.buildNotationTraversal(notationBox, to != null);
            this.box = new SumProdLayoutBox(notationBox, functionBox, formatter);
        }

        public void addToBox(LayoutBox notationBox, Dag function, Dag to) {
            if (to != null) {
                this.formatter.incSuperscriptCount();
                LayoutBox toBox = DagBuilder.createLayout(this.formatter, to);
                toBox = AncestorArrayLayoutBox.wrapWithAncestorData(toBox, function, this.toPath);
                notationBox.addChild(toBox);
                if (this.formatter instanceof TTYFormatter) {
                    notationBox.addLayoutAnchor(LayoutAnchor.UNDER_02);
                } else {
                    notationBox.addLayoutAnchor(new LayoutAnchor(0, new LayoutVector(0.5, 0.2), 2, LayoutVector.SOUTH));
                }
                this.formatter.decSuperscriptCount();
            }
        }

        public void addFromBox(LayoutBox notationBox, Dag function, Dag var, Dag from) {
            LayoutBox varBox = DagBuilder.createLayout(this.formatter, var);
            varBox = AncestorArrayLayoutBox.wrapWithAncestorData(varBox, function, this.varPath);
            LayoutBox fromB = DagBuilder.createLayout(this.formatter, from);
            fromB = AncestorArrayLayoutBox.wrapWithAncestorData(fromB, function, this.fromPath);
            if (from != null) {
                NotationLayoutBox equalBox = NotationLayoutBox.createNotationBox(this.formatter, 5);
                StandardSelectionData esd = new StandardSelectionData(16);
                esd.setContextHelpAvailable(false);
                equalBox.setSelectionData(esd);
                SumProdFromLayoutBox fromBox = new SumProdFromLayoutBox(varBox, equalBox, fromB);
                fromBox.setSelectionData(esd);
                notationBox.addChild(fromBox);
            } else {
                notationBox.addChild(varBox);
            }
        }

        @Override
        public LayoutBox getBox() {
            return this.box;
        }
    }

    private abstract class SumLayoutBuilder {
        protected LayoutFormatter formatter = null;
        protected int[] funcPath;

        protected SumLayoutBuilder(LayoutFormatter formatter) {
            int[] nArray = new int[2];
            nArray[0] = 1;
            this.funcPath = nArray;
            this.formatter = formatter;
        }

        public LayoutBox buildFunctionBox(Dag function, Dag argOne) {
            LayoutBox functionBox = DagBuilder.createLayout(this.formatter, argOne);
            functionBox = AncestorArrayLayoutBox.wrapWithAncestorData(functionBox, function, this.funcPath);
            functionBox = BracketTemplate.apply(this.formatter, functionBox, argOne, 4);
            return functionBox;
        }

        public LayoutBox buildNotationBox() {
            NotationLayoutBox notationSign = NotationLayoutBox.createNotationBox(this.formatter, SumProductTemplate.this.notationType);
            if (notationSD == null) {
                notationSD = new StandardSelectionData(4);
                notationSD.setContextHelpAvailable(false);
            }
            notationSign.setSelectionData(notationSD);
            this.formatter.resizeNotationBox(notationSign);
            DefaultLayoutBox notationBox = new DefaultLayoutBox();
            notationSign.setRightSideBearing(3.0 * this.formatter.getBearingMultiplier());
            notationBox.addChild(notationSign);
            return notationBox;
        }

        public void buildNotationTraversal(LayoutBox notationBox, boolean toExists) {
            int[] NSNotationTraversal = null;
            NSNotationTraversal = toExists ? new int[]{2, 0, 1} : new int[]{0, 1};
            SelectionData notationSD = new SelectionData(1);
            notationSD.setTraversalNorthSouth(NSNotationTraversal);
            notationSD.setStandardEastWestArray(notationBox);
            notationBox.setSelectionData(notationSD);
        }

        public abstract LayoutBox getBox();
    }

    static class SumProdFromLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(13);

        SumProdFromLayoutBox(LayoutBox var, LayoutBox notation, LayoutBox term) {
            super(3);
            this.addChild(var);
            this.addChild(notation);
            this.addChild(term);
        }

        SumProdFromLayoutBox() {
        }

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }
    }

    static class SumProdLayoutBox
    extends InlineLayoutBox {
        private static final double BASELINE_ADJUST = 0.65;
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(14);
        private double functionSpace;

        SumProdLayoutBox(LayoutBox notation, LayoutBox func, LayoutFormatter formatter) {
            super(2);
            this.addChild(notation);
            this.addChild(func);
            if (!(formatter instanceof TTYFormatter)) {
                this.functionSpace = 3.0;
            }
        }

        SumProdLayoutBox() {
        }

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }

        @Override
        public void applyLayout() {
            if (!this.isLayoutValid()) {
                this.setOrigin(0.0, 0.0);
                LayoutBox notation = this.getChild(0);
                LayoutBox function = this.getChild(1);
                if (!notation.isLayoutValid()) {
                    notation.applyLayout();
                }
                if (!function.isLayoutValid()) {
                    function.applyLayout();
                }
                LayoutBox notationSign = notation.getChild(0);
                double notationHeight = notationSign.getHeight();
                double notationOffset = notationSign.getYorig();
                double functionBaseline = function.getBaseline();
                double functionOffset = 0.65 * notationHeight + notationOffset - functionBaseline;
                function.setOrigin(notation.getWidth() + this.functionSpace, functionOffset);
                notation.setBaseline(functionOffset + functionBaseline);
                this.computeSize();
            }
        }
    }
}

