/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.NameDagFactory;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.DivideTemplate;
import com.maplesoft.client.prettyprinter.template.PowerTemplate;
import com.maplesoft.client.prettyprinter.template.RootTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;
import com.maplesoft.client.prettyprinter.template.SubScriptTemplate;
import java.io.IOException;
import java.util.HashMap;

public class TypesettingTemplate
implements SpecialFunctionTemplate {
    protected static HashMap templateMap = new HashMap();

    static {
        templateMap.put("Typesetting:-mfrac", new MFracTemplate());
        templateMap.put("Typesetting:-mi", new MITemplate());
        templateMap.put("Typesetting:-mmultiscripts", null);
        templateMap.put("Typesetting:-mscripts", null);
        templateMap.put("Typesetting:-mn", new MNTemplate());
        templateMap.put("Typesetting:-mo", new MOTemplate());
        templateMap.put("Typesetting:-mover", null);
        templateMap.put("Typesetting:-mambiguous", null);
        templateMap.put("Typesetting:-maction", null);
        templateMap.put("Typesetting:-mroot", null);
        templateMap.put("Typesetting:-mrow", new MRowTemplate());
        templateMap.put("Typesetting:-mspace", new MSpaceTemplate());
        templateMap.put("Typesetting:-msqrt", new MSqrtTemplate());
        templateMap.put("Typesetting:-ms", new MSTemplate());
        templateMap.put("Typesetting:-mstyle", null);
        templateMap.put("Typesetting:-msub", new MSubTemplate());
        templateMap.put("Typesetting:-msubsup", null);
        templateMap.put("Typesetting:-msup", new MSupTemplate());
        templateMap.put("Typesetting:-mtext", new MTextTemplate());
        templateMap.put("Typesetting:-merror", null);
        templateMap.put("Typesetting:-munder", null);
        templateMap.put("Typesetting:-mphantom", null);
        templateMap.put("Typesetting:-munderover", null);
        templateMap.put("Typesetting:-mprescripts", null);
        templateMap.put("Typesetting:-none", null);
        templateMap.put("Typesetting:-mfenced", new MFencedTemplate());
        templateMap.put("Typesetting:-mtable", null);
        templateMap.put("Typesetting:-mtr", null);
        templateMap.put("Typesetting:-mtd", null);
        templateMap.put("Typesetting:-mprintslash", new MPrintslashTemplate());
        templateMap.put("Typesetting:-mparsed", null);
        templateMap.put("Typesetting:-mverbatim", new MVerbatimTemplate());
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        LayoutBox resultBox = null;
        String name = function.getChild(0).getData();
        SpecialFunctionTemplate inTemplate = (SpecialFunctionTemplate)templateMap.get(name);
        if (inTemplate != null) {
            resultBox = inTemplate.apply(formatter, function, args);
        }
        return resultBox;
    }

    private static class MFencedTemplate
    implements SpecialFunctionTemplate {
        private MFencedTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            InlineLayoutBox resultBox = null;
            LayoutBox finalBox = null;
            resultBox = new InlineLayoutBox();
            String leftBracket = "(";
            String rightBracket = ")";
            int i = 0;
            while (i < args.length) {
                if (DagUtil.isFunction(args[i])) {
                    LayoutBox box = DagBuilder.createLayout(formatter, args[i]);
                    resultBox.addChild(box);
                } else if (DagUtil.isEquation(args[i])) {
                    if (args[i].getChild(0).getData().equals("open")) {
                        leftBracket = args[i].getChild(1).getData();
                    } else if (args[i].getChild(0).getData().equals("close")) {
                        rightBracket = args[i].getChild(1).getData();
                    }
                }
                ++i;
            }
            int leftID = this.getIDForBracketChar(leftBracket, true);
            int rightID = this.getIDForBracketChar(rightBracket, false);
            finalBox = BracketTemplate.apply(formatter, (LayoutBox)resultBox, leftID, rightID);
            return finalBox;
        }

        private int getIDForBracketChar(String character, boolean open) {
            int bracketID = 91;
            if (character.equals(")")) {
                bracketID = 92;
            } else if (character.equals("[")) {
                bracketID = 95;
            } else if (character.equals("]")) {
                bracketID = 96;
            } else if (character.equals("{")) {
                bracketID = 93;
            } else if (character.equals("}")) {
                bracketID = 94;
            } else if (character.length() == 0 && !open) {
                bracketID = 92;
            }
            return bracketID;
        }
    }

    private static class MFracTemplate
    implements SpecialFunctionTemplate {
        private MFracTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            LayoutBox resultBox = null;
            LayoutBox num = DagBuilder.createLayout(formatter, args[0]);
            LayoutBox denom = DagBuilder.createLayout(formatter, args[1]);
            num.applyLayout();
            denom.applyLayout();
            int mode = 0;
            int i = 0;
            while (i < args.length) {
                String modeVal;
                Dag child = args[i];
                if (DagUtil.isEquation(child) && DagUtil.isNameNamed(child.getChild(0), "bevelled") && !(modeVal = child.getChild(1).getData()).equals("false")) {
                    mode = 1;
                }
                ++i;
            }
            resultBox = DivideTemplate.apply(formatter, num, denom, mode);
            resultBox.applyLayout();
            return resultBox;
        }
    }

    private static class MITemplate
    implements SpecialFunctionTemplate {
        private static NameDagFactory NAME_FAC = new NameDagFactory();

        private MITemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            LayoutBox nameBox = null;
            Dag name = args[0];
            nameBox = NAME_FAC.createLayout(formatter, name);
            nameBox.applyLayout();
            return nameBox;
        }
    }

    private static class MNTemplate
    implements SpecialFunctionTemplate {
        private MNTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            NotationLayoutBox numberBox = null;
            Dag data = args[0];
            String text = data.getData();
            numberBox = NotationLayoutBox.createCustomBox(formatter, text, 4);
            return numberBox;
        }
    }

    private static class MOTemplate
    implements SpecialFunctionTemplate {
        private MOTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            NotationLayoutBox opBox = null;
            Dag data = args[0];
            String text = data.getData();
            text = this.substituteEntities(text);
            opBox = NotationLayoutBox.createCustomBox(formatter, text, 5);
            return opBox;
        }

        private String substituteEntities(String input) {
            String output = input;
            if (output.equals("&InvisibleTimes;")) {
                output = " ";
            } else if (output.equals("&plus;")) {
                output = " + ";
            } else if (output.equals("&CenterDot;")) {
                output = " * ";
            } else if (output.equals("&minus;")) {
                output = " - ";
            } else if (output.startsWith("&") && output.endsWith(";")) {
                output = output.substring(1);
                output = output.substring(0, output.length() - 1);
            }
            return output;
        }
    }

    public static class MPrintslashTemplate
    implements SpecialFunctionTemplate {
        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            Dag dag = DagUtil.getDisplayDataFromPrintslash(function);
            LayoutBox box = DagBuilder.createLayout(formatter, dag);
            return box;
        }
    }

    private static class MRowTemplate
    implements SpecialFunctionTemplate {
        private MRowTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            InlineLayoutBox resultBox = null;
            resultBox = new InlineLayoutBox();
            int i = 0;
            while (i < args.length) {
                if (DagUtil.isFunction(args[i]) && (!DagUtil.isFunctionNamed(args[i], "Typesetting:-mi") || args[i].getChild(0).getData().length() != 0)) {
                    LayoutBox box = DagBuilder.createLayout(formatter, args[i]);
                    resultBox.addChild(box);
                }
                ++i;
            }
            resultBox.applyLayout();
            return resultBox;
        }
    }

    private static class MSTemplate
    extends MTextTemplate {
        private MSTemplate() {
            super(null, null);
        }

        @Override
        protected String getStringWrapperChar() {
            return "\"";
        }
    }

    private static class MSpaceTemplate
    implements SpecialFunctionTemplate {
        private MSpaceTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            NotationLayoutBox spcBox = null;
            spcBox = NotationLayoutBox.createCustomBox(formatter, " ", 5);
            return spcBox;
        }
    }

    private static class MSqrtTemplate
    implements SpecialFunctionTemplate {
        private static RootTemplate ROOT_FAC = new RootTemplate();

        private MSqrtTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            LayoutBox rootBox = null;
            rootBox = ROOT_FAC.apply(formatter, function, args);
            rootBox.applyLayout();
            return rootBox;
        }
    }

    private static class MSubTemplate
    implements SpecialFunctionTemplate {
        private MSubTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            LayoutBox resultBox = null;
            Dag tableRef = DagUtil.createTableRefDag(args[0], args[1]);
            resultBox = SubScriptTemplate.apply(formatter, tableRef);
            return resultBox;
        }
    }

    private static class MSupTemplate
    implements SpecialFunctionTemplate {
        private MSupTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            LayoutBox powerResult = null;
            LayoutBox baseBox = DagBuilder.createLayout(formatter, args[0]);
            LayoutBox powBox = DagBuilder.createLayout(formatter, args[1]);
            powerResult = PowerTemplate.apply(formatter, baseBox, powBox);
            return powerResult;
        }
    }

    private static class MTextTemplate
    implements SpecialFunctionTemplate {
        private MTextTemplate() {
        }

        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            NotationLayoutBox textBox = null;
            StringBuffer buf = new StringBuffer(this.getStringWrapperChar());
            buf.append(args[0].getData());
            buf.append(this.getStringWrapperChar());
            textBox = NotationLayoutBox.createCustomBox(formatter, buf.toString(), 4);
            return textBox;
        }

        protected String getStringWrapperChar() {
            return "";
        }

        /* synthetic */ MTextTemplate(MTextTemplate mTextTemplate, MTextTemplate mTextTemplate2) {
            this();
        }
    }

    public static class MVerbatimTemplate
    implements SpecialFunctionTemplate {
        @Override
        public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
            LayoutBox box = null;
            String dotm = args[0].getData();
            try {
                Dag dag = DagBuilder.createDag(dotm);
                box = DagBuilder.createLayout(formatter, dag);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return box;
        }
    }
}

