/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;
import java.util.LinkedList;

public class VectorShorthandTemplate
implements SpecialFunctionTemplate {
    private int separator;

    public VectorShorthandTemplate(int separator) {
        this.separator = separator;
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        VectorShorthandLayoutBox sequence = new VectorShorthandLayoutBox();
        int i = 0;
        while (i < args.length) {
            Dag child = args[i];
            int[] pathToHere = this.getAncestorPath(function, child);
            if (child.getType() == 29) {
                int length = child.getLength();
                int j = 0;
                while (j < length) {
                    this.buildLayout(formatter, sequence, this.separator, function, child.getChild(j), i);
                    ++j;
                }
            } else {
                this.buildLayout(formatter, sequence, this.separator, function, child, i);
            }
            ++i;
        }
        return BracketTemplate.apply(formatter, (LayoutBox)sequence, 26, 27);
    }

    private void buildLayout(LayoutFormatter formatter, LayoutBox sequence, int separator, Dag function, Dag dag, int buildIndex) {
        NotationLayoutBox trueSeparator = NotationLayoutBox.createNotationBox(formatter, separator);
        LayoutBox newChild = DagBuilder.createLayout(formatter, dag);
        newChild = BracketTemplate.apply(formatter, newChild, dag, 20);
        int[] ancestorArray = this.getAncestorPath(function, dag);
        newChild = AncestorArrayLayoutBox.wrapWithAncestorData(newChild, function, ancestorArray);
        if (buildIndex > 0) {
            sequence.addChild(trueSeparator);
        }
        sequence.addChild(newChild);
    }

    private int[] getAncestorPath(Dag parent, Dag child) {
        LinkedList dagPath = this.generateDagPath(parent, child, null);
        int[] ancestorPath = this.generateAncestorPath(dagPath);
        return ancestorPath;
    }

    private int[] generateAncestorPath(LinkedList dagPath) {
        int[] path = new int[dagPath.size() - 1];
        Dag parent = (Dag)dagPath.removeLast();
        int count = 0;
        while (dagPath.size() > 0) {
            Dag child = (Dag)dagPath.removeLast();
            path[count++] = this.getIndex(parent, child);
            parent = child;
        }
        return path;
    }

    private int getIndex(Dag parent, Dag child) {
        int index = -1;
        int i = 0;
        while (i < parent.getLength()) {
            if (child == parent.getChild(i)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private LinkedList generateDagPath(Dag parent, Dag child, LinkedList list) {
        LinkedList linkedList = list = list == null ? new LinkedList() : list;
        if (list.size() > 0 && list.getFirst() == child) {
            return list;
        }
        list.addFirst(parent);
        int i = 0;
        while (i < parent.getLength()) {
            Dag tchild = parent.getChild(i);
            if (tchild == child) {
                list.addFirst(tchild);
                return list;
            }
            if (tchild.getLength() > 0 && (list = this.generateDagPath(tchild, child, list)).getFirst() != child) {
                while (list.getFirst() != tchild) {
                    list.removeFirst();
                }
                list.removeFirst();
            }
            ++i;
        }
        return list;
    }

    static class VectorShorthandLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(2);

        VectorShorthandLayoutBox(String s, int i) {
            super(s, i);
        }

        VectorShorthandLayoutBox() {
        }

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

