/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WmiComponentUtil {
    private static HashMap imageMap = new HashMap();
    private static HashMap imageIconMap = new HashMap();
    private static final String PLATFORM_FOLDER = RuntimePlatform.isMac() ? "/mac" : "/default";

    public static Image getImage(String name) {
        Image image = (Image)imageMap.get(name);
        if (image == null && (image = ResourceLoader.getResourceAsImage(name)) != null) {
            imageMap.put(name, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getImageIcon(String name) {
        ImageIcon icon = null;
        HashMap hashMap = imageIconMap;
        synchronized (hashMap) {
            Image iconImage;
            icon = (ImageIcon)imageIconMap.get(name);
            if (icon == null && (iconImage = WmiComponentUtil.getImage(name)) != null) {
                icon = new ImageIcon(iconImage);
                imageIconMap.put(name, icon);
            }
        }
        return icon;
    }

    public static String getMnemonic(String input) {
        int tilde;
        String mnemonic = null;
        if (!RuntimePlatform.isMac() && input != null && (tilde = input.indexOf(126)) != -1 && tilde < input.length() - 1) {
            mnemonic = String.valueOf(input.charAt(tilde + 1));
        }
        return mnemonic;
    }

    public static String resourceFolderName(int size) {
        String folder;
        switch (size) {
            case 1: {
                folder = "/mini";
                break;
            }
            case 2: {
                folder = "/small";
                break;
            }
            case 3: {
                folder = "/large";
                break;
            }
            default: {
                folder = "";
            }
        }
        return folder;
    }

    public static String platformFolderName() {
        return PLATFORM_FOLDER;
    }

    public static Rectangle centerTextInButton(AbstractButton b) {
        Rectangle textRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(b, b.getFontMetrics(b.getFont()), b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), new Rectangle(0, 0, b.getWidth(), b.getHeight()), new Rectangle(), textRect, b.getText() == null ? 0 : b.getIconTextGap());
        return textRect;
    }

    private WmiComponentUtil() {
    }
}

