/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiDropDownButton;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WmiCompositeDropDownButton
extends WmiDropDownButton {
    private JMenu menu = null;
    private AbstractButton[] buttons = null;
    private WmiCommand[] commands = null;
    private ButtonGroup group = null;
    private int selectedIndex = 0;

    public static void updateContext(WmiCompositeDropDownButton button, String[] commands, WmiView view) {
        int i = 0;
        while (i < commands.length) {
            AbstractButton b = button.getButtonAtIndex(i);
            WmiCommandProxy command = WmiCommand.getCommandProxy(commands[i]);
            if (command != null) {
                WmiMathDocumentView docView = view != null ? view.getDocumentView() : null;
                boolean isEnabled = ((WmiCommand)command).isEnabled(docView);
                boolean isSelected = ((WmiCommand)command).isSelected(docView);
                command.setEnabled(isEnabled);
                b.setEnabled(isEnabled);
                if (isSelected) {
                    button.setSelectedIndex(i);
                }
            }
            ++i;
        }
    }

    public WmiCompositeDropDownButton(AbstractButton[] buttons) {
        this(buttons, 0);
    }

    public WmiCompositeDropDownButton(AbstractButton[] buttons, int selected) {
        this.initializeButtons(buttons, selected);
    }

    public WmiCompositeDropDownButton(String[] commands) {
        this(commands, 0);
    }

    public WmiCompositeDropDownButton(String[] commandNames, int selected) {
        this(commandNames, selected, 1);
    }

    public WmiCompositeDropDownButton(String[] commandNames, int selected, int buttonSize) {
        this.commands = WmiCompositeDropDownButton.getCommands(commandNames);
        AbstractButton[] buttons = WmiCompositeDropDownButton.getButtons(this.commands, buttonSize);
        this.initializeButtons(buttons, selected);
    }

    private void initializeButtons(AbstractButton[] buttons, int selected) {
        this.buttons = buttons;
        this.menu = new JMenu();
        this.group = new ButtonGroup();
        int i = 0;
        while (i < buttons.length) {
            JMenuItem item = this.createMenuItem(buttons[i], i);
            this.menu.add(item);
            ++i;
        }
        this.popupMenu = this.menu.getPopupMenu();
        this.popupMenu.addPopupMenuListener(new DropDownMenuPopupListener());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!WmiCompositeDropDownButton.this.popupMenu.isVisible()) {
                    WmiCompositeDropDownButton.this.doClickAtIndex(WmiCompositeDropDownButton.this.getSelectedIndex());
                }
            }
        });
        this.setSelectedIndex(selected);
    }

    public void addMenuListener(MenuListener l) {
        if (this.menu != null) {
            this.menu.addMenuListener(l);
        }
    }

    public void removeMenuListener(MenuListener l) {
        if (this.menu != null) {
            this.menu.removeMenuListener(l);
        }
    }

    public void setSelectedIndex(int i) {
        this.selectedIndex = i;
        this.setIconIndex(i);
        this.setToolTipText(this.buttons[i].getToolTipText());
        JMenuItem item = this.menu.getItem(i);
        item.setSelected(true);
    }

    public void setSelectedButton(AbstractButton b) {
        if (this.buttons != null) {
            int i = 0;
            while (i < this.buttons.length) {
                if (this.buttons[i] == b) {
                    this.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void showButtonAtIndex(int index, boolean show) {
        this.menu.getItem(index).setVisible(show);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public AbstractButton getButtonAtIndex(int i) {
        return this.buttons != null ? this.buttons[i] : null;
    }

    public AbstractButton getSelectedButton() {
        return this.buttons != null ? this.buttons[this.selectedIndex] : null;
    }

    public void doClickAtIndex(int index) {
        if (this.buttons != null) {
            final int fi = index;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WmiCompositeDropDownButton.this.buttons[fi].doClick();
                }
            });
            if (index != this.getSelectedIndex()) {
                this.setSelectedIndex(index);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.group = null;
        if (this.menu != null) {
            this.menu.removeAll();
        }
        this.menu = null;
        if (this.buttons != null) {
            Arrays.fill(this.buttons, null);
        }
        this.buttons = null;
    }

    private void setIconIndex(int i) {
        if (this.buttons != null) {
            AbstractButton b = this.buttons[i];
            this.setIcon(b.getIcon());
            this.setDisabledIcon(b.getDisabledIcon());
            this.setPressedIcon(b.getPressedIcon());
        }
    }

    private JMenuItem createMenuItem(AbstractButton b, int i) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        item.setIcon(b.getIcon());
        item.setText(b.getText());
        item.addActionListener(new DropDownMenuSelectionListener(i));
        this.group.add(item);
        return item;
    }

    private static WmiCommand[] getCommands(String[] names) {
        WmiCommand[] commands = new WmiCommand[names.length];
        int i = 0;
        while (i < names.length) {
            commands[i] = WmiCommand.getCommandProxy(names[i]);
            ++i;
        }
        return commands;
    }

    private static AbstractButton[] getButtons(WmiCommand[] commands, int size) {
        AbstractButton[] buttons = new AbstractButton[commands.length];
        int i = 0;
        while (i < commands.length) {
            buttons[i] = commands[i].createButton(size);
            ++i;
        }
        return buttons;
    }

    private class DropDownMenuPopupListener
    implements PopupMenuListener {
        private DropDownMenuPopupListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            WmiCompositeDropDownButton.this.repaint();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            WmiCompositeDropDownButton.this.repaint();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            if (WmiCompositeDropDownButton.this.menu != null && WmiCompositeDropDownButton.this.commands != null) {
                int i = 0;
                while (i < WmiCompositeDropDownButton.this.menu.getItemCount()) {
                    if (WmiCompositeDropDownButton.this.commands[i] != null) {
                        WmiCompositeDropDownButton.this.menu.getItem(i).setEnabled(WmiCompositeDropDownButton.this.commands[i].isEnabled());
                    }
                    ++i;
                }
            }
        }
    }

    private class DropDownMenuSelectionListener
    implements ActionListener {
        private int index;

        private DropDownMenuSelectionListener(int i) {
            this.index = i;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WmiCompositeDropDownButton.this.doClickAtIndex(this.index);
        }
    }
}

