/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiContextualMenu;
import com.maplesoft.mathdoc.components.WmiStatusBarContextListener;
import com.maplesoft.mathdoc.components.WmiUpdateScheduler;
import com.maplesoft.mathdoc.controller.Wmi2DEntryMode;
import com.maplesoft.mathdoc.controller.WmiMenu;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public abstract class WmiContextManager {
    protected static final String CUT_COMMAND_NAME = "MathDoc.Edit.Cut";
    protected static final String COPY_COMMAND_NAME = "MathDoc.Edit.Copy";
    protected static final String COPY_FULL_PRECISION_COMMAND_NAME = "MathDoc.Edit.CopyFullPrecision";
    protected static final String PASTE_COMMAND_NAME = "MathDoc.Edit.Paste";
    protected static final String FORMAT_COMMAND_NAME = "Format.Numeric";
    public static final Wmi2DEntryMode EM_STANDARD = new Wmi2DEntryMode("2D_MODE");
    public static final Wmi2DEntryMode EM_GREEK = new Wmi2DEntryMode("GREEK_MODE");
    protected WmiMathDocumentView contextDocument = null;
    protected WmiView contextView = null;
    protected WmiMenu activeContextualMenu = null;
    private WmiUpdateScheduler scheduler = null;
    private Wmi2DEntryMode entryMode = EM_STANDARD;
    protected WmiStatusBarContextListener statusListener = null;

    protected WmiContextManager() {
    }

    protected void popupMenu(WmiMenu menu, WmiView source, MouseEvent e) {
        JPopupMenu popup = this.activeContextualMenu.getPopupMenu();
        menu.setSelected(true);
        int x = e.getX();
        int y = e.getY();
        if (source instanceof WmiPositionedView) {
            WmiPositionedView pView = (WmiPositionedView)source;
            Point offset = WmiViewUtil.getAbsoluteOffset(pView);
            x += offset.x;
            y += offset.y;
        }
        popup.show(source.getDocumentView(), x, y);
    }

    public void positionChangeNotification(WmiMathDocumentView srcWks) {
        if (srcWks == this.contextDocument) {
            this.setContextForDocument(this.contextDocument);
        }
    }

    public void popupRequestNotification(WmiView source, MouseEvent e) {
        this.setContextForDocument(source);
        this.buildMenu();
        if (this.activeContextualMenu != null) {
            e.consume();
            this.popupMenu(this.activeContextualMenu, source, e);
        }
    }

    public void notifyWorksheetChange(WmiMathDocumentView newView) {
        if (newView != null) {
            this.contextDocument = newView;
            this.setContextForDocument(this.contextDocument);
        }
    }

    public void updateEntryMode(Wmi2DEntryMode mode) {
        this.entryMode = mode;
        if (this.statusListener != null) {
            this.statusListener.notifyContextStatusChange();
        }
    }

    public Wmi2DEntryMode getEntryMode() {
        return this.entryMode;
    }

    public void setStatusBarContextListener(WmiStatusBarContextListener listener) {
        this.statusListener = listener;
    }

    public void setContextForDocument(WmiView view) {
        boolean changeContext = false;
        if (view != null) {
            WmiMathDocumentView docView;
            WmiPositionMarker marker;
            if ((view instanceof WmiMathDocumentView || view instanceof WmiInlineView) && (marker = (docView = view.getDocumentView()).getPositionMarker()) != null) {
                WmiPositionedView markerView = marker.getView();
                if (markerView != null) {
                    view = markerView;
                }
                int offset = marker.getOffset();
                WmiModel model = view.getModel();
                if (model instanceof WmiMathModel) {
                    while (view instanceof WmiCompositeView) {
                        WmiCompositeView comp = (WmiCompositeView)view;
                        int size = comp.getChildCount();
                        if (size <= 0) break;
                        WmiView wmiView = view = offset == 0 ? comp.getChild(0) : comp.getChild(size - 1);
                    }
                }
            }
            if (view.getDocumentView() != null && view.getDocumentView().getSelection() != null) {
                changeContext = true;
            }
            if (view != this.contextView) {
                this.contextView = view;
                changeContext = true;
            }
        }
        if (changeContext) {
            if (this.scheduler == null) {
                this.scheduler = new WmiUpdateScheduler(new Runnable(){

                    @Override
                    public void run() {
                        WmiContextManager.this.updateContext();
                    }
                });
            } else {
                this.scheduler.ping();
            }
        }
    }

    protected boolean updateContext() {
        return true;
    }

    protected void resetExistingMenu() {
        if (this.activeContextualMenu != null) {
            this.activeContextualMenu.setSelected(false);
            this.activeContextualMenu.getPopupMenu().setInvoker(this.activeContextualMenu);
            this.removeCommonMenuElements(this.activeContextualMenu);
        }
    }

    public boolean buildMenu() {
        return this.buildMenu(true);
    }

    protected boolean buildMenu(boolean resetMenu) {
        WmiContextualMenu rootMenu;
        boolean success;
        block19: {
            success = false;
            if (resetMenu) {
                this.resetExistingMenu();
            }
            WmiModel contextModel = this.contextView.getModel();
            WmiContextualMenu currentMenu = this.getMenuForModel(contextModel);
            rootMenu = (WmiContextualMenu)(resetMenu ? null : this.activeContextualMenu);
            if (currentMenu != null) {
                if (resetMenu) {
                    rootMenu = currentMenu.copyMenu();
                } else {
                    rootMenu.add(currentMenu.copyMenu());
                }
            }
            HashSet<WmiModelTag> visitedTags = new HashSet<WmiModelTag>();
            boolean lock = !WmiModelLock.ownsWriteLock(contextModel);
            try {
                try {
                    if (lock) {
                        WmiModelLock.readLock(contextModel, true);
                    }
                    WmiCompositeModel currentModel = contextModel.getParent();
                    while (currentModel != null && currentModel != currentModel.getDocument()) {
                        if (!visitedTags.contains(currentModel.getTag())) {
                            visitedTags.add(currentModel.getTag());
                            currentMenu = this.getMenuForModel(currentModel);
                            if (currentMenu != null) {
                                if (rootMenu != null) {
                                    currentMenu.setSelected(false);
                                    currentMenu.getPopupMenu().setInvoker(currentMenu);
                                    rootMenu.add(currentMenu.copyMenu());
                                } else {
                                    rootMenu = currentMenu.copyMenu();
                                }
                            }
                        }
                        currentModel = currentModel.getParent();
                    }
                    success = true;
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    if (lock) {
                        WmiModelLock.readUnlock(contextModel);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (lock) {
                    WmiModelLock.readUnlock(contextModel);
                }
                throw throwable;
            }
            if (lock) {
                WmiModelLock.readUnlock(contextModel);
            }
        }
        if (rootMenu != null) {
            this.removeDisabledMenuItems(rootMenu);
            this.addCommonMenuElements(rootMenu, false);
        }
        this.activeContextualMenu = rootMenu;
        return success;
    }

    private void removeDisabledMenuItems(WmiMenu menu) {
        Component last;
        menu.setSelected(true);
        int distanceBetweenSeparators = 0;
        Component[] comps = menu.getMenuComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof WmiMenu) {
                WmiMenu subMenu = (WmiMenu)comps[i];
                this.removeDisabledMenuItems(subMenu);
                if (subMenu.getMenuComponentCount() == 0) {
                    menu.remove(subMenu);
                } else {
                    ++distanceBetweenSeparators;
                }
            } else if (!this.isValidMenuItem(comps[i])) {
                menu.remove(comps[i]);
            } else if (comps[i] instanceof JPopupMenu.Separator) {
                if (distanceBetweenSeparators == 0) {
                    menu.remove(comps[i]);
                } else {
                    distanceBetweenSeparators = 0;
                }
            } else {
                ++distanceBetweenSeparators;
            }
            ++i;
        }
        if (menu.getMenuComponentCount() > 0 && (last = menu.getMenuComponent(menu.getMenuComponentCount() - 1)) instanceof JPopupMenu.Separator) {
            menu.remove(last);
        }
        menu.setSelected(false);
    }

    protected boolean isValidMenuItem(Component comp) {
        return comp.isEnabled();
    }

    protected void addCommonMenuElements(JMenu menu, boolean output) {
    }

    protected void removeCommonMenuElements(JMenu menu) {
        if (menu.getMenuComponentCount() >= 4) {
            menu.remove(0);
            menu.remove(0);
            menu.remove(0);
            menu.remove(0);
        }
    }

    protected abstract WmiContextualMenu getMenuForModel(WmiModel var1);

    public WmiMenu getActiveContextualMenu() {
        return this.activeContextualMenu;
    }
}

