/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class WmiDisclosureTriangle
extends JToggleButton {
    public static final int WHITE = 1;
    public static final int BLACK = 2;
    public static final Dimension DEFAULT_SIZE = new Dimension(12, 12);
    private static final String RESOURCES = "com/maplesoft/mathdoc/components/resources/disclosuretriangle/";
    private static final String TRIANGLE_BLACK_CLOSED_ICON = "com/maplesoft/mathdoc/components/resources/disclosuretriangle/disclosure_triangle_black_closed.gif";
    private static final String TRIANGLE_BLACK_OPEN_ICON = "com/maplesoft/mathdoc/components/resources/disclosuretriangle/disclosure_triangle_black_open.gif";
    private static final String TRIANGLE_BLACK_ARMED_ICON = "com/maplesoft/mathdoc/components/resources/disclosuretriangle/disclosure_triangle_black_armed.gif";
    private static final String TRIANGLE_WHITE_CLOSED_ICON = "com/maplesoft/mathdoc/components/resources/disclosuretriangle/disclosure_triangle_white_closed.gif";
    private static final String TRIANGLE_WHITE_OPEN_ICON = "com/maplesoft/mathdoc/components/resources/disclosuretriangle/disclosure_triangle_white_open.gif";
    private static final String TRIANGLE_WHITE_ARMED_ICON = "com/maplesoft/mathdoc/components/resources/disclosuretriangle/disclosure_triangle_white_armed.gif";
    public static Icon TRIANGLE_BLACK_CLOSED = null;
    public static Icon TRIANGLE_BLACK_OPEN = null;
    public static Icon TRIANGLE_BLACK_ARMED = null;
    public static Icon TRIANGLE_WHITE_CLOSED = null;
    public static Icon TRIANGLE_WHITE_OPEN = null;
    public static Icon TRIANGLE_WHITE_ARMED = null;
    private int color = -1;

    static {
        WmiDisclosureTriangle.loadTriangleIcons();
    }

    private static void loadTriangleIcons() {
        TRIANGLE_BLACK_CLOSED = WmiComponentUtil.getImageIcon(TRIANGLE_BLACK_CLOSED_ICON);
        TRIANGLE_BLACK_OPEN = WmiComponentUtil.getImageIcon(TRIANGLE_BLACK_OPEN_ICON);
        TRIANGLE_BLACK_ARMED = WmiComponentUtil.getImageIcon(TRIANGLE_BLACK_ARMED_ICON);
        TRIANGLE_WHITE_CLOSED = WmiComponentUtil.getImageIcon(TRIANGLE_WHITE_CLOSED_ICON);
        TRIANGLE_WHITE_OPEN = WmiComponentUtil.getImageIcon(TRIANGLE_WHITE_OPEN_ICON);
        TRIANGLE_WHITE_ARMED = WmiComponentUtil.getImageIcon(TRIANGLE_WHITE_ARMED_ICON);
    }

    public WmiDisclosureTriangle(boolean selected, int color) {
        this.color = color;
        this.setSelected(selected);
        this.configureButton();
    }

    private void configureButton() {
        this.setUI(DisclosureTriangleUI.getInstance());
    }

    private static class DisclosureTriangleUI
    extends BasicToggleButtonUI {
        private static DisclosureTriangleUI instance = null;

        private DisclosureTriangleUI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            c.setOpaque(false);
            c.setMinimumSize(DEFAULT_SIZE);
            c.setMaximumSize(DEFAULT_SIZE);
            c.setPreferredSize(DEFAULT_SIZE);
            c.setBorder(null);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            WmiDisclosureTriangle b = (WmiDisclosureTriangle)c;
            JToggleButton.ToggleButtonModel model = (JToggleButton.ToggleButtonModel)b.getModel();
            Icon icon = null;
            int x = 0;
            int y = 0;
            if (model.isArmed()) {
                icon = b.color == 1 ? TRIANGLE_WHITE_ARMED : TRIANGLE_BLACK_ARMED;
            } else if (model.isSelected()) {
                icon = b.color == 1 ? TRIANGLE_WHITE_OPEN : TRIANGLE_BLACK_OPEN;
                y = 3;
            } else {
                icon = b.color == 1 ? TRIANGLE_WHITE_CLOSED : TRIANGLE_BLACK_CLOSED;
                x = 3;
                y = 1;
            }
            if (icon != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        public static DisclosureTriangleUI getInstance() {
            if (instance == null) {
                instance = new DisclosureTriangleUI();
            }
            return instance;
        }
    }
}

