/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.platform.WmiDropDownButtonUIFactory;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class WmiDropDownButton
extends JToggleButton
implements WmiComponent {
    public static final int DROP_DOWN_ARROW_REGION_WIDTH = 15;
    private static final String RESOURCES = "com/maplesoft/mathdoc/components/resources/";
    private static final String ARROW_ICON_LARGE = "com/maplesoft/mathdoc/components/resources/dropdownarrow_large.gif";
    private static final String ARROW_ICON_SMALL = "com/maplesoft/mathdoc/components/resources/dropdownarrow_small.gif";
    private static Icon arrowLarge = null;
    private static Icon arrowSmall = null;
    private boolean alwaysShowsMenu = false;
    protected JPopupMenu popupMenu = null;

    static {
        arrowLarge = WmiComponentUtil.getImageIcon(ARROW_ICON_LARGE);
        arrowSmall = WmiComponentUtil.getImageIcon(ARROW_ICON_SMALL);
    }

    protected WmiDropDownButton() {
        this((JPopupMenu)null);
    }

    public WmiDropDownButton(JPopupMenu popup) {
        this.popupMenu = popup;
        this.installUIAndModel();
    }

    private void installUIAndModel() {
        this.setUI(WmiDropDownButtonUIFactory.createUI());
        this.setModel(new DropDownButtonModel());
        this.addMouseListener(new DropDownMenuMouseListener());
    }

    public boolean isMenuVisible() {
        return this.popupMenu != null ? this.popupMenu.isVisible() : false;
    }

    @Override
    public void dispose() {
        this.popupMenu = null;
    }

    public boolean alwaysShowsMenu() {
        return this.alwaysShowsMenu;
    }

    public void setAlwaysShowsMenu(boolean alwaysShowsMenu) {
        this.alwaysShowsMenu = alwaysShowsMenu;
    }

    public Icon getDropDownIcon() {
        Icon icon = null;
        icon = arrowLarge;
        return icon;
    }

    private class DropDownButtonModel
    extends DefaultButtonModel {
        private DropDownButtonModel() {
        }

        @Override
        public boolean isSelected() {
            return super.isSelected() || WmiDropDownButton.this.isMenuVisible();
        }
    }

    private class DropDownMenuMouseListener
    extends MouseAdapter {
        private DropDownMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!WmiDropDownButton.this.isMenuVisible() && WmiDropDownButton.this.popupMenu != null) {
                int x = e.getX();
                final Component c = e.getComponent();
                if (WmiDropDownButton.this.alwaysShowsMenu || x > c.getWidth() - 15 || e.getButton() != 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((DropDownMenuMouseListener)DropDownMenuMouseListener.this).WmiDropDownButton.this.popupMenu.show(c, 0, c.getHeight() + 1);
                            MenuElement[] me = new MenuElement[]{((DropDownMenuMouseListener)DropDownMenuMouseListener.this).WmiDropDownButton.this.popupMenu};
                            MenuSelectionManager.defaultManager().setSelectedPath(me);
                            WmiDropDownButton.this.repaint();
                        }
                    });
                    e.consume();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

