/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.FloatValueControlSliderUI;
import com.maplesoft.mathdoc.components.WmiFloatValueTarget;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WmiFloatValueControl
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    public static final String PROMPT_KEY = "PROMPT";
    public static final String INFO_KEY = "INFO";
    public static final String MIN_VAL_KEY = "MIN";
    public static final String MAX_VAL_KEY = "MAX";
    public static final int DEFAULT_PRECISION = 2;
    private static final double FONT_SCALE = 0.8;
    private int ctrlId;
    private JSlider ctrlSlider = null;
    private JFormattedTextField ctrlTextField = null;
    private double ctrlValue = 0.0;
    private String promptString = null;
    private String infoString = null;
    private String minString = null;
    private String maxString = null;
    private double ctrlMin = 0.0;
    private double ctrlMax = 1000.0;
    private int ctrlPrecision = 0;
    private Vector targets = new Vector();
    private boolean inhibitValueUpdate = false;

    public WmiFloatValueControl(int id, String resources, String key, int digits) {
        this(id, resources, key, digits, 1);
    }

    public WmiFloatValueControl(int id, String resources, String key, int digits, int orientation) {
        this.ctrlId = id;
        this.ctrlPrecision = digits;
        this.loadResources(resources, key);
        this.setLayout(new BoxLayout(this, orientation));
        this.addComponents();
    }

    public WmiFloatValueControl(int id, String resources, String key) {
        this(id, resources, key, 2);
    }

    public WmiFloatValueControl(String resources, String key, int digits) {
        this(-1, resources, key, digits);
    }

    public WmiFloatValueControl(String resources, String key) {
        this(-1, resources, key, 2);
    }

    public void setDrawSliderTicks(boolean drawTicks) {
        if (this.ctrlSlider != null) {
            this.ctrlSlider.setPaintTicks(drawTicks);
        }
    }

    public void setRange(double min, double max) {
        this.ctrlMin = min;
        this.ctrlMax = max;
        this.setValue(this.getValue());
    }

    public double getValue() {
        return this.ctrlValue;
    }

    public void setValue(double value) {
        this.setValue(value, true, true);
    }

    public void setValue(double value, boolean doNotify, boolean doUpdate) {
        this.ctrlValue = value < this.ctrlMin ? this.ctrlMin : (value > this.ctrlMax ? this.ctrlMax : value);
        if (doNotify) {
            this.notifyTargets();
        }
        if (doUpdate) {
            if (this.ctrlSlider != null) {
                this.ctrlSlider.setValue(this.getScaledSliderValue(this.ctrlValue));
            }
            if (this.ctrlTextField != null) {
                this.ctrlTextField.setValue(new Double(this.ctrlValue));
            }
        }
    }

    protected void addComponents() {
        JLabel promptLabel = new JLabel(this.promptString);
        Font infoFont = promptLabel.getFont();
        infoFont = infoFont.deriveFont((float)(0.8 * (double)infoFont.getSize()));
        JLabel infoLabel = new JLabel(this.infoString);
        infoLabel.setFont(infoFont);
        JPanel promptPanel = new JPanel();
        promptPanel.setLayout(new BoxLayout(promptPanel, 1));
        promptPanel.add(promptLabel);
        promptPanel.add(Box.createVerticalStrut(2));
        promptPanel.add(infoLabel);
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMinimumFractionDigits(this.ctrlPrecision);
        formatter.setMaximumFractionDigits(this.ctrlPrecision);
        this.ctrlTextField = new JFormattedTextField(formatter);
        this.ctrlTextField.setColumns(5);
        this.ctrlTextField.setValue(new Double(this.getValue()));
        this.ctrlTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "verify_edit");
        this.ctrlTextField.getActionMap().put("verify_edit", new WmiTextInputHandler());
        this.ctrlTextField.addPropertyChangeListener(this);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(promptPanel);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(this.ctrlTextField);
        this.add(topPanel);
        this.ctrlSlider = new JSlider();
        this.ctrlSlider.setUI(new FloatValueControlSliderUI(this.ctrlSlider));
        if (this.minString != null && this.maxString != null) {
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            JLabel minLabel = new JLabel(this.minString);
            minLabel.setFont(infoFont);
            JLabel maxLabel = new JLabel(this.maxString);
            maxLabel.setFont(infoFont);
            labels.put(new Integer(0), minLabel);
            labels.put(new Integer(100), maxLabel);
            this.ctrlSlider.setLabelTable(labels);
            this.ctrlSlider.setPaintLabels(true);
        }
        this.ctrlSlider.setPaintTicks(true);
        this.ctrlSlider.setMajorTickSpacing(25);
        this.ctrlSlider.setValue(this.getScaledSliderValue(this.ctrlValue));
        this.ctrlSlider.addChangeListener(this);
        this.add(this.ctrlSlider);
    }

    protected void loadResources(String resources, String key) {
        WmiResourcePackage resBundle = WmiResourcePackage.getResourcePackage(resources);
        this.promptString = resBundle.getStringForKey(String.valueOf(key) + "." + PROMPT_KEY);
        this.infoString = resBundle.getStringForKey(String.valueOf(key) + "." + INFO_KEY);
        this.minString = resBundle.getStringForKey(String.valueOf(key) + "." + MIN_VAL_KEY);
        this.maxString = resBundle.getStringForKey(String.valueOf(key) + "." + MAX_VAL_KEY);
    }

    private double rangeClamp(double input) {
        double output = input;
        if (output < this.ctrlMin) {
            output = this.ctrlMin;
        } else if (output > this.ctrlMax) {
            output = this.ctrlMax;
        }
        return output;
    }

    private int getScaledSliderValue(double input) {
        double output = this.rangeClamp(input);
        output = (output - this.ctrlMin) / (this.ctrlMax - this.ctrlMin) * 100.0;
        return (int)Math.round(output);
    }

    private double getScaledControlValue(int input) {
        double output = input;
        output = output * (this.ctrlMax - this.ctrlMin) / 100.0 + this.ctrlMin;
        return output;
    }

    public void addSliderMouseListener(MouseListener listener) {
        this.ctrlSlider.addMouseListener(listener);
    }

    public void removeSliderMouseListener(MouseListener listener) {
        this.ctrlSlider.removeMouseListener(listener);
    }

    public void addTarget(WmiFloatValueTarget target) {
        if (!this.targets.contains(target)) {
            this.targets.add(target);
        }
    }

    public void removeTarget(WmiFloatValueTarget target) {
        this.targets.remove(target);
    }

    private void notifyTargets() {
        Iterator i = this.targets.iterator();
        while (i.hasNext()) {
            ((WmiFloatValueTarget)i.next()).valueChangeNotify(this.ctrlId, this.ctrlValue);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider slider;
        JSlider jSlider = slider = e.getSource() instanceof JSlider ? (JSlider)e.getSource() : null;
        if (slider != null) {
            if (!this.inhibitValueUpdate) {
                this.setValue(this.getScaledControlValue(slider.getValue()));
            }
            if (!slider.getValueIsAdjusting()) {
                this.ctrlTextField.setValue(new Double(this.getValue()));
            } else if (this.ctrlPrecision != 0) {
                this.ctrlTextField.setText(String.valueOf(this.getValue()));
            } else {
                this.ctrlTextField.setText(String.valueOf((int)this.getValue()));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("value".equals(e.getPropertyName())) {
            Number value = (Number)e.getNewValue();
            this.setValue(value.doubleValue());
            if (this.ctrlSlider != null && value != null) {
                this.ctrlSlider.setValue(this.getScaledSliderValue(this.getValue()));
            }
        }
    }

    protected class WmiTextInputHandler
    extends AbstractAction {
        protected WmiTextInputHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!WmiFloatValueControl.this.ctrlTextField.isEditValid()) {
                Toolkit.getDefaultToolkit().beep();
                WmiFloatValueControl.this.ctrlTextField.selectAll();
            } else {
                try {
                    try {
                        WmiFloatValueControl.this.inhibitValueUpdate = true;
                        WmiFloatValueControl.this.ctrlTextField.commitEdit();
                    }
                    catch (ParseException parseException) {
                        WmiFloatValueControl.this.inhibitValueUpdate = false;
                    }
                }
                finally {
                    WmiFloatValueControl.this.inhibitValueUpdate = false;
                }
            }
        }
    }
}

