/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPalette;
import com.maplesoft.mathdoc.controller.WmiMenu;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;

public class WmiMathMLMenuParser {
    public static final String PARSER_RESOURCES = "com.maplesoft.mathdoc.components.resources.palette.parser";
    private static final String INCLUDE_ELEMENT = "<incl";
    private static final String TOOLBAR_ELEMENT = "tb";
    private static final String TOOLBAR_END_ELEMENT = "/tb";
    private static final String BUTTON_ELEMENT = "btn";
    private static final String BUTTON_END_ELEMENT = "/btn";
    private static final String SUBMENU_ELEMENT = "sub";
    private static final String SUBMENU_END_ELEMENT = "/sub";
    private static final String SEPARATOR_ELEMENT = "sep/";
    private static final String SIZE_ATTRIBUTE = "size";
    private static final String COLS_ATTRIBUTE = "cols";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CUE_ATTRIBUTE = "cue";
    private static final int DEFAULT_COLUMN_COUNT = 4;
    private String menuXML = "";
    private WmiMathMLEditorDocumentView view = null;
    private WmiMathMLEditorButtonMenu buttonMenu = null;
    private WmiResourcePackage parserPackage = null;
    private Stack infoStack = null;
    private Stack menuStack = null;
    private int buttonIndex = 0;
    private boolean ignoreSubmenu = false;
    private WmiMathMLEditorPalette currentPalette = null;
    private static ArrayList ignoreButtons = new ArrayList();

    static {
        ignoreButtons.add("HELP");
        ignoreButtons.add("CUT");
        ignoreButtons.add("COPY");
        ignoreButtons.add("PASTE");
        ignoreButtons.add("UNDO");
        ignoreButtons.add("BIGGER");
        ignoreButtons.add("SMALLER");
        ignoreButtons.add("TOOLBOX");
        ignoreButtons.add("CHECKSYNTAX");
    }

    public WmiMathMLMenuParser(WmiMenu destMenu, String menuXML, WmiMathMLEditorDocumentView view) {
        this.menuXML = menuXML;
        this.view = view;
        this.infoStack = new Stack();
        this.menuStack = new Stack();
        MenuInfo menuInfo = new MenuInfo();
        menuInfo.menu = (WmiMathMLEditorButtonMenu)destMenu;
        this.menuStack.push(menuInfo);
        this.parserPackage = WmiResourcePackage.getResourcePackage(PARSER_RESOURCES);
    }

    public static void main(String[] args) {
        String[] buttonTestData;
        String[] includeTestData = new String[]{"", "<btn></btn>", "<incl name=#standard/>", "<incl name=\"#standard\"/>", "<incl name='#standard'/>", "<incl name=#standard>", "<incl name=#standard/><incl name=#Greek/>"};
        String[] toolbarTestData = new String[]{"", "<tb></tb>", "<tb><btn></btn></tb>", "<tb size=s cols=5></tb>", "<tb size='w'></tb>", "<tb cols=\"3\"></tb>"};
        String[] testData = buttonTestData = new String[]{"<tb><btn></btn></tb>", "<tb><btn>FENCESPALETTE</btn><sub cols=1><btn>DEFINT</btn></sub></tb>"};
        int i = 0;
        while (i < testData.length) {
            WmiMathMLMenuParser parser = new WmiMathMLMenuParser(new WmiMenu(), testData[i], new WmiMathMLEditorDocumentView());
            parser.parse();
            ++i;
        }
    }

    public void parse() {
        this.menuXML = this.processIncludes(this.menuXML);
        String[] tokens = this.menuXML.split("[<>]");
        int tokenCounter = 0;
        int tokenCount = tokens.length;
        String token = tokens[tokenCounter];
        while (token.trim().equals("")) {
            token = tokens[++tokenCounter];
        }
        while (tokenCounter < tokenCount && !token.equals(TOOLBAR_END_ELEMENT)) {
            if (token.startsWith(TOOLBAR_ELEMENT)) {
                this.parseToolbar(token);
            } else if (token.startsWith(BUTTON_ELEMENT)) {
                String nextToken = tokens[++tokenCounter];
                this.parseButton(tokens, tokenCounter, token, nextToken);
            } else if (token.startsWith(SUBMENU_ELEMENT)) {
                this.parseSubMenu(token);
            } else if (token.startsWith(SUBMENU_END_ELEMENT)) {
                this.parseSubMenuEnd();
            } else if (!token.startsWith(BUTTON_END_ELEMENT) && token.startsWith(SEPARATOR_ELEMENT)) {
                this.addSeparator();
            }
            token = tokens[++tokenCounter];
            while (token.trim().equals("")) {
                token = tokens[++tokenCounter];
            }
        }
    }

    public String processIncludes(String originalXML) {
        boolean done = false;
        StringBuffer newXML = new StringBuffer(originalXML);
        int startIndex = 0;
        int nameIndex = 0;
        int endIndex = 0;
        while (!done) {
            startIndex = newXML.indexOf(INCLUDE_ELEMENT, startIndex);
            nameIndex = newXML.indexOf("=", startIndex);
            endIndex = newXML.indexOf(">", startIndex);
            String name = "";
            if (startIndex >= 0 && endIndex >= 0) {
                String include;
                name = newXML.substring(nameIndex + 1, endIndex);
                if ((name = this.stripQuotes(name.trim())).startsWith("#")) {
                    name = name.substring(1);
                }
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((include = this.parserPackage.getStringForKey(name)) != null) {
                    newXML.delete(startIndex, endIndex + 1);
                    newXML.insert(startIndex, include);
                    continue;
                }
                startIndex = endIndex;
                continue;
            }
            done = true;
        }
        return newXML.toString();
    }

    private String stripQuotes(String attr) {
        String newAttr = "";
        newAttr = attr.replaceAll("\"", "");
        newAttr = newAttr.replaceAll("'", "");
        return newAttr;
    }

    public void parseToolbar(String element) {
        StringTokenizer tokenizer = new StringTokenizer(element);
        LevelInfo info = new LevelInfo();
        String token = "";
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            int equalsIndex = token.indexOf("=");
            if (equalsIndex < 0) continue;
            String attribute = token.substring(0, equalsIndex).trim();
            String value = token.substring(equalsIndex + 1).trim();
            if (attribute.equals(SIZE_ATTRIBUTE)) {
                info.size = this.stripQuotes(value);
                continue;
            }
            if (!attribute.equals(COLS_ATTRIBUTE)) continue;
            try {
                info.cols = Integer.parseInt(this.stripQuotes(value));
            }
            catch (NumberFormatException e) {
                info.cols = 4;
            }
        }
        this.infoStack.push(info);
    }

    public void parseButton(String[] tokens, int tokenCounter, String element, String label) {
        if (label.equals(BUTTON_END_ELEMENT) || this.ignoreSubmenu) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(element);
        String token = "";
        String type = "";
        String cue = "";
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            int equalsIndex = token.indexOf("=");
            if (equalsIndex < 0) continue;
            String attribute = token.substring(0, equalsIndex).trim();
            String value = token.substring(equalsIndex + 1).trim();
            if (attribute.equals(TYPE_ATTRIBUTE)) {
                type = this.stripQuotes(value).trim();
                continue;
            }
            if (!attribute.equals(CUE_ATTRIBUTE)) continue;
            cue = this.stripQuotes(value).trim();
        }
        int nextTokenCounter = tokenCounter + 3;
        String nextToken = tokens[nextTokenCounter];
        while (nextToken.trim().equals("")) {
            nextToken = tokens[++nextTokenCounter];
        }
        LevelInfo info = (LevelInfo)this.infoStack.peek();
        WmiMathMLEditorButtonMenu currentMenu = ((MenuInfo)this.menuStack.peek()).menu;
        if (info.newLevel && !ignoreButtons.contains(label)) {
            if (nextToken.startsWith(SUBMENU_ELEMENT)) {
                WmiMathMLEditorPalette newPalette;
                WmiMathMLEditorButtonMenu menu = new WmiMathMLEditorButtonMenu("MathMLEditorContextMenu", "com.maplesoft.mathdoc.components.resources.palette.Palette", "com/maplesoft/mathdoc/components/resources/palette/", 2, this.view, false, false, "");
                currentMenu = ((MenuInfo)this.menuStack.peek()).menu;
                currentMenu.replacePaletteWithMenu(menu, this.view);
                MenuInfo menuInfo = new MenuInfo();
                menuInfo.menu = menu;
                this.menuStack.push(menuInfo);
                info.isMenu = true;
                info.newLevel = false;
                ArrayList nameList = this.currentPalette.getOriginalNameList();
                ArrayList tooltipList = this.currentPalette.getTooltipList();
                int i = 0;
                while (i < nameList.size()) {
                    menu.createMenuItemButton(nameList.get(i).toString(), this.parserPackage, tooltipList.get(i).toString());
                    ++i;
                }
                menu.buttonMenuWindow = currentMenu.buttonMenuWindow;
                info.palette = newPalette = menu.createMenuButton(label, this.parserPackage, cue);
                this.currentPalette = newPalette;
            } else {
                WmiMathMLEditorPalette currentPalette = info.palette;
                currentPalette.setColumnCount(info.cols);
                currentPalette.addItem(label, this.parserPackage, this.buttonIndex, cue);
                ++this.buttonIndex;
            }
        } else {
            this.buttonIndex = 0;
            if (!ignoreButtons.contains(label)) {
                if (nextToken.startsWith(SUBMENU_ELEMENT)) {
                    this.currentPalette = info.palette = currentMenu.createMenuButton(label, this.parserPackage, cue);
                } else {
                    currentMenu.createMenuItemButton(label, this.parserPackage, cue);
                }
            } else if (nextToken.startsWith(SUBMENU_ELEMENT)) {
                this.ignoreSubmenu = true;
            }
            String string = info.size;
        }
    }

    private boolean isBottomMenu(String[] tokens, int tokenCounter) {
        boolean isBottomMenu = true;
        if (tokens[tokenCounter - 7].startsWith(SUBMENU_ELEMENT)) {
            return false;
        }
        int counter = tokenCounter;
        while (!tokens[counter].equals(SUBMENU_END_ELEMENT)) {
            if (tokens[counter].startsWith(SUBMENU_ELEMENT)) {
                isBottomMenu = false;
            }
            ++counter;
        }
        return isBottomMenu;
    }

    public void parseSubMenu(String element) {
        this.buttonIndex = 0;
        StringTokenizer tokenizer = new StringTokenizer(element);
        LevelInfo info = new LevelInfo();
        info.newLevel = true;
        info.palette = this.currentPalette;
        String token = "";
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            int equalsIndex = token.indexOf("=");
            if (equalsIndex < 0) continue;
            String attribute = token.substring(0, equalsIndex).trim();
            String value = token.substring(equalsIndex + 1).trim();
            if (attribute.equals(SIZE_ATTRIBUTE)) {
                info.size = this.stripQuotes(value);
                continue;
            }
            if (!attribute.equals(COLS_ATTRIBUTE)) continue;
            try {
                info.cols = Integer.parseInt(this.stripQuotes(value));
            }
            catch (NumberFormatException e) {
                info.cols = 4;
            }
        }
        this.infoStack.push(info);
    }

    public void parseSubMenuEnd() {
        LevelInfo info = (LevelInfo)this.infoStack.pop();
        if (info.isMenu) {
            this.menuStack.pop();
        } else if (info.palette != null) {
            info.palette.configureSize(info.cols, this.buttonIndex);
        }
        this.ignoreSubmenu = false;
        this.buttonIndex = 0;
    }

    public void addSeparator() {
    }

    private class LevelInfo {
        String size = "";
        int cols = 4;
        boolean newLevel = false;
        WmiMathMLEditorPalette palette;
        boolean isMenu = false;

        private LevelInfo() {
        }
    }

    private class MenuInfo {
        WmiMathMLEditorButtonMenu menu;

        private MenuInfo() {
        }
    }
}

