/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WmiPopupList
extends JPopupMenu {
    public static final int SHOW_LIMIT = 8;
    public static final int PAD_WIDTH = 30;
    public static final int DEFAULT_WIDTH = 350;
    protected JList list;
    private JScrollPane scroller;
    protected WmiMathDocumentView docView;
    protected int position;
    protected int prefixLength;
    protected Object selection;

    public WmiPopupList(WmiMathDocumentView docView, Vector data, int position, int prefixLength) {
        this.docView = docView;
        this.position = position;
        this.prefixLength = prefixLength;
        Component parent = SwingUtilities.getRoot(docView);
        if (parent != null && parent instanceof JFrame) {
            this.setInvoker((JFrame)parent);
        }
        if (RuntimePlatform.isWindows() && parent != null && parent instanceof JDialog) {
            this.setInvoker((JDialog)parent);
        }
        this.createList(data);
        this.createScroller();
        this.configurePopup();
    }

    protected void createList(Vector data) {
        this.list = new JList(data);
        this.list.setBorder(null);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new WmiListSelectionHandler());
        this.list.addMouseMotionListener(new WmiListMouseMotionHandler());
        this.list.addMouseListener(new WmiListMouseHandler());
        this.list.setFocusTraversalKeysEnabled(false);
        this.list.addKeyListener(new WmiListKeyHandler());
    }

    @Override
    public void setVisible(boolean b) {
        if (b != this.isVisible() && !b) {
            Component c = this.getInvoker();
            while (c != null && !(c instanceof Window)) {
                c = c.getParent();
            }
            if (c instanceof Window) {
                ((Window)c).toFront();
            }
        }
        super.setVisible(b);
    }

    protected void createScroller() {
        this.scroller = new JScrollPane(this.list, 20, 31);
        this.scroller.getVerticalScrollBar().setRequestFocusEnabled(false);
        this.scroller.setBorder(null);
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        if (!RuntimePlatform.isMac()) {
            this.setBorderPainted(true);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.list.getModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    public void display() {
        Dimension listSize = this.computeSize();
        int height = (int)listSize.getHeight();
        int width = (int)listSize.getWidth();
        Border border = this.scroller.getBorder();
        Insets insets = null;
        if (border != null) {
            insets = border.getBorderInsets(this.scroller);
            height += insets.top + insets.bottom;
            width += insets.left + insets.right;
        }
        this.setSize(this.scroller, width, height);
        border = this.getBorder();
        if (border != null) {
            insets = border.getBorderInsets(this);
            height += insets.top + insets.bottom;
            width += insets.left + insets.right;
        }
        this.setSize(this, width, height);
        Point listPosition = this.computePosition();
        Point limit = this.computePlacementLimit();
        int xOffset = (int)listPosition.getX();
        int yOffset = (int)listPosition.getY();
        if (width + xOffset > (int)limit.getX()) {
            xOffset -= width;
        }
        if (height + yOffset > (int)limit.getY()) {
            yOffset -= height + this.getLineHeight();
        }
        this.setLocation(xOffset, yOffset);
        this.setVisible(true);
        this.repaint();
        boolean focus = this.list.requestFocusInWindow();
        this.list.setSelectedIndex(0);
        if (!focus && this.list.getRootPane() != this.docView.getRootPane()) {
            Container parent = this.list.getParent();
            while (parent != null && !(parent instanceof Window)) {
                parent = parent.getParent();
            }
            Container docParent = this.docView.getRootPane().getParent();
            while (docParent != null && !(docParent instanceof Window)) {
                docParent = docParent.getParent();
            }
            if (parent instanceof Window && !(docParent instanceof JDialog)) {
                ((Window)parent).toFront();
            }
        }
    }

    protected Dimension computeSize() {
        int width = 0;
        int height = 0;
        ListModel model = this.list.getModel();
        int count = model.getSize();
        ListCellRenderer cr = this.list.getCellRenderer();
        if (count > 0) {
            Component c = cr.getListCellRendererComponent(this.list, model.getElementAt(0), 0, false, false);
            Dimension d = c.getPreferredSize();
            width = 350;
            height = d.height;
        }
        height = count > 8 ? (height *= 8) : (height *= count);
        return new Dimension(width + 30, height);
    }

    protected Point computePosition() {
        WmiPositionMarker marker = this.docView != null ? this.docView.getPositionMarker() : null;
        int x = 0;
        int y = 0;
        if (marker != null && marker instanceof WmiCaret) {
            Rectangle caret = marker.getBounds();
            x = caret.x;
            y = caret.height;
            y = (int)((double)y + WmiViewUtil.getAbsoluteOffset(marker.getView()).getY());
            Point p = new Point(x, y);
            SwingUtilities.convertPointToScreen(p, this.docView);
            x = p.x;
            y = p.y;
        }
        return new Point(x, y);
    }

    protected int getLineHeight() {
        int height = 0;
        try {
            WmiPositionMarker marker = null;
            if (this.docView != null) {
                marker = this.docView.getPositionMarker();
            }
            if (marker != null && marker.isVisible() && marker instanceof WmiCaret) {
                Rectangle caret = marker.getBounds();
                height = (int)caret.getHeight();
            }
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
        return height;
    }

    protected Point computePlacementLimit() {
        Rectangle bounds = this.docView.getBounds();
        int xOffset = (int)bounds.getWidth();
        int yOffset = (int)bounds.getHeight();
        Container c = this.docView;
        while (c != null) {
            bounds = c.getBounds();
            xOffset += (int)bounds.getMinX();
            yOffset += (int)bounds.getMinY();
            c = c.getParent();
        }
        return new Point(xOffset, yOffset);
    }

    protected void setSize(JComponent component, int width, int height) {
        Dimension d = new Dimension(width, height);
        component.setMaximumSize(d);
        component.setMinimumSize(d);
        component.setPreferredSize(d);
        component.invalidate();
    }

    protected void selectionFinalized() {
        this.setVisible(false);
    }

    protected void updateCharacter(char ch) {
        this.setVisible(false);
        String charStr = String.valueOf(ch);
    }

    public void dispatchKeyEvent_Mac102Hack(KeyEvent e) {
        this.list.dispatchEvent(e);
    }

    private void moveSelection(int d) {
        int index = this.list.getSelectedIndex();
        if ((index += d) > this.list.getModel().getSize() - 1) {
            index = 0;
        } else if (index < 0) {
            index = this.list.getModel().getSize() - 1;
        }
        Object selection = this.list.getModel().getElementAt(index);
        this.list.setSelectedValue(selection, true);
    }

    protected class WmiListKeyHandler
    extends KeyAdapter {
        protected WmiListKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int modifiers = keyEvent.getModifiers();
            if (modifiers == 0) {
                if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 9) {
                    WmiPopupList.this.selectionFinalized();
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 8) {
                    WmiPopupList.this.setVisible(false);
                } else if (RuntimePlatform.isMac() && keyEvent.getKeyCode() == 40) {
                    WmiPopupList.this.moveSelection(1);
                    keyEvent.consume();
                } else if (RuntimePlatform.isMac() && keyEvent.getKeyCode() == 38) {
                    WmiPopupList.this.moveSelection(-1);
                    keyEvent.consume();
                } else {
                    char ch = keyEvent.getKeyChar();
                    if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == ':' || ch == '-') {
                        WmiPopupList.this.updateCharacter(ch);
                    }
                }
            } else {
                keyEvent.consume();
            }
        }
    }

    protected class WmiListMouseHandler
    extends MouseAdapter {
        protected WmiListMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent anEvent) {
            WmiPopupList.this.selectionFinalized();
        }
    }

    protected class WmiListMouseMotionHandler
    extends MouseMotionAdapter {
        protected WmiListMouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent anEvent) {
            Point location = anEvent.getPoint();
            Rectangle r = new Rectangle();
            WmiPopupList.this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                WmiPopupList.this.updateListBoxSelectionForEvent(anEvent, false);
            }
        }
    }

    protected class WmiListSelectionHandler
    implements ListSelectionListener {
        protected WmiListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WmiPopupList.this.selection = WmiPopupList.this.list.getSelectedValue();
        }
    }
}

