/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiMenu;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class WmiPopupMenu
extends WmiMenu {
    protected JPopupMenu popup = null;

    protected WmiPopupMenu(String name, String resources) {
        super(name, resources);
        this.buildMenu();
    }

    public JPopupMenu getContextMenu() {
        if (this.popup == null) {
            this.popup = this.buildPopupMenu(this.getMenuList());
        }
        return this.popup;
    }

    public void hideContextMenu() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    protected abstract String[] getMenuList();

    public JPopupMenu buildPopupMenu(String[] names) {
        return this.buildPopupMenu(names, null, null);
    }

    public JPopupMenu buildPopupMenu(String[] names, WmiCommand[] commands) {
        return this.buildPopupMenu(names, commands, null);
    }

    public JPopupMenu buildPopupMenu(String[] names, WmiCommand[] commands, String root) {
        this.buildMenuFromStringArray(names, commands, root, this);
        JPopupMenu returnedPopup = this.getPopupMenu();
        returnedPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                WmiPopupMenu.this.updateItems();
            }
        });
        return returnedPopup;
    }

    protected void updateItems() {
        this.updateItems(this.popup);
    }

    protected void updateItems(JComponent menu) {
        if (menu != null) {
            if (menu instanceof JMenuItem) {
                this.updateItem((JMenuItem)menu);
            }
            Component[] components = menu.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof JMenuItem) {
                    this.updateItem((JMenuItem)components[i]);
                }
                if (components[i] instanceof JMenu || components[i] instanceof JPopupMenu) {
                    this.updateItems((JComponent)components[i]);
                }
                ++i;
            }
            if (menu instanceof JMenu) {
                Component[] mcomponents = ((JMenu)menu).getMenuComponents();
                int i2 = 0;
                while (i2 < mcomponents.length) {
                    if (mcomponents[i2] instanceof JMenuItem) {
                        this.updateItem((JMenuItem)mcomponents[i2]);
                    }
                    if (mcomponents[i2] instanceof JMenu || mcomponents[i2] instanceof JPopupMenu) {
                        this.updateItems((JComponent)mcomponents[i2]);
                    }
                    ++i2;
                }
            }
        }
    }

    private void updateItem(JMenuItem item, WmiCommand command) {
        if (command != null) {
            item.setEnabled(command.isEnabled());
            if (command.getType() == 1) {
                item.setSelected(command.isSelected());
            }
        }
    }

    private void updateItem(JMenuItem item) {
        WmiCommand command = this.getCommandForItem(item);
        this.updateItem(item, command);
    }
}

