/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.Timer;

public class WmiSmoothFadeContainer
extends Container
implements ActionListener {
    protected static final int UPDATE_INTERVAL = 10;
    protected static final float DEF_ALPHA_MIN = 0.0f;
    protected static final float DEF_ALPHA_MAX = 1.0f;
    protected static final float DEF_ALPHA_STEP = 0.2f;
    protected float alphaMin = 0.0f;
    protected float alphaMax = 1.0f;
    protected float alphaStep = 0.2f;
    private float alphaCurrent = 0.0f;
    private float alphaStepCurrent = 0.2f;
    private Timer fadeTimer;
    private boolean detachAfterHide = false;
    private WeakReference myHost = null;

    public WmiSmoothFadeContainer(Container host, boolean autoDetachOnFadeout, float fadeMin, float fadeMax, float fadeStep) {
        if (host != null) {
            this.myHost = new WeakReference<Container>(host);
            host.add(this);
        }
        this.fadeTimer = new Timer(10, this);
        this.fadeTimer.setRepeats(true);
        this.detachAfterHide = autoDetachOnFadeout;
        this.alphaMin = fadeMin;
        this.alphaMax = fadeMax;
        this.alphaStep = fadeStep;
        this.alphaCurrent = this.alphaMin;
        this.alphaStepCurrent = this.alphaStep;
    }

    public WmiSmoothFadeContainer(Container host, boolean autoDetachOnFadeout, float fadeMin, float fadeMax) {
        this(host, autoDetachOnFadeout, fadeMin, fadeMax, 0.2f);
    }

    public WmiSmoothFadeContainer(Container host, boolean autoDetachOnFadeout) {
        this(host, autoDetachOnFadeout, 0.0f, 1.0f, 0.2f);
    }

    public WmiSmoothFadeContainer(Container host) {
        this(host, false, 0.0f, 1.0f, 0.2f);
    }

    protected void detach() {
        if (this.myHost != null) {
            Container hostContainer;
            Object host = this.myHost.get();
            Container container = hostContainer = host instanceof Container ? (Container)host : null;
            if (hostContainer != null) {
                hostContainer.remove(this);
            }
            this.myHost = null;
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag) {
            this.alphaStepCurrent = this.alphaStep;
            super.setVisible(true);
        } else {
            this.alphaStepCurrent = -this.alphaStep;
        }
        if (!this.fadeTimer.isRunning()) {
            this.fadeTimer.start();
        }
    }

    public void setVisibleImmediately(boolean aFlag) {
        this.fadeTimer.stop();
        if (aFlag) {
            super.setVisible(aFlag);
            this.alphaStepCurrent = this.alphaStep;
            this.alphaCurrent = this.alphaMax;
        } else {
            this.alphaStepCurrent = -this.alphaStep;
            this.alphaCurrent = this.alphaMin;
        }
        this.actionPerformed(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.alphaCurrent += this.alphaStepCurrent;
        if (this.alphaCurrent > this.alphaMax && this.alphaStepCurrent > 0.0f) {
            this.alphaCurrent = this.alphaMax;
            this.fadeTimer.stop();
        } else if (this.alphaCurrent < this.alphaMin && this.alphaStepCurrent < 0.0f) {
            this.alphaCurrent = this.alphaMin;
            this.fadeTimer.stop();
            super.setVisible(false);
            if (this.detachAfterHide) {
                this.detach();
            }
        }
        if (this.isVisible()) {
            this.requestRepaint();
        }
    }

    protected void requestRepaint() {
        Container p = this.myHost != null ? (Container)this.myHost.get() : this.getParent();
        Rectangle b = this.getBounds();
        if (p != null && b != null) {
            p.repaint(b.x, b.y, b.width, b.height);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2D;
        boolean doNonCompositedPaint = true;
        Graphics2D graphics2D = g2D = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (g2D != null && g2D.getDeviceConfiguration().getColorModel().hasAlpha()) {
            Composite pComp = g2D.getComposite();
            g2D.setComposite(AlphaComposite.getInstance(10, this.alphaCurrent));
            super.paint(g);
            g2D.setComposite(pComp);
            doNonCompositedPaint = false;
        }
        if (doNonCompositedPaint) {
            super.paint(g);
        }
    }
}

