/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.WmiStepperTarget;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class WmiStepperControl
extends JLabel
implements WmiComponent {
    public static final int DEFAULT_STEPPER_SIZE = 2;
    private static final String RESOURCE_PATH_ROOT = "com/maplesoft/mathdoc/components/resources/stepper";
    private static final String ENABLED_ICON = "/stepper_enabled.png";
    private static final String INCREMENT_ICON = "/stepper_increment.png";
    private static final String DECREMENT_ICON = "/stepper_decrement.png";
    private static final String DISABLED_ICON = "/stepper_disabled.png";
    private static final long SCROLL_DELAY_TIME = 100L;
    private static final int SCROLL_SPEED_FACTOR = 4;
    private static final String NOTIFY_THREAD_NAME = "Step Control Notifier";
    private int ctrlId = -1;
    private int ctrlSize = 2;
    private Vector targets = new Vector();
    private WmiStepperControlMouseListener mouseListener = new WmiStepperControlMouseListener();
    private boolean mouseButtonDown = false;
    private Thread notificationThread = null;
    private int scrollDirection = 0;
    private ImageIcon disabledImage = null;
    private ImageIcon enabledImage = null;
    private ImageIcon incrementImage = null;
    private ImageIcon decrementImage = null;

    public WmiStepperControl(int id, int size) {
        this.ctrlId = id;
        this.ctrlSize = size;
        this.loadControlImages(size);
        this.setControlAppearance(0);
        this.addMouseListener(this.mouseListener);
    }

    public WmiStepperControl(int id) {
        this(id, 2);
    }

    public WmiStepperControl() {
        this(-1, 2);
    }

    private void setControlAppearance(int direction) {
        ImageIcon icon = null;
        if (this.isEnabled()) {
            switch (direction) {
                case 1: {
                    icon = this.incrementImage;
                    break;
                }
                case -1: {
                    icon = this.decrementImage;
                    break;
                }
                default: {
                    icon = this.enabledImage;
                    break;
                }
            }
        } else {
            icon = this.disabledImage;
        }
        if (icon != null) {
            this.setIcon(icon);
            this.paintImmediately(this.getBounds());
        }
    }

    private void loadControlImages(int size) {
        String basePath = RESOURCE_PATH_ROOT + WmiComponentUtil.platformFolderName() + WmiComponentUtil.resourceFolderName(size);
        this.disabledImage = WmiComponentUtil.getImageIcon(String.valueOf(basePath) + DISABLED_ICON);
        this.enabledImage = WmiComponentUtil.getImageIcon(String.valueOf(basePath) + ENABLED_ICON);
        this.incrementImage = WmiComponentUtil.getImageIcon(String.valueOf(basePath) + INCREMENT_ICON);
        this.decrementImage = WmiComponentUtil.getImageIcon(String.valueOf(basePath) + DECREMENT_ICON);
    }

    public void addTarget(WmiStepperTarget target) {
        if (!this.targets.contains(target)) {
            this.targets.add(target);
        }
    }

    public void removeTarget(WmiStepperTarget target) {
        this.targets.remove(target);
    }

    private void notifyTargets() {
        long lastTime = 0L;
        long delayTime = 100L;
        while (this.mouseButtonDown) {
            lastTime = System.currentTimeMillis();
            Iterator i = this.targets.iterator();
            while (i.hasNext()) {
                ((WmiStepperTarget)i.next()).stepNotify(this.ctrlId, this.scrollDirection);
            }
            while (lastTime + delayTime > System.currentTimeMillis() && this.mouseButtonDown) {
            }
            if (100L - (delayTime /= 4L) * 4L <= 8L) continue;
            delayTime *= 4L;
        }
    }

    @Override
    public void dispose() {
        this.targets.clear();
        if (this.mouseListener != null) {
            this.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    private class WmiStepperControlMouseListener
    extends MouseAdapter {
        private WmiStepperControlMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle ctrlBounds = WmiStepperControl.this.getBounds();
            int midpoint = (int)(ctrlBounds.getHeight() / 2.0);
            if (e.getY() < midpoint) {
                WmiStepperControl.this.scrollDirection = 1;
            } else {
                WmiStepperControl.this.scrollDirection = -1;
            }
            WmiStepperControl.this.setControlAppearance(WmiStepperControl.this.scrollDirection);
            WmiStepperControl.this.notificationThread = new Thread(WmiStepperControl.NOTIFY_THREAD_NAME){

                @Override
                public void run() {
                    WmiStepperControl.this.notifyTargets();
                }
            };
            WmiStepperControl.this.mouseButtonDown = true;
            WmiStepperControl.this.notificationThread.setPriority(1);
            WmiStepperControl.this.notificationThread.start();
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            WmiStepperControl.this.mouseButtonDown = false;
            WmiStepperControl.this.setControlAppearance(0);
            e.consume();
        }
    }
}

