/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class WmiTable
extends JTable {
    public WmiTable() {
        this.initializeRenderers();
    }

    public WmiTable(TableModel dm) {
        super(dm);
        this.initializeRenderers();
    }

    public WmiTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initializeRenderers();
    }

    public WmiTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initializeRenderers();
    }

    public WmiTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initializeRenderers();
    }

    public WmiTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initializeRenderers();
    }

    public WmiTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initializeRenderers();
    }

    protected void initializeRenderers() {
        if (RuntimePlatform.isMac()) {
            this.setDefaultRenderer(Object.class, new WmiMacTableCellRenderer());
            this.setRowHeight(this.getRowHeight() + 2);
        }
    }

    protected static class WmiMacTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static Font font = new Font("Lucida Grande", 0, 12);
        private static Color selectWithFocusColor = new Color(56, 117, 215);
        private static Color selectWithoutFocusColor = new Color(212, 212, 212);
        boolean isSelected;
        boolean hasFocus;
        JTable myTable;

        protected WmiMacTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(font);
            this.isSelected = isSelected;
            this.hasFocus = hasFocus;
            this.myTable = table;
            if (this.isSelected && (this.hasFocus || table.getColumnCount() > 1)) {
                this.setForeground(Color.WHITE);
            } else {
                this.setForeground(Color.BLACK);
            }
            this.setText(value.toString());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Dimension dim = this.getPreferredSize();
            dim.height += 6;
            this.setPreferredSize(dim);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Color bColor = this.isSelected && (this.hasFocus || this.myTable.getColumnCount() > 1) ? selectWithFocusColor : (this.isSelected ? selectWithoutFocusColor : Color.white);
            g.setColor(bColor);
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            super.paint(g);
        }
    }
}

