/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.util.RuntimePlatform;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class WmiBorderSplitPane
extends JPanel {
    public static final int NORTH_LOCATION = 0;
    public static final int SOUTH_LOCATION = 1;
    public static final int EAST_LOCATION = 2;
    public static final int WEST_LOCATION = 3;
    public static final int CENTRAL_LOCATION = 4;
    protected static final int FIRST_DOCK_LOCATION = 0;
    protected static final int COLLAPSED_VALUE_START = 4;
    protected static final int DEFAULT_SPLITTER_SIZE = RuntimePlatform.isWindows() ? 5 : 14;
    public static final int NUMBER_OF_DOCK_LOCATIONS = 4;
    public static final int MAX_COMPONENTS_SUPPORTED = 5;
    public static final int ADJUSTMENT_TO_PREFERRED_SIZE = 200;
    public static final int ADJUSTMENT_TO_MIN_SIZE = 0;
    public static final int LOC_OF_SPLIT_IN_SPLITPANE = 0;
    public static final int MINIMUM_DIVIDER_LOCATION_WIDTH = 80;
    public static final String NORTH_DIVIDER_LOCATION_PROPERTY = "dock.location.North";
    public static final String SOUTH_DIVIDER_LOCATION_PROPERTY = "dock.location.South";
    public static final String EAST_DIVIDER_LOCATION_PROPERTY = "dock.location.East";
    public static final String WEST_DIVIDER_LOCATION_PROPERTY = "dock.location.West";
    public static final String NORTH_DIVIDER_COLLAPSED_PROPERTY = "dock.collapsed.North";
    public static final String SOUTH_DIVIDER_COLLAPSED_PROPERTY = "dock.collapsed.South";
    public static final String EAST_DIVIDER_COLLAPSED_PROPERTY = "dock.collapsed.East";
    public static final String WEST_DIVIDER_COLLAPSED_PROPERTY = "dock.collapsed.West";
    protected static final String[] locationToPropertyTable = new String[]{"dock.location.North", "dock.location.South", "dock.location.East", "dock.location.West", "dock.collapsed.North", "dock.collapsed.South", "dock.collapsed.East", "dock.collapsed.West"};
    protected static int splitterSize = DEFAULT_SPLITTER_SIZE;
    protected boolean[] visible = new boolean[4];
    public int[] splitDividerOffset = new int[4];
    public boolean[] collapsed = new boolean[4];
    private boolean oneTouchExpandable = true;
    private Rectangle dividerDraggedRect = null;

    public WmiBorderSplitPane() {
        super.setLayout(new SplitLayout());
        int i = 0;
        while (i < 5) {
            this.add(new JPanel());
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.setVisible(i, false);
            ++i;
        }
    }

    public boolean isVisible(int orientation) throws ArrayIndexOutOfBoundsException {
        return this.visible[orientation];
    }

    public void setVisible(int orientation, boolean value) throws ArrayIndexOutOfBoundsException {
        this.visible[orientation] = value;
        this.getComponent(orientation).setVisible(value);
    }

    public void setCollapsed(int orientation, boolean value) {
        boolean oldValue = this.collapsed[orientation];
        this.collapsed[orientation] = value;
        if (this.getComponent(orientation) instanceof DockContainer) {
            ((DockContainer)this.getComponent(orientation)).updateSplitterSize();
            ((DockContainer)this.getComponent(orientation)).setCollapsed(value);
            this.revalidate();
        }
        String property = this.getPropertyNameForLocation(orientation, 4);
        this.firePropertyChange(property, oldValue, value);
    }

    public void removeAtLocation(int location) {
        this.remove(location);
        this.add((Component)new JPanel(), location);
        this.setVisible(location, false);
        this.invalidate();
    }

    public boolean isCollapsed(int orientation) {
        return this.collapsed[orientation];
    }

    public void setOneTouchExpandable(boolean value) {
        this.oneTouchExpandable = value;
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    public int getDividerLocation(int orientation) {
        return this.splitDividerOffset[orientation];
    }

    public int getNorthDividerLocation() {
        return this.splitDividerOffset[0];
    }

    public int getSouthDividerLocation() {
        return this.splitDividerOffset[1];
    }

    public int getWestDividerLocation() {
        return this.splitDividerOffset[3];
    }

    public int getEastDividerLocation() {
        return this.splitDividerOffset[2];
    }

    public void setNorthDividerLocation(int size) {
        this.setDividerLocation(0, size);
    }

    public void setSouthDividerLocation(int size) {
        this.setDividerLocation(1, size);
    }

    public void setWestDividerLocation(int size) {
        this.setDividerLocation(3, size);
    }

    public void setEastDividerLocation(int size) {
        this.setDividerLocation(2, size);
    }

    public void setDividerLocation(int location, int size) {
        int old = this.splitDividerOffset[location];
        this.splitDividerOffset[location] = size = size < 80 ? 80 : size;
        this.revalidate();
        String property = this.getPropertyNameForLocation(location, 0);
        this.firePropertyChange(property, old, size);
    }

    protected String getPropertyNameForLocation(int location, int table) {
        return locationToPropertyTable[table + this.getLocationOffset(location)];
    }

    private int getLocationOffset(int location) {
        return location;
    }

    public void setNorth(Component toDock) {
        this.addAtLocation(0, toDock);
    }

    public void setSouth(Component toDock) {
        this.addAtLocation(1, toDock);
    }

    public void setEast(Component toDock) {
        this.addAtLocation(2, toDock);
    }

    public void setWest(Component toDock) {
        this.addAtLocation(3, toDock);
    }

    public void setCentral(Component toDock) {
        this.add(toDock, 4);
        this.revalidate();
    }

    public void addAtLocation(int location, Component toDock) {
        this.remove(location);
        this.add((Component)new DockContainer(toDock, location), location);
        this.setVisible(location, true);
        this.revalidate();
    }

    public Component getFromLocation(int location) {
        Component returned = null;
        Component comp = this.getComponent(location);
        if (comp instanceof DockContainer) {
            DockContainer docked = (DockContainer)this.getComponent(location);
            returned = docked.getComponentCount() > 1 ? docked.getComponent(1) : null;
        }
        return returned;
    }

    @Override
    public void setLayout(LayoutManager mang) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.dividerDraggedRect != null) {
            Graphics2D g2 = (Graphics2D)g;
            Composite saveComp = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
            g2.setColor(Color.GRAY);
            g2.fillRect(this.dividerDraggedRect.x, this.dividerDraggedRect.y, this.dividerDraggedRect.width, this.dividerDraggedRect.height);
            g2.setComposite(saveComp);
        }
    }

    public class CollapseListener
    implements ActionListener {
        protected int orientation;

        public CollapseListener(int orientation) {
            this.orientation = orientation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WmiBorderSplitPane.this.setCollapsed(this.orientation, this.willCollapseTarget());
        }

        public boolean willCollapseTarget() {
            return true;
        }
    }

    public class DockContainer
    extends JPanel {
        private Cursor resizeCursor;

        public DockContainer(Component target, int orientation) {
            this.setLayout(new BorderLayout());
            String addLocation = "South";
            JSplitPane tempSplit = null;
            Container split = null;
            int splitStyle = 0;
            switch (orientation) {
                case 0: {
                    addLocation = "South";
                    break;
                }
                case 1: {
                    addLocation = "North";
                    break;
                }
                case 2: {
                    addLocation = "West";
                    splitStyle = 1;
                    break;
                }
                case 3: {
                    addLocation = "East";
                    splitStyle = 1;
                }
            }
            tempSplit = new JSplitPane(splitStyle);
            tempSplit.setOneTouchExpandable(WmiBorderSplitPane.this.isOneTouchExpandable());
            split = (Container)tempSplit.getComponent(0);
            MouseDragger dragListener = new MouseDragger(orientation);
            split.addMouseListener(dragListener);
            split.addMouseMotionListener(dragListener);
            if (RuntimePlatform.isUnix()) {
                JPanel splitContainer = new JPanel();
                splitContainer.setLayout(new BorderLayout());
                splitContainer.setBorder(BorderFactory.createEtchedBorder());
                splitContainer.add((Component)split, "Center");
                this.add((Component)splitContainer, addLocation);
            } else {
                this.add((Component)split, addLocation);
            }
            this.resizeCursor = split.getCursor();
            this.updateSplitterSize();
            if (WmiBorderSplitPane.this.isOneTouchExpandable()) {
                int collapseButtonIndex = orientation == 0 || orientation == 3 ? 0 : 1;
                int uncollapseButtonIndex = orientation == 0 || orientation == 3 ? 1 : 0;
                ((JButton)split.getComponent(collapseButtonIndex)).addActionListener(new CollapseListener(orientation));
                ((JButton)split.getComponent(uncollapseButtonIndex)).addActionListener(new UnCollapseListener(orientation));
            }
            this.setComponent(target);
        }

        public void updateSplitterSize() {
            splitterSize = this.getComponent(0).getWidth() <= this.getComponent(0).getHeight() ? this.getComponent(0).getWidth() : this.getComponent(0).getHeight();
            splitterSize = splitterSize <= 0 ? DEFAULT_SPLITTER_SIZE : splitterSize;
        }

        @Override
        public void validate() {
            super.validate();
            this.updateSplitterSize();
        }

        public void setComponent(Component component) {
            this.add(component, "Center");
        }

        public void setCollapsed(boolean value) {
            Component comp = this.getComponent(1);
            if (comp != null) {
                comp.setVisible(!value);
            }
            Component split = this.getComponent(0);
            split.setCursor(value ? null : this.resizeCursor);
        }
    }

    public class MouseDragger
    extends MouseAdapter
    implements MouseMotionListener {
        private int orientation;
        private int startingMouseLocation;
        private int startingDividerLocation;
        private int lastDelta = 0;

        public MouseDragger(int orientation) {
            this.orientation = orientation;
            this.startingMouseLocation = -1;
            this.startingDividerLocation = WmiBorderSplitPane.this.getDividerLocation(orientation);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (WmiBorderSplitPane.this.isVisible(this.orientation) && !WmiBorderSplitPane.this.collapsed[this.orientation]) {
                this.startingMouseLocation = this.orientation == 0 || this.orientation == 1 ? e.getY() : e.getX();
                this.startingDividerLocation = WmiBorderSplitPane.this.getDividerLocation(this.orientation);
            }
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (WmiBorderSplitPane.this.isVisible(this.orientation) && !WmiBorderSplitPane.this.collapsed[this.orientation]) {
                int newLocation = this.orientation == 0 || this.orientation == 1 ? e.getY() : e.getX();
                int delta = this.startingMouseLocation - newLocation;
                if (this.orientation == 3 || this.orientation == 0) {
                    delta *= -1;
                }
                if (this.lastDelta != delta) {
                    WmiBorderSplitPane.this.setDividerLocation(this.orientation, this.startingDividerLocation + delta);
                }
                Component parent = (Component)e.getSource();
                while (parent != null && !(parent instanceof WmiBorderSplitPane)) {
                    parent = parent.getParent();
                }
                parent.invalidate();
                this.lastDelta = delta;
            }
            WmiBorderSplitPane.this.dividerDraggedRect = null;
            WmiBorderSplitPane.this.repaint();
            e.consume();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (WmiBorderSplitPane.this.isVisible(this.orientation) && !WmiBorderSplitPane.this.collapsed[this.orientation]) {
                Component source;
                Component parent = source = (Component)e.getSource();
                while (parent != null && !(parent instanceof WmiBorderSplitPane)) {
                    parent = parent.getParent();
                }
                int width = parent.getWidth();
                int height = parent.getHeight();
                Rectangle draggedRectRepaintRegion = WmiBorderSplitPane.this.dividerDraggedRect;
                if (this.orientation == 1 || this.orientation == 0) {
                    int yloc = this.orientation == 0 ? this.startingDividerLocation + e.getY() : height - this.startingDividerLocation + e.getY();
                    WmiBorderSplitPane.this.dividerDraggedRect = new Rectangle(0, yloc, width, splitterSize);
                } else {
                    int xloc = this.orientation == 3 ? this.startingDividerLocation + e.getX() : width - this.startingDividerLocation + e.getX();
                    WmiBorderSplitPane.this.dividerDraggedRect = new Rectangle(xloc - splitterSize, 0, splitterSize, height);
                }
                draggedRectRepaintRegion = draggedRectRepaintRegion != null ? SwingUtilities.computeUnion(((WmiBorderSplitPane)WmiBorderSplitPane.this).dividerDraggedRect.x, ((WmiBorderSplitPane)WmiBorderSplitPane.this).dividerDraggedRect.y, ((WmiBorderSplitPane)WmiBorderSplitPane.this).dividerDraggedRect.width, ((WmiBorderSplitPane)WmiBorderSplitPane.this).dividerDraggedRect.height, draggedRectRepaintRegion) : WmiBorderSplitPane.this.dividerDraggedRect;
                WmiBorderSplitPane.this.repaint(draggedRectRepaintRegion);
            }
            e.consume();
        }
    }

    private class SplitLayout
    implements LayoutManager {
        private SplitLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        private int getLocationWithCollapse(int orientation) {
            return WmiBorderSplitPane.this.isCollapsed(orientation) ? splitterSize : WmiBorderSplitPane.this.splitDividerOffset[orientation];
        }

        @Override
        public void layoutContainer(Container parent) {
            int bottomY;
            int centerY;
            int centralX;
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            if (WmiBorderSplitPane.this.isVisible(3)) {
                centralX = this.getLocationWithCollapse(3);
                centralX = centralX >= splitterSize ? centralX : splitterSize;
                centralX = centralX >= parentWidth - splitterSize * 2 ? parentWidth - splitterSize * 2 : centralX;
            } else {
                centralX = 0;
            }
            int rightX = parentWidth - this.getLocationWithCollapse(2);
            if (WmiBorderSplitPane.this.isVisible(2)) {
                rightX = rightX >= parentWidth ? parentWidth - splitterSize : rightX;
                rightX = rightX >= 0 ? rightX : 0;
            } else {
                rightX = parentWidth;
            }
            int centralWidth = rightX - centralX;
            if (WmiBorderSplitPane.this.isVisible(0)) {
                centerY = this.getLocationWithCollapse(0);
                centerY = centerY >= splitterSize ? centerY : splitterSize;
                centerY = centerY >= parentHeight - splitterSize * 2 ? parentHeight - splitterSize * 2 : centerY;
            } else {
                centerY = 0;
            }
            if (WmiBorderSplitPane.this.isVisible(1)) {
                bottomY = parentHeight - this.getLocationWithCollapse(1);
                bottomY = bottomY >= 0 ? bottomY : 0;
                bottomY = bottomY >= parentHeight - splitterSize ? parentHeight - splitterSize : bottomY;
            } else {
                bottomY = parentHeight;
            }
            int centralHeight = bottomY - centerY;
            centralWidth = centralWidth >= 0 ? centralWidth : 0;
            centralHeight = centralHeight >= 0 ? centralHeight : 0;
            bottomY = bottomY < this.getLocationWithCollapse(0) ? this.getLocationWithCollapse(0) : bottomY;
            int n = rightX = rightX < centralX ? centralX : rightX;
            if (WmiBorderSplitPane.this.getComponent(3) != null) {
                WmiBorderSplitPane.this.getComponent(3).setLocation(0, 0);
                WmiBorderSplitPane.this.getComponent(3).setSize(centralX, parentHeight);
            }
            if (WmiBorderSplitPane.this.getComponent(2) != null) {
                WmiBorderSplitPane.this.getComponent(2).setLocation(rightX, 0);
                WmiBorderSplitPane.this.getComponent(2).setSize(parentWidth - rightX, parentHeight);
            }
            if (WmiBorderSplitPane.this.getComponent(4) != null) {
                WmiBorderSplitPane.this.getComponent(4).setLocation(centralX, centerY);
                WmiBorderSplitPane.this.getComponent(4).setSize(centralWidth, centralHeight);
            }
            if (WmiBorderSplitPane.this.getComponent(0) != null) {
                WmiBorderSplitPane.this.getComponent(0).setLocation(centralX, 0);
                WmiBorderSplitPane.this.getComponent(0).setSize(centralWidth, centerY);
            }
            if (WmiBorderSplitPane.this.getComponent(1) != null) {
                WmiBorderSplitPane.this.getComponent(1).setLocation(centralX, bottomY);
                WmiBorderSplitPane.this.getComponent(1).setSize(centralWidth, parentHeight - bottomY);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(parent, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(parent, 200);
        }

        private Dimension calculateSize(Container parent, int adjustment) {
            int width = WmiBorderSplitPane.this.collapsed[2] || WmiBorderSplitPane.this.getComponent(2) == null ? 0 : WmiBorderSplitPane.this.splitDividerOffset[2];
            width += WmiBorderSplitPane.this.collapsed[3] || WmiBorderSplitPane.this.getComponent(3) == null ? 0 : WmiBorderSplitPane.this.splitDividerOffset[3];
            width += WmiBorderSplitPane.this.getComponent(4) == null ? 0 : WmiBorderSplitPane.this.getComponent(4).getWidth();
            int height = WmiBorderSplitPane.this.collapsed[0] || WmiBorderSplitPane.this.getComponent(0) == null ? 0 : WmiBorderSplitPane.this.splitDividerOffset[0];
            height += WmiBorderSplitPane.this.collapsed[1] || WmiBorderSplitPane.this.getComponent(1) == null ? 0 : WmiBorderSplitPane.this.splitDividerOffset[1];
            height += WmiBorderSplitPane.this.getComponent(4) == null ? 0 : WmiBorderSplitPane.this.getComponent(4).getHeight();
            return new Dimension(width += adjustment, height += adjustment);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    public class UnCollapseListener
    extends CollapseListener {
        public UnCollapseListener(int orientation) {
            super(orientation);
        }

        @Override
        public boolean willCollapseTarget() {
            return false;
        }
    }
}

