/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.WmiDisclosureTriangle;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockException;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockable;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteDnDManager;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteStackPanel;
import com.maplesoft.util.RuntimePlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.plaf.PanelUI;

public class WmiPalette
extends JPanel
implements WmiDockable {
    private static final int LEFT_RIGHT_BORDER = 4;
    private static final int PALETTE_IMAGE_MAX_HEIGHT = 600;
    protected JLabel label = null;
    private WmiDisclosureTriangle triangle = null;
    private JComponent content;
    private boolean wasExpanded = true;
    private Dimension animatedResizeDim = null;
    private Image contentGhostImage = null;
    private int contentX = 0;
    private int contentY = 0;
    public String resourceName = null;

    public WmiPalette(String resourceName, String title) {
        this.resourceName = resourceName;
        this.configurePanel();
        this.setTitle(title);
    }

    public void configurePanel() {
        this.setUI(PaletteGroupPanelUI.getInstance());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        JPanel upperPanel = this.createUpperPanel();
        this.add((Component)upperPanel, "North");
        WmiPaletteDnDManager.installDragListener(this.label, this);
    }

    private JPanel createUpperPanel() {
        JPanel upperPanel = new JPanel(new GridBagLayout());
        upperPanel.setOpaque(false);
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 0.0;
        g.weighty = 0.0;
        g.ipadx = 2;
        g.fill = 0;
        g.anchor = 17;
        this.triangle = new WmiDisclosureTriangle(true, 2);
        this.triangle.addActionListener(new DisclosureTriangleListener());
        upperPanel.add((Component)this.triangle, g);
        ++g.gridx;
        g.weightx = 1.0;
        g.fill = 1;
        this.label = new JLabel();
        this.label.setFont(this.getFont());
        this.label.setForeground(Color.WHITE);
        this.label.addMouseListener(new PaletteMouseListener());
        upperPanel.add((Component)this.label, g);
        return upperPanel;
    }

    public String getTitle() {
        if (this.label != null) {
            return this.label.getText();
        }
        return "";
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setTitle(String title) {
        if (this.label != null) {
            this.label.setText(title);
        }
    }

    public void setTitleColor(Color c) {
        if (this.label != null) {
            this.label.setForeground(c);
        }
    }

    public Color getTitleColor() {
        if (this.label != null) {
            return this.label.getForeground();
        }
        return null;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, false);
    }

    public void setExpanded(boolean expanded, boolean animate) {
        if (this.triangle != null) {
            this.triangle.setSelected(expanded);
        }
        if (this.content != null && expanded != this.wasExpanded) {
            this.wasExpanded = expanded;
            Dimension currentDim = this.getSize();
            Dimension contentDim = this.content.getSize();
            Dimension d = new Dimension(currentDim);
            if (expanded) {
                this.setContent(this.content);
                d.height += contentDim.height;
            } else {
                if (animate) {
                    this.contentGhostImage = new BufferedImage(contentDim.width, contentDim.height, 2);
                    Graphics2D g = (Graphics2D)this.contentGhostImage.getGraphics();
                    g.setColor(Color.BLUE);
                    g.fillRect(0, 0, contentDim.width, contentDim.height);
                    this.content.paint(g);
                    g.dispose();
                    this.contentX = this.content.getX();
                    this.contentY = this.content.getY();
                }
                this.remove(this.content);
                d.height -= contentDim.height;
            }
            if (animate) {
                this.animateResize(currentDim, d);
            } else {
                this.setSize(d);
                this.invalidate();
                Container c = this.getParent();
                if (c != null) {
                    c.validate();
                    c.repaint();
                }
            }
        }
    }

    public boolean isExpanded() {
        return this.triangle != null ? this.triangle.isSelected() : false;
    }

    public void setExpandEnabled(boolean enabled) {
        if (this.triangle != null) {
            this.triangle.setEnabled(enabled);
        }
    }

    public boolean isExpandEnabled() {
        if (this.triangle != null) {
            return this.triangle.isEnabled();
        }
        return false;
    }

    protected void setContent(JComponent c) {
        this.content = c;
        this.content.setOpaque(true);
        this.add((Component)this.content, "Center");
        this.content.invalidate();
        this.content.doLayout();
    }

    protected JComponent getContent() {
        return this.content;
    }

    @Override
    public void paint(Graphics g) {
        Shape oldClip = null;
        if (this.animatedResizeDim != null) {
            oldClip = g.getClip();
            Dimension d = this.getSize();
            Rectangle r = new Rectangle(0, 0, d.width, d.height);
            if (oldClip != null) {
                Rectangle s = oldClip.getBounds();
                SwingUtilities.computeIntersection(s.x, s.y, s.width, s.height, r);
            }
            g.setClip(r);
        }
        super.paintComponent(g);
        if (this.contentGhostImage != null) {
            g.drawImage(this.contentGhostImage, this.contentX, this.contentY, null);
        }
        super.paintChildren(g);
        if (oldClip != null) {
            g.setClip(oldClip);
        }
    }

    protected Window getParentWindow() {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
    }

    public void dragAndDropStarted() {
    }

    public void dragAndDropEnded(boolean success) {
        if (success) {
            this.invalidateParent();
            this.invalidateScrollPane();
        } else {
            WmiPaletteDnDManager.cancelPaletteDrag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createImage() {
        int w = this.getWidth();
        int h = Math.min(this.getHeight(), 600);
        if (w <= 0) {
            w = 250;
        }
        if (h <= 0) {
            h = 14;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)((Image)img).getGraphics();
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPalette wmiPalette = this;
            synchronized (wmiPalette) {
                this.animatedResizeDim = new Dimension(w, h);
                this.paint(g);
                this.animatedResizeDim = null;
            }
        }
        g.dispose();
        return img;
    }

    protected int getContentWidth() {
        Container c = this.getParent();
        return c != null ? c.getWidth() - 8 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void animateResize(Dimension oldSize, Dimension newSize) {
        WmiPalette wmiPalette = this;
        synchronized (wmiPalette) {
            if (this.animatedResizeDim == null) {
                this.animatedResizeDim = this.getSize();
                PaletteGroupResizer resizer = new PaletteGroupResizer(oldSize, newSize);
                Thread t = new Thread(resizer);
                t.setName("palette animate resize thread");
                t.start();
            }
        }
    }

    @Override
    public synchronized Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public synchronized Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        Dimension d = this.animatedResizeDim != null ? this.animatedResizeDim : super.getPreferredSize();
        d.width = this.getContentWidth();
        return d;
    }

    @Override
    public synchronized Dimension getSize() {
        return this.animatedResizeDim != null ? this.animatedResizeDim : super.getSize();
    }

    @Override
    public synchronized int getWidth() {
        return this.animatedResizeDim != null ? this.animatedResizeDim.width : super.getWidth();
    }

    @Override
    public synchronized int getHeight() {
        return this.animatedResizeDim != null ? this.animatedResizeDim.width : super.getHeight();
    }

    protected void invalidateParent() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.invalidate();
            parent.doLayout();
            parent.repaint();
        }
    }

    protected void invalidateScrollPane() {
        JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (vp != null) {
            vp.invalidate();
            vp.doLayout();
            vp.repaint();
        }
    }

    @Override
    public boolean canStack() {
        return false;
    }

    @Override
    public boolean contains(WmiDockable dockable) {
        return false;
    }

    @Override
    public void dock(WmiDockingHost host, int location) throws WmiDockException {
        host.dock(this, location);
    }

    @Override
    public void dock(WmiDockingHost host) throws WmiDockException {
        this.dock(host, 3);
    }

    @Override
    public Component getDockableComponent() {
        return this;
    }

    @Override
    public void undock(WmiDockingHost host) {
    }

    private class DisclosureTriangleListener
    implements ActionListener {
        private DisclosureTriangleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = WmiPalette.this.getTreeLock();
            synchronized (object) {
                WmiPalette wmiPalette = WmiPalette.this;
                synchronized (wmiPalette) {
                    if (WmiPalette.this.animatedResizeDim == null) {
                        ButtonModel model = WmiPalette.this.triangle.getModel();
                        WmiPalette.this.setExpanded(model.isSelected(), true);
                    }
                }
            }
        }
    }

    public static class PaletteGroupPanelUI
    extends PanelUI {
        private static PaletteGroupPanelUI instance = null;
        private static final int ROUNDNESS = RuntimePlatform.isMac() ? 15 : 8;

        private PaletteGroupPanelUI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            Font font = c.getFont();
            float fontSize = 0.0f;
            fontSize = RuntimePlatform.isMac() ? 10.0f : 11.0f;
            font = font.deriveFont(fontSize);
            c.setFont(font);
            c.setOpaque(true);
            c.setBorder(BorderFactory.createEmptyBorder(5, 4, 5, 4));
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            this.paint(g, c.getSize(), c.getForeground(), false);
        }

        public void paint(Graphics g, Dimension d, Color c, boolean selected) {
            Graphics2D g2 = (Graphics2D)g;
            Color color = g2.getColor();
            Object alias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setColor(c);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Paint paint = g2.getPaint();
            if (RuntimePlatform.isMac()) {
                Color gcolor = selected ? Color.DARK_GRAY : Color.LIGHT_GRAY;
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, selected ? Color.BLACK : Color.WHITE, 0.0f, 10.0f, gcolor);
                Shape s = g2.getClip();
                Rectangle r = new Rectangle(0, 0, d.width - 1, 10);
                if (s instanceof Rectangle) {
                    r = r.intersection((Rectangle)s);
                }
                g2.setClip(r);
                g2.setPaint(gp);
                g2.fillRoundRect(0, 0, d.width - 1, d.height - 1, ROUNDNESS, ROUNDNESS);
                r = new Rectangle(0, 10, d.width - 1, d.height - 11);
                if (s instanceof Rectangle) {
                    r = r.intersection((Rectangle)s);
                }
                g2.setClip(r);
                gp = new GradientPaint(0.0f, 10.0f, gcolor, 0.0f, 20.0f, gcolor.brighter());
                g2.setPaint(gp);
                g2.fillRoundRect(0, 0, d.width - 1, d.height - 1, ROUNDNESS, ROUNDNESS);
                g2.setClip(s);
            } else {
                Color gcolor = selected ? Color.GRAY : Color.LIGHT_GRAY;
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, gcolor.brighter(), 0.0f, 20.0f, gcolor);
                g2.setPaint(gp);
                g2.fillRoundRect(0, 0, d.width - 1, d.height - 1, ROUNDNESS, ROUNDNESS);
            }
            g2.setPaint(paint);
            g2.drawRoundRect(0, 0, d.width - 1, d.height - 1, ROUNDNESS, ROUNDNESS);
            g2.setColor(color);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, alias);
        }

        public static PaletteGroupPanelUI getInstance() {
            if (instance == null) {
                instance = new PaletteGroupPanelUI();
            }
            return instance;
        }
    }

    private class PaletteGroupResizer
    implements Runnable {
        private static final int ANIMATION_TIME = 100;
        private static final int FRAME_DELAY = 10;
        private static final int MIN_STEP_SIZE = 10;
        private long startTime = System.currentTimeMillis();
        private Dimension currentSize = null;
        private Dimension targetSize = null;

        public PaletteGroupResizer(Dimension currentSize, Dimension targetSize) {
            this.currentSize = currentSize;
            this.targetSize = targetSize;
        }

        @Override
        public void run() {
            block11: {
                WmiPaletteStackPanel panel;
                Dimension oldSize = new Dimension(this.currentSize);
                float steps = 10.0f;
                float deltaX = this.targetSize.width - oldSize.width;
                float deltaY = this.targetSize.height - oldSize.height;
                deltaX /= steps;
                deltaY /= steps;
                deltaX = this.checkStepSize(deltaX);
                deltaY = this.checkStepSize(deltaY);
                Container parent = WmiPalette.this.getParent();
                WmiPaletteStackPanel wmiPaletteStackPanel = panel = parent instanceof WmiPaletteStackPanel ? (WmiPaletteStackPanel)parent : null;
                if (panel != null) {
                    panel.setChildResizing(true);
                }
                try {
                    try {
                        int i = 0;
                        while ((float)i < steps) {
                            long t = System.currentTimeMillis();
                            float step = (t -= this.startTime) / 10L;
                            this.resize(deltaX, deltaY, step, oldSize);
                            if (((WmiPalette)WmiPalette.this).animatedResizeDim.width != this.targetSize.width || ((WmiPalette)WmiPalette.this).animatedResizeDim.height != this.targetSize.height) {
                                Thread.sleep(10L);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        WmiPalette.this.animatedResizeDim = null;
                        WmiPalette.this.contentGhostImage = null;
                        if (panel != null) {
                            panel.setChildResizing(false);
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    WmiPalette.this.animatedResizeDim = null;
                    WmiPalette.this.contentGhostImage = null;
                    if (panel != null) {
                        panel.setChildResizing(false);
                    }
                    throw throwable;
                }
                WmiPalette.this.animatedResizeDim = null;
                WmiPalette.this.contentGhostImage = null;
                if (panel != null) {
                    panel.setChildResizing(false);
                }
            }
            this.scrollToVisible();
        }

        private float checkStepSize(float delta) {
            delta = delta > 0.0f ? Math.max(10.0f, delta) : Math.min(-10.0f, delta);
            return delta;
        }

        private void resize(float deltaX, float deltaY, float step, Dimension oldSize) {
            ((WmiPalette)WmiPalette.this).animatedResizeDim.height = oldSize.height + (int)(deltaY * step);
            ((WmiPalette)WmiPalette.this).animatedResizeDim.height = deltaY > 0.0f ? Math.min(((WmiPalette)WmiPalette.this).animatedResizeDim.height, this.targetSize.height) : Math.max(((WmiPalette)WmiPalette.this).animatedResizeDim.height, this.targetSize.height);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WmiPalette.this.invalidate();
                    WmiPalette.this.invalidateParent();
                }
            });
        }

        private void scrollToVisible() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WmiPalette.this.invalidateParent();
                    JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, WmiPalette.this);
                    if (vp != null) {
                        int bottom = WmiPalette.this.getY() + WmiPalette.this.getHeight();
                        Rectangle viewRect = vp.getViewRect();
                        int diff = bottom - (viewRect.y + viewRect.height);
                        if (diff > 0) {
                            vp.setViewPosition(new Point(0, viewRect.y + diff));
                        }
                    }
                    WmiPalette.this.invalidateScrollPane();
                    WmiPalette.this.invalidate();
                    WmiPalette.this.validate();
                }
            });
        }
    }

    private class PaletteMouseListener
    extends MouseAdapter {
        private PaletteMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            Object object = WmiPalette.this.getTreeLock();
            synchronized (object) {
                WmiPalette wmiPalette = WmiPalette.this;
                synchronized (wmiPalette) {
                    if (WmiPalette.this.animatedResizeDim == null) {
                        WmiPalette.this.setExpanded(!WmiPalette.this.isExpanded(), true);
                    }
                }
            }
        }
    }
}

