/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteButtonDnDManager;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.platform.WmiPaletteButtonUIFactory;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.plaf.ButtonUI;

public class WmiPaletteButtonFactory {
    private static final int BUTTON_BORDER_PADDING = 4;
    public static final float DEFAULT_FONT_SIZE = 20.0f;
    protected static final Font DEFAULT_RESOLVE_FONT = new Font("Times New Roman", 0, 20);
    protected WmiMathDocumentView renderView = new WmiMathDocumentView();
    private WmiPaletteButtonDnDManager dndManager = null;
    private JFrame contextFrame = null;

    public WmiPaletteButtonFactory(WmiPaletteButtonDnDManager dndManager) {
        this.dndManager = dndManager;
    }

    public WmiPaletteButtonDnDManager getDnDManager() {
        return this.dndManager;
    }

    public Image renderMathML(String mathml, WmiMathDocumentView docView, int[] baseline, boolean centerVerticalWithBaseline) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathViewUtil.renderMathML(mathml, docView, 4, baseline, centerVerticalWithBaseline, null);
    }

    public Image renderComponent(JComponent c) {
        if (c instanceof JSlider) {
            Dimension size = c.getPreferredSize();
            size.width /= 2;
            c.setPreferredSize(size);
        }
        JFrame dummyFrame = this.getContextFrame();
        dummyFrame.getContentPane().add(c);
        dummyFrame.pack();
        BufferedImage bImage = new BufferedImage(c.getWidth() + 2, c.getHeight() + 2, 2);
        Graphics2D g2 = bImage.createGraphics();
        c.paint(g2);
        g2.dispose();
        dummyFrame.remove(c);
        return bImage;
    }

    private JFrame getContextFrame() {
        if (this.contextFrame == null) {
            this.contextFrame = new JFrame();
        }
        return this.contextFrame;
    }

    public AbstractButton createButton(char unicodeChar) {
        JButton b = new JButton();
        WmiPaletteButtonFactory.installFont(b, unicodeChar);
        ButtonUI ui = WmiPaletteButtonUIFactory.createUI();
        b.setUI(ui);
        this.dndManager.installDragGestureListener(b);
        return b;
    }

    public AbstractButton createButton(String mathML) {
        PaletteButton b;
        block8: {
            b = new PaletteButton();
            if (mathML.startsWith("<mrow")) {
                try {
                    WmiModelLock.writeLock(this.renderView.getModel(), true);
                    int[] baseline = new int[1];
                    Image image = this.renderMathML(mathML, this.renderView, baseline, false);
                    b.setIcon(new ImageIcon(image));
                    b.setBaseline(baseline[0]);
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                    WmiModelLock.writeUnlock(this.renderView.getModel());
                    break block8;
                }
                catch (WmiNoWriteAccessException nwae) {
                    try {
                        WmiErrorLog.log(nwae);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        WmiModelLock.writeUnlock(this.renderView.getModel());
                    }
                }
                WmiModelLock.writeUnlock(this.renderView.getModel());
            }
        }
        ButtonUI ui = WmiPaletteButtonUIFactory.createUI();
        b.setUI(ui);
        this.dndManager.installDragGestureListener(b);
        return b;
    }

    public AbstractButton createButton(JComponent comp) {
        JButton b = new JButton();
        Image ci = this.renderComponent(comp);
        b.setIcon(new ImageIcon(ci));
        ButtonUI ui = WmiPaletteButtonUIFactory.createUI();
        b.setUI(ui);
        this.dndManager.installDragGestureListener(b);
        return b;
    }

    public static void installFont(AbstractButton b, char unicodeChar) {
        String unicodeString = Character.toString(unicodeChar);
        Font font = WmiFontResolver.getFontForCharacter(unicodeString, DEFAULT_RESOLVE_FONT);
        if (font != null) {
            char mapped = WmiFontResolver.mapCharacterForFont(unicodeString.charAt(0), font);
            b.setFont(font.deriveFont(20.0f));
            b.setText(Character.toString(mapped));
        } else {
            b.setFont(DEFAULT_RESOLVE_FONT.deriveFont(20.0f));
            b.setText(unicodeString);
        }
    }

    public static int getBaseline(AbstractButton b) {
        int result = 0;
        if (b instanceof PaletteButton) {
            result = ((PaletteButton)b).getBaseline();
        } else if (b != null) {
            result = b.getHeight() / 2;
        }
        return result;
    }

    public static class PaletteButton
    extends JButton {
        private int baseline;

        public int getBaseline() {
            return this.baseline;
        }

        public void setBaseline(int baseline) {
            this.baseline = baseline;
        }
    }
}

