/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.dockingtools.WmiBorderSplitPane;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.dockingtools.WmiPalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteStackPanel;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WmiPaletteDnDManager {
    private static final String PALETTE_DRAG_MIME_TYPE = "application/x-java-serialized-object;class=java.io.Serializable";
    private static final Transferable PALETTE_DRAG_TRANSFERABLE = new PaletteTransferable();
    public static final DataFlavor PALETTE_DRAG_FLAVOR = new DataFlavor("application/x-java-serialized-object;class=java.io.Serializable", "Maple Palette");
    public static final FlavorMap PALETTE_DRAG_FLAVOR_MAP = new PaletteFlavorMap();
    private static WmiPalette dragPalette = null;
    private static WmiPaletteStackPanel dragOriginPanel = null;
    private static WmiPaletteStackPanel dropTargetPanel = null;
    private static WmiBorderSplitPane dragOriginSplitPane = null;
    private static boolean splitPaneEastCollapsed = false;
    private static boolean splitPaneWestCollapsed = false;
    private static int dragOriginIndex = -1;
    private static boolean paletteDragAccepted = false;
    private static Window dragPaletteOriginWindow = null;

    private WmiPaletteDnDManager() {
    }

    public static void installDragListener(JComponent c, WmiPalette palette) {
        PaletteDragListener dragListener = new PaletteDragListener(palette);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(c, 2, dragListener);
    }

    public static WmiPalette getDraggedPalette() {
        return dragPalette;
    }

    public static Window getDraggedPaletteOriginWindow() {
        return dragPaletteOriginWindow;
    }

    public static Transferable startPaletteDrag(final WmiPalette palette) {
        dragPalette = palette;
        dropTargetPanel = dragOriginPanel = (WmiPaletteStackPanel)SwingUtilities.getAncestorOfClass(WmiPaletteStackPanel.class, palette);
        if (dragOriginPanel != null && (dragOriginSplitPane = (WmiBorderSplitPane)SwingUtilities.getAncestorOfClass(WmiBorderSplitPane.class, dragOriginPanel)) != null) {
            splitPaneEastCollapsed = dragOriginSplitPane.isCollapsed(2);
            splitPaneWestCollapsed = dragOriginSplitPane.isCollapsed(3);
            if (splitPaneEastCollapsed) {
                dragOriginSplitPane.setCollapsed(2, false);
            }
            if (splitPaneWestCollapsed) {
                dragOriginSplitPane.setCollapsed(3, false);
            }
        }
        dragPaletteOriginWindow = palette.getParentWindow();
        if (dragOriginPanel != null) {
            dragOriginIndex = dragOriginPanel.getComponentIndexWhereDocked(palette);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dragOriginPanel.undock(palette, true);
                }
            });
        }
        return PALETTE_DRAG_TRANSFERABLE;
    }

    public static void dragEntered(WmiPaletteStackPanel panel) {
        if (panel != dropTargetPanel) {
            if (dropTargetPanel != null) {
                dropTargetPanel.dragExited();
            }
            dropTargetPanel = panel;
        }
    }

    private static void endPaletteDrag(WmiDockingHost host) {
        if (dragOriginSplitPane != null) {
            Component east = dragOriginSplitPane.getFromLocation(2);
            if (splitPaneEastCollapsed && east != host) {
                dragOriginSplitPane.setCollapsed(2, splitPaneEastCollapsed);
            }
            Component west = dragOriginSplitPane.getFromLocation(3);
            if (splitPaneWestCollapsed && west != host) {
                dragOriginSplitPane.setCollapsed(3, splitPaneWestCollapsed);
            }
        }
        dropTargetPanel = null;
        dragPalette = null;
        dragOriginPanel = null;
        dragOriginIndex = -1;
        paletteDragAccepted = false;
        dragOriginSplitPane = null;
    }

    public static void acceptPaletteDrag(WmiDockingHost host) {
        paletteDragAccepted = true;
        WmiPaletteDnDManager.endPaletteDrag(host);
    }

    public static void cancelPaletteDrag() {
        if (dragOriginPanel != null) {
            dragOriginPanel.dockComponentAtIndex(dragPalette, dragOriginIndex);
        }
        if (dropTargetPanel != null) {
            dropTargetPanel.dragExited();
        }
        WmiPaletteDnDManager.endPaletteDrag(null);
    }

    private static class PaletteDragListener
    implements DragGestureListener,
    DragSourceListener {
        private WmiPalette palette = null;

        public PaletteDragListener(WmiPalette palette) {
            this.palette = palette;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            InputEvent event = dge.getTriggerEvent();
            if (event instanceof MouseEvent && ((MouseEvent)event).getButton() == 1) {
                Transferable t = WmiPaletteDnDManager.startPaletteDrag(this.palette);
                Component c = dge.getComponent();
                if (c instanceof AbstractButton) {
                    ButtonModel model = ((AbstractButton)c).getModel();
                    model.setArmed(false);
                    model.setPressed(false);
                }
                if (DragSource.isDragImageSupported()) {
                    Image img = this.palette.createImage();
                    Point p = new Point(dge.getDragOrigin());
                    p.x = -p.x;
                    p.y = -p.y;
                    while (c != this.palette && c != null) {
                        p.x -= c.getX();
                        p.y -= c.getY();
                        c = c.getParent();
                    }
                    if (c != this.palette) {
                        p.x = -img.getWidth(null);
                        p.y = -img.getHeight(null);
                    }
                    dge.startDrag(DragSource.DefaultMoveDrop, img, p, t, this);
                } else {
                    dge.startDrag(DragSource.DefaultMoveDrop, t, this);
                }
                this.palette.dragAndDropStarted();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            this.palette.dragAndDropEnded(paletteDragAccepted);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    private static class PaletteFlavorMap
    implements FlavorMap {
        private PaletteFlavorMap() {
        }

        public Map getFlavorsForNatives(String[] natives) {
            HashMap<String, DataFlavor> m = new HashMap<String, DataFlavor>(1);
            m.put(WmiPaletteDnDManager.PALETTE_DRAG_MIME_TYPE, PALETTE_DRAG_FLAVOR);
            return m;
        }

        public Map getNativesForFlavors(DataFlavor[] flavors) {
            HashMap<DataFlavor, String> m = new HashMap<DataFlavor, String>(1);
            m.put(PALETTE_DRAG_FLAVOR, WmiPaletteDnDManager.PALETTE_DRAG_MIME_TYPE);
            return m;
        }
    }

    private static class PaletteTransferable
    implements Transferable {
        private PaletteTransferable() {
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return flavor == PALETTE_DRAG_FLAVOR && dragPalette != null ? "Maple Palette" : null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{PALETTE_DRAG_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == PALETTE_DRAG_FLAVOR;
        }
    }
}

