/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.dockingtools.WmiDockable;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.dockingtools.WmiPalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteDnDManager;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteButtonDnDManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class WmiPaletteStackPanel
extends JPanel
implements WmiDockingHost {
    public static final int DOCK_INLINE = 999;
    public static final int DOCK_INTER_VERTICAL_SPACE = 4;
    public static final int DROP_TARGET_STRUT_SIZE = 24;
    public static final Insets AUTOSCROLL_INSETS = new Insets(100, 0, 150, 0);
    public static final Insets NO_AUTOSCROLL_INSETS = new Insets(0, 0, 0, 0);
    public static final int AUTOSCROLL_DELTA_Y = 60;
    protected PaletteStackContentPanel content = null;
    protected JViewport viewport = null;
    protected WmiDockingHost host = null;
    private boolean isChildResizing = false;
    private int targetIndex = -1;
    private Window myWindow = null;
    private StrutResizer resizer = null;

    public WmiPaletteStackPanel() {
        this((WmiDockingHost)null);
    }

    public WmiPaletteStackPanel(WmiDockingHost host) {
        this.host = host;
        this.configurePanel();
    }

    public void configurePanel() {
        this.setLayout(new BorderLayout());
        this.content = new PaletteStackContentPanel();
        this.content.add(new PanelFiller());
        PaletteStackDropTarget dropListener = new PaletteStackDropTarget();
        this.content.setDropTarget(new DropTarget(this.content, 2, dropListener, true, WmiPaletteDnDManager.PALETTE_DRAG_FLAVOR_MAP));
        BoxLayout layout = new BoxLayout(this.content, 1);
        this.content.setLayout(layout);
        JScrollPane jsp = new JScrollPane(this.content, 22, 31);
        this.viewport = jsp.getViewport();
        this.add((Component)jsp, "Center");
        this.resizer = new StrutResizer();
        Thread t = new Thread(this.resizer);
        t.setName("palette panel movement animation thread");
        t.start();
    }

    public void release() {
        if (this.resizer != null) {
            this.resizer.interrupt();
            this.resizer = null;
        }
    }

    @Override
    public void invalidate() {
        if (!this.isChildResizing) {
            this.content.invalidate();
        }
        super.invalidate();
    }

    public void setChildResizing(boolean isChildResizing) {
        this.isChildResizing = isChildResizing;
    }

    public Iterator getPaletteIterator() {
        return new PaletteIterator();
    }

    public void addPopupListener(MouseListener l) {
        this.content.addMouseListener(l);
    }

    @Override
    public void dock(WmiDockable dockable) {
        this.dockComponentAtIndex(dockable, -1);
    }

    @Override
    public void dock(WmiDockable dockable, int location) {
        this.dockComponentAtIndex(dockable, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dockComponentAtIndex(WmiDockable dockable, int componentIndex) {
        if (dockable instanceof Component) {
            Object object = this.getTreeLock();
            synchronized (object) {
                PanelFiller filler = new PanelFiller();
                if (componentIndex < 0 || componentIndex >= this.content.getComponentCount()) {
                    componentIndex = this.content.getComponentCount() - 1;
                }
                if (componentIndex % 2 == 1) {
                    --componentIndex;
                }
                this.content.add((Component)filler, componentIndex);
                this.content.add((Component)((Object)dockable), componentIndex + 1);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.invalidate();
                    this.validate();
                    this.repaint();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WmiPaletteStackPanel.this.invalidate();
                            WmiPaletteStackPanel.this.validate();
                            WmiPaletteStackPanel.this.repaint();
                        }
                    });
                }
            }
        }
    }

    @Override
    public WmiDockable getDocked() {
        return this.getDocked(0);
    }

    @Override
    public WmiDockable getDocked(int location) {
        if (location % 2 == 0) {
            ++location;
        }
        return this.content.getComponentCount() > location ? (WmiDockable)((Object)this.content.getComponent(location)) : null;
    }

    @Override
    public int getWhereDocked(WmiDockable target) {
        return this.getComponentIndexWhereDocked(target) != -1 ? 999 : -1;
    }

    public int getComponentIndexWhereDocked(WmiDockable target) {
        int loc = -1;
        int i = 0;
        while (i < this.content.getComponentCount()) {
            if (this.content.getComponent(i) == target) {
                loc = i;
                break;
            }
            ++i;
        }
        return loc;
    }

    @Override
    public WmiDockable undock(WmiDockable dockable) {
        return this.undock(dockable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WmiDockable undock(WmiDockable dockable, boolean resizeStrut) {
        WmiDockable removed = null;
        if (dockable instanceof Component) {
            Object object = this.getTreeLock();
            synchronized (object) {
                int i = 0;
                while (i < this.content.getComponentCount()) {
                    if (this.content.getComponent(i) == dockable && i > 0) {
                        if (resizeStrut && i + 1 < this.content.getComponentCount()) {
                            Component strutToResize = this.content.getComponent(i + 1);
                            int h = ((Component)((Object)dockable)).getHeight();
                            strutToResize.setSize(0, h);
                        }
                        this.content.remove(i - 1);
                        break;
                    }
                    ++i;
                }
                this.content.remove((Component)((Object)dockable));
                this.invalidate();
                this.validate();
                this.repaint();
            }
            removed = dockable;
        }
        return removed;
    }

    public void undockAll() {
        this.content.removeAll();
        this.content.add(new PanelFiller());
        this.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public boolean isValidDockLocation(int doclocation) {
        return doclocation == 999;
    }

    @Override
    public boolean isDocked(WmiDockable dockable) {
        return this.getWhereDocked(dockable) == 999;
    }

    @Override
    public boolean isDockOpen(int doclocation) {
        return doclocation == 999;
    }

    @Override
    public int getPreferredDockLocation() {
        return 999;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetStrut(int strut) {
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPaletteStackPanel wmiPaletteStackPanel = this;
            synchronized (wmiPaletteStackPanel) {
                if (strut != this.targetIndex) {
                    this.targetIndex = strut;
                    this.setTargetHighlight(this.targetIndex != -1);
                    this.notifyAll();
                }
            }
        }
    }

    private void setTargetHighlight(boolean b) {
        Component c;
        if (this.targetIndex >= 0 && this.targetIndex < this.content.getComponentCount() && (c = this.content.getComponent(this.targetIndex)) instanceof PanelFiller) {
            ((PanelFiller)c).setHighlight(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragExited() {
        this.targetStrut(-1);
        this.myWindow = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPaletteStackPanel wmiPaletteStackPanel = this;
            synchronized (wmiPaletteStackPanel) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Dimension d = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPaletteStackPanel wmiPaletteStackPanel = this;
            synchronized (wmiPaletteStackPanel) {
                d = super.getPreferredSize();
            }
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getSize() {
        Dimension d = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPaletteStackPanel wmiPaletteStackPanel = this;
            synchronized (wmiPaletteStackPanel) {
                d = super.getSize();
            }
        }
        return d;
    }

    protected Insets getAutoscrollInsets() {
        return WmiPaletteButtonDnDManager.getDragButton() == null ? AUTOSCROLL_INSETS : NO_AUTOSCROLL_INSETS;
    }

    protected int getAutoscrollAmount() {
        return 60;
    }

    private class PaletteIterator
    implements Iterator {
        private int i = 1;

        private PaletteIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < WmiPaletteStackPanel.this.content.getComponentCount();
        }

        public Object next() {
            int j = this.i;
            this.i += 2;
            return WmiPaletteStackPanel.this.content.getComponent(j);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class PaletteStackContentPanel
    extends JPanel
    implements Scrollable,
    Autoscroll {
        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return WmiPaletteStackPanel.this.viewport.getSize();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Dimension d = this.getPreferredSize();
            Dimension v = WmiPaletteStackPanel.this.viewport.getSize();
            return v.height > d.height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            Object object = this.getTreeLock();
            synchronized (object) {
                WmiPaletteStackPanel wmiPaletteStackPanel = WmiPaletteStackPanel.this;
                synchronized (wmiPaletteStackPanel) {
                    super.doLayout();
                }
            }
        }

        @Override
        public void autoscroll(Point cursorLocn) {
            int delta = this.getAutoscrollDeltaY(cursorLocn);
            if (delta != 0) {
                Rectangle r = this.getVisibleRect();
                r.y += delta;
                this.scrollRectToVisible(r);
            }
        }

        public int getAutoscrollDeltaY(Point cursorLocn) {
            Rectangle r = this.getVisibleRect();
            int delta = 0;
            Insets insets = WmiPaletteStackPanel.this.getAutoscrollInsets();
            int deltaY = WmiPaletteStackPanel.this.getAutoscrollAmount();
            if (cursorLocn.y <= r.y + insets.top) {
                delta = Math.max(r.y - deltaY, 0) - r.y;
            } else if (cursorLocn.y >= r.y + r.height - insets.bottom) {
                delta = Math.min(r.y + deltaY, this.getHeight() - r.height) - r.y;
            }
            return delta;
        }

        @Override
        public Insets getAutoscrollInsets() {
            Rectangle r = this.getVisibleRect();
            Insets insets = WmiPaletteStackPanel.this.getAutoscrollInsets();
            return new Insets(insets.top + r.y, 0, this.getHeight() - r.y - r.height + insets.bottom, 0);
        }
    }

    public class PaletteStackDropTarget
    implements DropTargetListener {
        public boolean acceptOrRejectDrag(Point p) {
            int delta;
            boolean accepted;
            Window paletteWindow = WmiPaletteDnDManager.getDraggedPaletteOriginWindow();
            boolean bl = accepted = WmiPaletteStackPanel.this.myWindow == paletteWindow;
            if (accepted && (delta = WmiPaletteStackPanel.this.content.getAutoscrollDeltaY(p)) != 0) {
                Rectangle r = WmiPaletteStackPanel.this.content.getVisibleRect();
                accepted = r.y == 0 && delta < 0 || r.y + r.height == WmiPaletteStackPanel.this.content.getHeight() && delta > 0;
            }
            return accepted;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            WmiPaletteStackPanel.this.myWindow = (Window)SwingUtilities.getAncestorOfClass(Window.class, WmiPaletteStackPanel.this);
            if (this.acceptOrRejectDrag(dtde.getLocation())) {
                dtde.acceptDrag(2);
                WmiPaletteDnDManager.dragEntered(WmiPaletteStackPanel.this);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            WmiPaletteStackPanel.this.dragExited();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Point p = dtde.getLocation();
            if (this.acceptOrRejectDrag(p)) {
                p.x = WmiPaletteStackPanel.this.getWidth() / 2;
                int found = WmiPaletteStackPanel.this.content.getComponentCount() - 1;
                int i = WmiPaletteStackPanel.this.content.getComponentCount() - 2;
                while (i > 0) {
                    Component c = WmiPaletteStackPanel.this.content.getComponent(i);
                    int y = c.getY();
                    if (y + c.getHeight() / 2 < p.y) break;
                    found = i - 1;
                    i -= 2;
                }
                WmiPaletteStackPanel.this.targetStrut(found);
                dtde.acceptDrag(2);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            WmiPalette palette;
            Transferable t;
            boolean success = false;
            if (this.acceptOrRejectDrag(dtde.getLocation()) && (t = dtde.getTransferable()).isDataFlavorSupported(WmiPaletteDnDManager.PALETTE_DRAG_FLAVOR) && (palette = WmiPaletteDnDManager.getDraggedPalette()) != null) {
                dtde.acceptDrop(2);
                success = true;
                WmiPaletteDnDManager.acceptPaletteDrag(WmiPaletteStackPanel.this);
                if (WmiPaletteStackPanel.this.targetIndex != -1) {
                    WmiPaletteStackPanel.this.content.getComponent(WmiPaletteStackPanel.this.targetIndex).setSize(0, 4);
                }
                WmiPaletteStackPanel.this.dockComponentAtIndex(palette, WmiPaletteStackPanel.this.targetIndex);
                palette.invalidate();
                palette.doLayout();
                WmiPaletteStackPanel.this.viewport.invalidate();
                WmiPaletteStackPanel.this.viewport.doLayout();
                WmiPaletteStackPanel.this.viewport.repaint();
            }
            dtde.dropComplete(success);
            WmiPaletteStackPanel.this.targetStrut(-1);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    private class PanelFiller
    extends JPanel {
        private boolean highlight = false;

        public PanelFiller() {
            this.setSize(WmiPaletteStackPanel.this.content.getWidth(), 4);
            this.setOpaque(false);
        }

        public void setHighlight(boolean b) {
            this.highlight = b;
            this.repaint();
        }

        @Override
        public Dimension getSize() {
            Dimension d = super.getSize();
            d.width = WmiPaletteStackPanel.this.content.getWidth();
            return d;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getSize();
        }

        @Override
        public void paint(Graphics g) {
            if (this.highlight) {
                g.setColor(Color.GRAY);
                g.fillRoundRect(5, 5, this.getWidth() - 10, this.getHeight() - 10, 15, 15);
            } else {
                super.paint(g);
            }
        }
    }

    private class StrutResizer
    implements Runnable {
        private static final int MOVEMENT_SIZE = 5;
        private static final int MOVEMENT_DELAY = 2;
        private boolean interrupted = false;

        private StrutResizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void interrupt() {
            WmiPaletteStackPanel wmiPaletteStackPanel = WmiPaletteStackPanel.this;
            synchronized (wmiPaletteStackPanel) {
                this.interrupted = true;
                WmiPaletteStackPanel.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WmiPaletteStackPanel wmiPaletteStackPanel = WmiPaletteStackPanel.this;
                synchronized (wmiPaletteStackPanel) {
                    WmiPaletteStackPanel.this.wait();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while (true) {
                WmiPaletteStackPanel e = WmiPaletteStackPanel.this;
                synchronized (e) {
                    if (this.interrupted) {
                        break;
                    }
                }
                try {
                    boolean neededResize = false;
                    Object object = WmiPaletteStackPanel.this.getTreeLock();
                    synchronized (object) {
                        WmiPaletteStackPanel wmiPaletteStackPanel = WmiPaletteStackPanel.this;
                        synchronized (wmiPaletteStackPanel) {
                            WmiPalette palette = WmiPaletteDnDManager.getDraggedPalette();
                            int i = 0;
                            while (i < WmiPaletteStackPanel.this.content.getComponentCount()) {
                                JComponent c = (JComponent)WmiPaletteStackPanel.this.content.getComponent(i);
                                int h = c.getHeight();
                                int targetSize = 0;
                                targetSize = i == WmiPaletteStackPanel.this.targetIndex && palette != null ? 24 : 4;
                                int delta = Math.max(5, Math.abs(h - targetSize) / 10);
                                if (h > targetSize) {
                                    if ((h -= delta) < targetSize) {
                                        h = targetSize;
                                    }
                                } else if (h < targetSize && (h += delta) > targetSize) {
                                    h = targetSize;
                                }
                                if (h != c.getHeight()) {
                                    neededResize = true;
                                    c.setSize(0, h);
                                }
                                i += 2;
                            }
                        }
                    }
                    if (neededResize) {
                        this.synchroUpdate(WmiPaletteStackPanel.this.content);
                        Thread.sleep(2L);
                        continue;
                    }
                    this.synchroUpdate(WmiPaletteStackPanel.this.viewport);
                    object = WmiPaletteStackPanel.this;
                    synchronized (object) {
                        WmiPaletteStackPanel.this.wait();
                        continue;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private void synchroUpdate(final Component c) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = WmiPaletteStackPanel.this.getTreeLock();
                    synchronized (object) {
                        WmiPaletteStackPanel wmiPaletteStackPanel = WmiPaletteStackPanel.this;
                        synchronized (wmiPaletteStackPanel) {
                            c.invalidate();
                            c.doLayout();
                            WmiPaletteStackPanel.this.repaint();
                        }
                    }
                }
            });
        }
    }
}

