/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.palettes;

import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPalette;
import com.maplesoft.mathdoc.controller.insert.WmiInsertEntityCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import java.awt.Component;

public class WmiMathMLContentInsertionController {
    public static WmiMathMLEditorDocumentView componentToView(Component con) {
        WmiMathMLEditorDocumentView returnedView = null;
        while (con.getParent() != null && !(con instanceof WmiMathMLEditorButtonMenu.WmiMathMLButtonMenuPanel) && !(con instanceof WmiMathMLEditorPalette)) {
            con = con.getParent();
        }
        if (con instanceof WmiMathMLEditorButtonMenu.WmiMathMLButtonMenuPanel) {
            returnedView = ((WmiMathMLEditorButtonMenu.WmiMathMLButtonMenuPanel)con).getPaletteManager().getView();
        } else if (con instanceof WmiMathMLEditorPalette) {
            returnedView = ((WmiMathMLEditorPalette)con).getPaletteManager().getView();
        }
        return returnedView;
    }

    private static void insertInMathOrText(WmiMathMLEditorDocumentView documentView, String twoDMath, WmiModelTag mathTag) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (twoDMath.startsWith("<mrow>")) {
            WmiInsertMathMLCommand cmd = WmiInsertMathMLCommand.DEFAULT_MATHML_INSERTER;
            cmd.doInsertionCommand(documentView, twoDMath);
        } else {
            WmiInsertEntityCommand cmd = WmiInsertEntityCommand.DEFAULT_ENTITY_INSERTER;
            StringBuffer buffy = new StringBuffer();
            buffy.append('&');
            buffy.append(twoDMath);
            buffy.append(';');
            cmd.insert(documentView, buffy.toString());
        }
    }

    public static void insertPaletteContent(Component source, String twoDMath) {
        WmiMathMLContentInsertionController.insertPaletteContent(source, twoDMath, null);
    }

    public static void insertPaletteContent(Component source, String twoDMath, WmiModelTag mathTag) {
        WmiMathDocumentModel doc;
        WmiMathMLEditorDocumentView documentView = WmiMathMLContentInsertionController.componentToView(source);
        if (documentView != null && WmiModelLock.writeLock(doc = (WmiMathDocumentModel)documentView.getModel(), true)) {
            try {
                try {
                    WmiMathMLContentInsertionController.insertInMathOrText(documentView, twoDMath, mathTag);
                }
                catch (WmiNoReadAccessException e1) {
                    WmiErrorLog.log(e1);
                    WmiModelLock.writeUnlock(doc);
                }
                catch (WmiNoWriteAccessException e1) {
                    WmiErrorLog.log(e1);
                    WmiModelLock.writeUnlock(doc);
                }
            }
            finally {
                WmiModelLock.writeUnlock(doc);
            }
        }
    }
}

